/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.commands;

import de.flapdoodle.embed.mongo.commands.ServerAddress;
import java.util.ArrayList;
import java.util.Objects;

public final class ImmutableServerAddress
extends ServerAddress {
    private final String host;
    private final int port;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableServerAddress(Builder builder) {
        if (builder.host != null) {
            this.initShim.host(builder.host);
        }
        if (builder.portIsSet()) {
            this.initShim.port(builder.port);
        }
        this.host = this.initShim.getHost();
        this.port = this.initShim.getPort();
        this.initShim = null;
    }

    private ImmutableServerAddress(String host, int port) {
        this.host = host;
        this.port = port;
        this.initShim = null;
    }

    @Override
    public String getHost() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getHost() : this.host;
    }

    @Override
    public int getPort() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPort() : this.port;
    }

    public final ImmutableServerAddress withHost(String value) {
        String newValue = Objects.requireNonNull(value, "host");
        if (this.host.equals(newValue)) {
            return this;
        }
        return new ImmutableServerAddress(newValue, this.port);
    }

    public final ImmutableServerAddress withPort(int value) {
        if (this.port == value) {
            return this;
        }
        return new ImmutableServerAddress(this.host, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServerAddress && this.equalTo(0, (ImmutableServerAddress)another);
    }

    private boolean equalTo(int synthetic, ImmutableServerAddress another) {
        return this.host.equals(another.host) && this.port == another.port;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.host.hashCode();
        h += (h << 5) + this.port;
        return h;
    }

    public static ImmutableServerAddress copyOf(ServerAddress instance) {
        if (instance instanceof ImmutableServerAddress) {
            return (ImmutableServerAddress)instance;
        }
        return ImmutableServerAddress.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_PORT = 1L;
        private long optBits;
        private String host;
        private int port;

        private Builder() {
        }

        public final Builder from(ServerAddress instance) {
            Objects.requireNonNull(instance, "instance");
            this.host(instance.getHost());
            this.port(instance.getPort());
            return this;
        }

        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            return this;
        }

        public final Builder port(int port) {
            this.port = port;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableServerAddress build() {
            return new ImmutableServerAddress(this);
        }

        private boolean portIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    private final class InitShim {
        private byte hostBuildStage = 0;
        private String host;
        private byte portBuildStage = 0;
        private int port;

        private InitShim() {
        }

        String getHost() {
            if (this.hostBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hostBuildStage == 0) {
                this.hostBuildStage = (byte)-1;
                this.host = Objects.requireNonNull(ImmutableServerAddress.super.getHost(), "host");
                this.hostBuildStage = 1;
            }
            return this.host;
        }

        void host(String host) {
            this.host = host;
            this.hostBuildStage = 1;
        }

        int getPort() {
            if (this.portBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.portBuildStage == 0) {
                this.portBuildStage = (byte)-1;
                this.port = ImmutableServerAddress.super.getPort();
                this.portBuildStage = 1;
            }
            return this.port;
        }

        void port(int port) {
            this.port = port;
            this.portBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.hostBuildStage == -1) {
                attributes.add("host");
            }
            if (this.portBuildStage == -1) {
                attributes.add("port");
            }
            return "Cannot build ServerAddress, attribute initializers form cycle " + attributes;
        }
    }
}

