/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.distribution;

import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.packageresolver.FeatureSet;
import de.flapdoodle.embed.mongo.packageresolver.FeatureSetResolver;
import de.flapdoodle.embed.mongo.packageresolver.NumericVersion;
import de.flapdoodle.embed.process.distribution.Version;
import java.util.Objects;

public class Versions {
    private Versions() {
    }

    public static IFeatureAwareVersion withFeatures(Version version) {
        return new GenericFeatureAwareVersion(version);
    }

    static class GenericFeatureAwareVersion
    implements IFeatureAwareVersion {
        private final Version _version;
        private final FeatureSet featureSet;

        public GenericFeatureAwareVersion(Version version) {
            this._version = version;
            this.featureSet = FeatureSetResolver.defaultInstance().featuresOf(version);
        }

        public String asInDownloadPath() {
            return this._version.asInDownloadPath();
        }

        @Override
        public FeatureSet features() {
            return this.featureSet;
        }

        @Override
        public NumericVersion numericVersion() {
            throw new IllegalArgumentException("not implemented");
        }

        public String toString() {
            return "GenericFeatureAwareVersion{" + this._version.asInDownloadPath() + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GenericFeatureAwareVersion that = (GenericFeatureAwareVersion)o;
            return this._version.equals(that._version) && this.featureSet.equals(that.featureSet);
        }

        public int hashCode() {
            return Objects.hash(this._version, this.featureSet);
        }
    }
}

