
package de.flapdoodle.embed.mongo.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * Immutable implementation of {@link MongoImportArguments}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMongoImportArguments.builder()}.
 */
@SuppressWarnings({"all"})
public final class ImmutableMongoImportArguments
    extends MongoImportArguments {
  private final boolean verbose;
  private final String databaseName;
  private final String collectionName;
  private final String importFile;
  private final Optional<String> type;
  private final boolean isHeaderline;
  private final boolean isJsonArray;
  private final boolean dropCollection;
  private final boolean upsertDocuments;

  private ImmutableMongoImportArguments(ImmutableMongoImportArguments.Builder builder) {
    this.databaseName = builder.databaseName;
    this.collectionName = builder.collectionName;
    this.importFile = builder.importFile;
    if (builder.verboseIsSet()) {
      initShim.verbose(builder.verbose);
    }
    if (builder.type != null) {
      initShim.type(builder.type);
    }
    if (builder.isHeaderlineIsSet()) {
      initShim.isHeaderline(builder.isHeaderline);
    }
    if (builder.isJsonArrayIsSet()) {
      initShim.isJsonArray(builder.isJsonArray);
    }
    if (builder.dropCollectionIsSet()) {
      initShim.dropCollection(builder.dropCollection);
    }
    if (builder.upsertDocumentsIsSet()) {
      initShim.upsertDocuments(builder.upsertDocuments);
    }
    this.verbose = initShim.verbose();
    this.type = initShim.type();
    this.isHeaderline = initShim.isHeaderline();
    this.isJsonArray = initShim.isJsonArray();
    this.dropCollection = initShim.dropCollection();
    this.upsertDocuments = initShim.upsertDocuments();
    this.initShim = null;
  }

  private ImmutableMongoImportArguments(
      boolean verbose,
      String databaseName,
      String collectionName,
      String importFile,
      Optional<String> type,
      boolean isHeaderline,
      boolean isJsonArray,
      boolean dropCollection,
      boolean upsertDocuments) {
    this.verbose = verbose;
    this.databaseName = databaseName;
    this.collectionName = collectionName;
    this.importFile = importFile;
    this.type = type;
    this.isHeaderline = isHeaderline;
    this.isJsonArray = isJsonArray;
    this.dropCollection = dropCollection;
    this.upsertDocuments = upsertDocuments;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private byte verboseBuildStage = STAGE_UNINITIALIZED;
    private boolean verbose;

    boolean verbose() {
      if (verboseBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (verboseBuildStage == STAGE_UNINITIALIZED) {
        verboseBuildStage = STAGE_INITIALIZING;
        this.verbose = ImmutableMongoImportArguments.super.verbose();
        verboseBuildStage = STAGE_INITIALIZED;
      }
      return this.verbose;
    }

    void verbose(boolean verbose) {
      this.verbose = verbose;
      verboseBuildStage = STAGE_INITIALIZED;
    }

    private byte typeBuildStage = STAGE_UNINITIALIZED;
    private Optional<String> type;

    Optional<String> type() {
      if (typeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (typeBuildStage == STAGE_UNINITIALIZED) {
        typeBuildStage = STAGE_INITIALIZING;
        this.type = Objects.requireNonNull(ImmutableMongoImportArguments.super.type(), "type");
        typeBuildStage = STAGE_INITIALIZED;
      }
      return this.type;
    }

    void type(Optional<String> type) {
      this.type = type;
      typeBuildStage = STAGE_INITIALIZED;
    }

    private byte isHeaderlineBuildStage = STAGE_UNINITIALIZED;
    private boolean isHeaderline;

    boolean isHeaderline() {
      if (isHeaderlineBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isHeaderlineBuildStage == STAGE_UNINITIALIZED) {
        isHeaderlineBuildStage = STAGE_INITIALIZING;
        this.isHeaderline = ImmutableMongoImportArguments.super.isHeaderline();
        isHeaderlineBuildStage = STAGE_INITIALIZED;
      }
      return this.isHeaderline;
    }

    void isHeaderline(boolean isHeaderline) {
      this.isHeaderline = isHeaderline;
      isHeaderlineBuildStage = STAGE_INITIALIZED;
    }

    private byte isJsonArrayBuildStage = STAGE_UNINITIALIZED;
    private boolean isJsonArray;

    boolean isJsonArray() {
      if (isJsonArrayBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isJsonArrayBuildStage == STAGE_UNINITIALIZED) {
        isJsonArrayBuildStage = STAGE_INITIALIZING;
        this.isJsonArray = ImmutableMongoImportArguments.super.isJsonArray();
        isJsonArrayBuildStage = STAGE_INITIALIZED;
      }
      return this.isJsonArray;
    }

    void isJsonArray(boolean isJsonArray) {
      this.isJsonArray = isJsonArray;
      isJsonArrayBuildStage = STAGE_INITIALIZED;
    }

    private byte dropCollectionBuildStage = STAGE_UNINITIALIZED;
    private boolean dropCollection;

    boolean dropCollection() {
      if (dropCollectionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (dropCollectionBuildStage == STAGE_UNINITIALIZED) {
        dropCollectionBuildStage = STAGE_INITIALIZING;
        this.dropCollection = ImmutableMongoImportArguments.super.dropCollection();
        dropCollectionBuildStage = STAGE_INITIALIZED;
      }
      return this.dropCollection;
    }

    void dropCollection(boolean dropCollection) {
      this.dropCollection = dropCollection;
      dropCollectionBuildStage = STAGE_INITIALIZED;
    }

    private byte upsertDocumentsBuildStage = STAGE_UNINITIALIZED;
    private boolean upsertDocuments;

    boolean upsertDocuments() {
      if (upsertDocumentsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (upsertDocumentsBuildStage == STAGE_UNINITIALIZED) {
        upsertDocumentsBuildStage = STAGE_INITIALIZING;
        this.upsertDocuments = ImmutableMongoImportArguments.super.upsertDocuments();
        upsertDocumentsBuildStage = STAGE_INITIALIZED;
      }
      return this.upsertDocuments;
    }

    void upsertDocuments(boolean upsertDocuments) {
      this.upsertDocuments = upsertDocuments;
      upsertDocumentsBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (verboseBuildStage == STAGE_INITIALIZING) attributes.add("verbose");
      if (typeBuildStage == STAGE_INITIALIZING) attributes.add("type");
      if (isHeaderlineBuildStage == STAGE_INITIALIZING) attributes.add("isHeaderline");
      if (isJsonArrayBuildStage == STAGE_INITIALIZING) attributes.add("isJsonArray");
      if (dropCollectionBuildStage == STAGE_INITIALIZING) attributes.add("dropCollection");
      if (upsertDocumentsBuildStage == STAGE_INITIALIZING) attributes.add("upsertDocuments");
      return "Cannot build MongoImportArguments, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code verbose} attribute
   */
  @Override
  public boolean verbose() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.verbose()
        : this.verbose;
  }

  /**
   * @return The value of the {@code databaseName} attribute
   */
  @Override
  public Optional<String> databaseName() {
    return Optional.ofNullable(databaseName);
  }

  /**
   * @return The value of the {@code collectionName} attribute
   */
  @Override
  public Optional<String> collectionName() {
    return Optional.ofNullable(collectionName);
  }

  /**
   * @return The value of the {@code importFile} attribute
   */
  @Override
  public Optional<String> importFile() {
    return Optional.ofNullable(importFile);
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public Optional<String> type() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.type()
        : this.type;
  }

  /**
   * @return The value of the {@code isHeaderline} attribute
   */
  @Override
  public boolean isHeaderline() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isHeaderline()
        : this.isHeaderline;
  }

  /**
   * @return The value of the {@code isJsonArray} attribute
   */
  @Override
  public boolean isJsonArray() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isJsonArray()
        : this.isJsonArray;
  }

  /**
   * @return The value of the {@code dropCollection} attribute
   */
  @Override
  public boolean dropCollection() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.dropCollection()
        : this.dropCollection;
  }

  /**
   * @return The value of the {@code upsertDocuments} attribute
   */
  @Override
  public boolean upsertDocuments() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.upsertDocuments()
        : this.upsertDocuments;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportArguments#verbose() verbose} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for verbose
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImportArguments withVerbose(boolean value) {
    if (this.verbose == value) return this;
    return new ImmutableMongoImportArguments(
        value,
        this.databaseName,
        this.collectionName,
        this.importFile,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.dropCollection,
        this.upsertDocuments);
  }

  /**
   * Copy the current immutable object by setting a <em>present</em> value for the optional {@link MongoImportArguments#databaseName() databaseName} attribute.
   * @param value The value for databaseName
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableMongoImportArguments withDatabaseName(String value) {
    String newValue = Objects.requireNonNull(value, "databaseName");
    if (Objects.equals(this.databaseName, newValue)) return this;
    return new ImmutableMongoImportArguments(
        this.verbose,
        newValue,
        this.collectionName,
        this.importFile,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.dropCollection,
        this.upsertDocuments);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoImportArguments#databaseName() databaseName} attribute.
   * An equality check is used on inner value to prevent copying of the same value by returning {@code this}.
   * @param optional An optional value for databaseName
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableMongoImportArguments withDatabaseName(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.databaseName, value)) return this;
    return new ImmutableMongoImportArguments(
        this.verbose,
        value,
        this.collectionName,
        this.importFile,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.dropCollection,
        this.upsertDocuments);
  }

  /**
   * Copy the current immutable object by setting a <em>present</em> value for the optional {@link MongoImportArguments#collectionName() collectionName} attribute.
   * @param value The value for collectionName
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableMongoImportArguments withCollectionName(String value) {
    String newValue = Objects.requireNonNull(value, "collectionName");
    if (Objects.equals(this.collectionName, newValue)) return this;
    return new ImmutableMongoImportArguments(
        this.verbose,
        this.databaseName,
        newValue,
        this.importFile,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.dropCollection,
        this.upsertDocuments);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoImportArguments#collectionName() collectionName} attribute.
   * An equality check is used on inner value to prevent copying of the same value by returning {@code this}.
   * @param optional An optional value for collectionName
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableMongoImportArguments withCollectionName(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.collectionName, value)) return this;
    return new ImmutableMongoImportArguments(
        this.verbose,
        this.databaseName,
        value,
        this.importFile,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.dropCollection,
        this.upsertDocuments);
  }

  /**
   * Copy the current immutable object by setting a <em>present</em> value for the optional {@link MongoImportArguments#importFile() importFile} attribute.
   * @param value The value for importFile
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableMongoImportArguments withImportFile(String value) {
    String newValue = Objects.requireNonNull(value, "importFile");
    if (Objects.equals(this.importFile, newValue)) return this;
    return new ImmutableMongoImportArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        newValue,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.dropCollection,
        this.upsertDocuments);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoImportArguments#importFile() importFile} attribute.
   * An equality check is used on inner value to prevent copying of the same value by returning {@code this}.
   * @param optional An optional value for importFile
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableMongoImportArguments withImportFile(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.importFile, value)) return this;
    return new ImmutableMongoImportArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        value,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.dropCollection,
        this.upsertDocuments);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportArguments#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImportArguments withType(Optional<String> value) {
    if (Objects.equals(this.type, value)) return this;
    Optional<String> newValue = Objects.requireNonNull(value, "type");
    return new ImmutableMongoImportArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.importFile,
        newValue,
        this.isHeaderline,
        this.isJsonArray,
        this.dropCollection,
        this.upsertDocuments);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportArguments#isHeaderline() isHeaderline} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isHeaderline
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImportArguments withIsHeaderline(boolean value) {
    if (this.isHeaderline == value) return this;
    return new ImmutableMongoImportArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.importFile,
        this.type,
        value,
        this.isJsonArray,
        this.dropCollection,
        this.upsertDocuments);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportArguments#isJsonArray() isJsonArray} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isJsonArray
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImportArguments withIsJsonArray(boolean value) {
    if (this.isJsonArray == value) return this;
    return new ImmutableMongoImportArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.importFile,
        this.type,
        this.isHeaderline,
        value,
        this.dropCollection,
        this.upsertDocuments);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportArguments#dropCollection() dropCollection} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dropCollection
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImportArguments withDropCollection(boolean value) {
    if (this.dropCollection == value) return this;
    return new ImmutableMongoImportArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.importFile,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        value,
        this.upsertDocuments);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImportArguments#upsertDocuments() upsertDocuments} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for upsertDocuments
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImportArguments withUpsertDocuments(boolean value) {
    if (this.upsertDocuments == value) return this;
    return new ImmutableMongoImportArguments(
        this.verbose,
        this.databaseName,
        this.collectionName,
        this.importFile,
        this.type,
        this.isHeaderline,
        this.isJsonArray,
        this.dropCollection,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMongoImportArguments} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMongoImportArguments
        && equalsByValue((ImmutableMongoImportArguments) another);
  }

  private boolean equalsByValue(ImmutableMongoImportArguments another) {
    return verbose == another.verbose
        && Objects.equals(databaseName, another.databaseName)
        && Objects.equals(collectionName, another.collectionName)
        && Objects.equals(importFile, another.importFile)
        && type.equals(another.type)
        && isHeaderline == another.isHeaderline
        && isJsonArray == another.isJsonArray
        && dropCollection == another.dropCollection
        && upsertDocuments == another.upsertDocuments;
  }

  /**
   * Computes a hash code from attributes: {@code verbose}, {@code databaseName}, {@code collectionName}, {@code importFile}, {@code type}, {@code isHeaderline}, {@code isJsonArray}, {@code dropCollection}, {@code upsertDocuments}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Boolean.hashCode(verbose);
    h += (h << 5) + Objects.hashCode(databaseName);
    h += (h << 5) + Objects.hashCode(collectionName);
    h += (h << 5) + Objects.hashCode(importFile);
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Boolean.hashCode(isHeaderline);
    h += (h << 5) + Boolean.hashCode(isJsonArray);
    h += (h << 5) + Boolean.hashCode(dropCollection);
    h += (h << 5) + Boolean.hashCode(upsertDocuments);
    return h;
  }

  /**
   * Prints the immutable value {@code MongoImportArguments} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("MongoImportArguments{");
    builder.append("verbose=").append(verbose);
    if (databaseName != null) {
      builder.append(", ");
      builder.append("databaseName=").append(databaseName);
    }
    if (collectionName != null) {
      builder.append(", ");
      builder.append("collectionName=").append(collectionName);
    }
    if (importFile != null) {
      builder.append(", ");
      builder.append("importFile=").append(importFile);
    }
    builder.append(", ");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("isHeaderline=").append(isHeaderline);
    builder.append(", ");
    builder.append("isJsonArray=").append(isJsonArray);
    builder.append(", ");
    builder.append("dropCollection=").append(dropCollection);
    builder.append(", ");
    builder.append("upsertDocuments=").append(upsertDocuments);
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link MongoImportArguments} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MongoImportArguments instance
   */
  public static ImmutableMongoImportArguments copyOf(MongoImportArguments instance) {
    if (instance instanceof ImmutableMongoImportArguments) {
      return (ImmutableMongoImportArguments) instance;
    }
    return ImmutableMongoImportArguments.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMongoImportArguments ImmutableMongoImportArguments}.
   * <pre>
   * ImmutableMongoImportArguments.builder()
   *    .verbose(boolean) // optional {@link MongoImportArguments#verbose() verbose}
   *    .databaseName(Optional&lt;String&gt;) // optional {@link MongoImportArguments#databaseName() databaseName}
   *    .collectionName(Optional&lt;String&gt;) // optional {@link MongoImportArguments#collectionName() collectionName}
   *    .importFile(Optional&lt;String&gt;) // optional {@link MongoImportArguments#importFile() importFile}
   *    .type(Optional&lt;String&gt;) // optional {@link MongoImportArguments#type() type}
   *    .isHeaderline(boolean) // optional {@link MongoImportArguments#isHeaderline() isHeaderline}
   *    .isJsonArray(boolean) // optional {@link MongoImportArguments#isJsonArray() isJsonArray}
   *    .dropCollection(boolean) // optional {@link MongoImportArguments#dropCollection() dropCollection}
   *    .upsertDocuments(boolean) // optional {@link MongoImportArguments#upsertDocuments() upsertDocuments}
   *    .build();
   * </pre>
   * @return A new ImmutableMongoImportArguments builder
   */
  public static ImmutableMongoImportArguments.Builder builder() {
    return new ImmutableMongoImportArguments.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMongoImportArguments ImmutableMongoImportArguments}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long OPT_BIT_VERBOSE = 0x1L;
    private static final long OPT_BIT_IS_HEADERLINE = 0x2L;
    private static final long OPT_BIT_IS_JSON_ARRAY = 0x4L;
    private static final long OPT_BIT_DROP_COLLECTION = 0x8L;
    private static final long OPT_BIT_UPSERT_DOCUMENTS = 0x10L;
    private long optBits;

    private boolean verbose;
    private String databaseName;
    private String collectionName;
    private String importFile;
    private Optional<String> type;
    private boolean isHeaderline;
    private boolean isJsonArray;
    private boolean dropCollection;
    private boolean upsertDocuments;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MongoImportArguments} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongoImportArguments instance) {
      Objects.requireNonNull(instance, "instance");
      this.verbose(instance.verbose());
      Optional<String> databaseNameOptional = instance.databaseName();
      if (databaseNameOptional.isPresent()) {
        databaseName(databaseNameOptional);
      }
      Optional<String> collectionNameOptional = instance.collectionName();
      if (collectionNameOptional.isPresent()) {
        collectionName(collectionNameOptional);
      }
      Optional<String> importFileOptional = instance.importFile();
      if (importFileOptional.isPresent()) {
        importFile(importFileOptional);
      }
      this.type(instance.type());
      this.isHeaderline(instance.isHeaderline());
      this.isJsonArray(instance.isJsonArray());
      this.dropCollection(instance.dropCollection());
      this.upsertDocuments(instance.upsertDocuments());
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportArguments#verbose() verbose} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImportArguments#verbose() verbose}.</em>
     * @param verbose The value for verbose 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder verbose(boolean verbose) {
      this.verbose = verbose;
      optBits |= OPT_BIT_VERBOSE;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoImportArguments#databaseName() databaseName} to databaseName.
     * @param databaseName The value for databaseName
     * @return {@code this} builder for chained invocation
     */
    public final Builder databaseName(String databaseName) {
      this.databaseName = Objects.requireNonNull(databaseName, "databaseName");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoImportArguments#databaseName() databaseName} to databaseName.
     * @param databaseName The value for databaseName
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder databaseName(Optional<String> databaseName) {
      this.databaseName = databaseName.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoImportArguments#collectionName() collectionName} to collectionName.
     * @param collectionName The value for collectionName
     * @return {@code this} builder for chained invocation
     */
    public final Builder collectionName(String collectionName) {
      this.collectionName = Objects.requireNonNull(collectionName, "collectionName");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoImportArguments#collectionName() collectionName} to collectionName.
     * @param collectionName The value for collectionName
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder collectionName(Optional<String> collectionName) {
      this.collectionName = collectionName.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoImportArguments#importFile() importFile} to importFile.
     * @param importFile The value for importFile
     * @return {@code this} builder for chained invocation
     */
    public final Builder importFile(String importFile) {
      this.importFile = Objects.requireNonNull(importFile, "importFile");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoImportArguments#importFile() importFile} to importFile.
     * @param importFile The value for importFile
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder importFile(Optional<String> importFile) {
      this.importFile = importFile.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportArguments#type() type} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImportArguments#type() type}.</em>
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(Optional<String> type) {
      this.type = Objects.requireNonNull(type, "type");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportArguments#isHeaderline() isHeaderline} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImportArguments#isHeaderline() isHeaderline}.</em>
     * @param isHeaderline The value for isHeaderline 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isHeaderline(boolean isHeaderline) {
      this.isHeaderline = isHeaderline;
      optBits |= OPT_BIT_IS_HEADERLINE;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportArguments#isJsonArray() isJsonArray} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImportArguments#isJsonArray() isJsonArray}.</em>
     * @param isJsonArray The value for isJsonArray 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isJsonArray(boolean isJsonArray) {
      this.isJsonArray = isJsonArray;
      optBits |= OPT_BIT_IS_JSON_ARRAY;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportArguments#dropCollection() dropCollection} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImportArguments#dropCollection() dropCollection}.</em>
     * @param dropCollection The value for dropCollection 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dropCollection(boolean dropCollection) {
      this.dropCollection = dropCollection;
      optBits |= OPT_BIT_DROP_COLLECTION;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImportArguments#upsertDocuments() upsertDocuments} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImportArguments#upsertDocuments() upsertDocuments}.</em>
     * @param upsertDocuments The value for upsertDocuments 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder upsertDocuments(boolean upsertDocuments) {
      this.upsertDocuments = upsertDocuments;
      optBits |= OPT_BIT_UPSERT_DOCUMENTS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMongoImportArguments ImmutableMongoImportArguments}.
     * @return An immutable instance of MongoImportArguments
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMongoImportArguments build() {
      return new ImmutableMongoImportArguments(this);
    }

    private boolean verboseIsSet() {
      return (optBits & OPT_BIT_VERBOSE) != 0;
    }

    private boolean isHeaderlineIsSet() {
      return (optBits & OPT_BIT_IS_HEADERLINE) != 0;
    }

    private boolean isJsonArrayIsSet() {
      return (optBits & OPT_BIT_IS_JSON_ARRAY) != 0;
    }

    private boolean dropCollectionIsSet() {
      return (optBits & OPT_BIT_DROP_COLLECTION) != 0;
    }

    private boolean upsertDocumentsIsSet() {
      return (optBits & OPT_BIT_UPSERT_DOCUMENTS) != 0;
    }
  }
}
