package de.flapdoodle.embed.mongo.types;

import java.nio.file.Path;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _DatabaseDir}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code DatabaseDir.of()}.
 */
@Generated(from = "_DatabaseDir", generator = "Immutables")
@SuppressWarnings({"all"})
public final class DatabaseDir extends de.flapdoodle.embed.mongo.types._DatabaseDir {
  private final Path value;

  private DatabaseDir(Path value) {
    this.value = Objects.requireNonNull(value, "value");
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public Path value() {
    return value;
  }

  /**
   * This instance is equal to all instances of {@code DatabaseDir} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DatabaseDir
        && equalTo(0, (DatabaseDir) another);
  }

  private boolean equalTo(int synthetic, DatabaseDir another) {
    return value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code DatabaseDir} instance.
   * @param value The value for the {@code value} attribute
   * @return An immutable DatabaseDir instance
   */
  public static DatabaseDir of(Path value) {
    return new DatabaseDir(value);
  }
}
