/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.commands;

import de.flapdoodle.embed.mongo.commands.MongodArguments;
import de.flapdoodle.embed.mongo.config.Storage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class ImmutableMongodArguments
extends MongodArguments {
    private final int syncDelay;
    private final boolean useDefaultSyncDelay;
    private final String storageEngine;
    private final boolean isVerbose;
    private final int verbosityLevel;
    private final boolean isQuiet;
    private final boolean useNoPrealloc;
    private final boolean useSmallFiles;
    private final boolean useNoJournal;
    private final boolean enableTextSearch;
    private final boolean auth;
    private final boolean master;
    private final Storage replication;
    private final boolean isConfigServer;
    private final boolean isShardServer;
    private final Map<String, String> params;
    private final Map<String, String> args;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMongodArguments(Builder builder) {
        this.storageEngine = builder.storageEngine;
        this.replication = builder.replication;
        this.params = ImmutableMongodArguments.createUnmodifiableMap(false, false, builder.params);
        this.args = ImmutableMongodArguments.createUnmodifiableMap(false, false, builder.args);
        if (builder.syncDelayIsSet()) {
            this.initShim.syncDelay(builder.syncDelay);
        }
        if (builder.useDefaultSyncDelayIsSet()) {
            this.initShim.useDefaultSyncDelay(builder.useDefaultSyncDelay);
        }
        if (builder.isVerboseIsSet()) {
            this.initShim.isVerbose(builder.isVerbose);
        }
        if (builder.verbosityLevelIsSet()) {
            this.initShim.verbosityLevel(builder.verbosityLevel);
        }
        if (builder.isQuietIsSet()) {
            this.initShim.isQuiet(builder.isQuiet);
        }
        if (builder.useNoPreallocIsSet()) {
            this.initShim.useNoPrealloc(builder.useNoPrealloc);
        }
        if (builder.useSmallFilesIsSet()) {
            this.initShim.useSmallFiles(builder.useSmallFiles);
        }
        if (builder.useNoJournalIsSet()) {
            this.initShim.useNoJournal(builder.useNoJournal);
        }
        if (builder.enableTextSearchIsSet()) {
            this.initShim.enableTextSearch(builder.enableTextSearch);
        }
        if (builder.authIsSet()) {
            this.initShim.auth(builder.auth);
        }
        if (builder.masterIsSet()) {
            this.initShim.master(builder.master);
        }
        if (builder.isConfigServerIsSet()) {
            this.initShim.isConfigServer(builder.isConfigServer);
        }
        if (builder.isShardServerIsSet()) {
            this.initShim.isShardServer(builder.isShardServer);
        }
        this.syncDelay = this.initShim.syncDelay();
        this.useDefaultSyncDelay = this.initShim.useDefaultSyncDelay();
        this.isVerbose = this.initShim.isVerbose();
        this.verbosityLevel = this.initShim.verbosityLevel();
        this.isQuiet = this.initShim.isQuiet();
        this.useNoPrealloc = this.initShim.useNoPrealloc();
        this.useSmallFiles = this.initShim.useSmallFiles();
        this.useNoJournal = this.initShim.useNoJournal();
        this.enableTextSearch = this.initShim.enableTextSearch();
        this.auth = this.initShim.auth();
        this.master = this.initShim.master();
        this.isConfigServer = this.initShim.isConfigServer();
        this.isShardServer = this.initShim.isShardServer();
        this.initShim = null;
    }

    private ImmutableMongodArguments(int syncDelay, boolean useDefaultSyncDelay, String storageEngine, boolean isVerbose, int verbosityLevel, boolean isQuiet, boolean useNoPrealloc, boolean useSmallFiles, boolean useNoJournal, boolean enableTextSearch, boolean auth, boolean master, Storage replication, boolean isConfigServer, boolean isShardServer, Map<String, String> params, Map<String, String> args) {
        this.syncDelay = syncDelay;
        this.useDefaultSyncDelay = useDefaultSyncDelay;
        this.storageEngine = storageEngine;
        this.isVerbose = isVerbose;
        this.verbosityLevel = verbosityLevel;
        this.isQuiet = isQuiet;
        this.useNoPrealloc = useNoPrealloc;
        this.useSmallFiles = useSmallFiles;
        this.useNoJournal = useNoJournal;
        this.enableTextSearch = enableTextSearch;
        this.auth = auth;
        this.master = master;
        this.replication = replication;
        this.isConfigServer = isConfigServer;
        this.isShardServer = isShardServer;
        this.params = params;
        this.args = args;
        this.initShim = null;
    }

    @Override
    public int syncDelay() {
        InitShim shim = this.initShim;
        return shim != null ? shim.syncDelay() : this.syncDelay;
    }

    @Override
    public boolean useDefaultSyncDelay() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useDefaultSyncDelay() : this.useDefaultSyncDelay;
    }

    @Override
    public Optional<String> storageEngine() {
        return Optional.ofNullable(this.storageEngine);
    }

    @Override
    public boolean isVerbose() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isVerbose() : this.isVerbose;
    }

    @Override
    public int verbosityLevel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.verbosityLevel() : this.verbosityLevel;
    }

    @Override
    public boolean isQuiet() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isQuiet() : this.isQuiet;
    }

    @Override
    public boolean useNoPrealloc() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useNoPrealloc() : this.useNoPrealloc;
    }

    @Override
    public boolean useSmallFiles() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useSmallFiles() : this.useSmallFiles;
    }

    @Override
    public boolean useNoJournal() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useNoJournal() : this.useNoJournal;
    }

    @Override
    public boolean enableTextSearch() {
        InitShim shim = this.initShim;
        return shim != null ? shim.enableTextSearch() : this.enableTextSearch;
    }

    @Override
    public boolean auth() {
        InitShim shim = this.initShim;
        return shim != null ? shim.auth() : this.auth;
    }

    @Override
    public boolean master() {
        InitShim shim = this.initShim;
        return shim != null ? shim.master() : this.master;
    }

    @Override
    public Optional<Storage> replication() {
        return Optional.ofNullable(this.replication);
    }

    @Override
    public boolean isConfigServer() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isConfigServer() : this.isConfigServer;
    }

    @Override
    public boolean isShardServer() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isShardServer() : this.isShardServer;
    }

    @Override
    public Map<String, String> params() {
        return this.params;
    }

    @Override
    public Map<String, String> args() {
        return this.args;
    }

    public final ImmutableMongodArguments withSyncDelay(int value) {
        if (this.syncDelay == value) {
            return this;
        }
        return new ImmutableMongodArguments(value, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, this.verbosityLevel, this.isQuiet, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, this.master, this.replication, this.isConfigServer, this.isShardServer, this.params, this.args);
    }

    public final ImmutableMongodArguments withUseDefaultSyncDelay(boolean value) {
        if (this.useDefaultSyncDelay == value) {
            return this;
        }
        return new ImmutableMongodArguments(this.syncDelay, value, this.storageEngine, this.isVerbose, this.verbosityLevel, this.isQuiet, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, this.master, this.replication, this.isConfigServer, this.isShardServer, this.params, this.args);
    }

    public final ImmutableMongodArguments withStorageEngine(String value) {
        String newValue = Objects.requireNonNull(value, "storageEngine");
        if (Objects.equals(this.storageEngine, newValue)) {
            return this;
        }
        return new ImmutableMongodArguments(this.syncDelay, this.useDefaultSyncDelay, newValue, this.isVerbose, this.verbosityLevel, this.isQuiet, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, this.master, this.replication, this.isConfigServer, this.isShardServer, this.params, this.args);
    }

    public final ImmutableMongodArguments withStorageEngine(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.storageEngine, value)) {
            return this;
        }
        return new ImmutableMongodArguments(this.syncDelay, this.useDefaultSyncDelay, value, this.isVerbose, this.verbosityLevel, this.isQuiet, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, this.master, this.replication, this.isConfigServer, this.isShardServer, this.params, this.args);
    }

    public final ImmutableMongodArguments withIsVerbose(boolean value) {
        if (this.isVerbose == value) {
            return this;
        }
        return new ImmutableMongodArguments(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, value, this.verbosityLevel, this.isQuiet, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, this.master, this.replication, this.isConfigServer, this.isShardServer, this.params, this.args);
    }

    public final ImmutableMongodArguments withVerbosityLevel(int value) {
        if (this.verbosityLevel == value) {
            return this;
        }
        return new ImmutableMongodArguments(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, value, this.isQuiet, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, this.master, this.replication, this.isConfigServer, this.isShardServer, this.params, this.args);
    }

    public final ImmutableMongodArguments withIsQuiet(boolean value) {
        if (this.isQuiet == value) {
            return this;
        }
        return new ImmutableMongodArguments(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, this.verbosityLevel, value, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, this.master, this.replication, this.isConfigServer, this.isShardServer, this.params, this.args);
    }

    public final ImmutableMongodArguments withUseNoPrealloc(boolean value) {
        if (this.useNoPrealloc == value) {
            return this;
        }
        return new ImmutableMongodArguments(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, this.verbosityLevel, this.isQuiet, value, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, this.master, this.replication, this.isConfigServer, this.isShardServer, this.params, this.args);
    }

    public final ImmutableMongodArguments withUseSmallFiles(boolean value) {
        if (this.useSmallFiles == value) {
            return this;
        }
        return new ImmutableMongodArguments(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, this.verbosityLevel, this.isQuiet, this.useNoPrealloc, value, this.useNoJournal, this.enableTextSearch, this.auth, this.master, this.replication, this.isConfigServer, this.isShardServer, this.params, this.args);
    }

    public final ImmutableMongodArguments withUseNoJournal(boolean value) {
        if (this.useNoJournal == value) {
            return this;
        }
        return new ImmutableMongodArguments(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, this.verbosityLevel, this.isQuiet, this.useNoPrealloc, this.useSmallFiles, value, this.enableTextSearch, this.auth, this.master, this.replication, this.isConfigServer, this.isShardServer, this.params, this.args);
    }

    public final ImmutableMongodArguments withEnableTextSearch(boolean value) {
        if (this.enableTextSearch == value) {
            return this;
        }
        return new ImmutableMongodArguments(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, this.verbosityLevel, this.isQuiet, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, value, this.auth, this.master, this.replication, this.isConfigServer, this.isShardServer, this.params, this.args);
    }

    public final ImmutableMongodArguments withAuth(boolean value) {
        if (this.auth == value) {
            return this;
        }
        return new ImmutableMongodArguments(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, this.verbosityLevel, this.isQuiet, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, value, this.master, this.replication, this.isConfigServer, this.isShardServer, this.params, this.args);
    }

    public final ImmutableMongodArguments withMaster(boolean value) {
        if (this.master == value) {
            return this;
        }
        return new ImmutableMongodArguments(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, this.verbosityLevel, this.isQuiet, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, value, this.replication, this.isConfigServer, this.isShardServer, this.params, this.args);
    }

    public final ImmutableMongodArguments withReplication(Storage value) {
        Storage newValue = Objects.requireNonNull(value, "replication");
        if (this.replication == newValue) {
            return this;
        }
        return new ImmutableMongodArguments(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, this.verbosityLevel, this.isQuiet, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, this.master, newValue, this.isConfigServer, this.isShardServer, this.params, this.args);
    }

    public final ImmutableMongodArguments withReplication(Optional<? extends Storage> optional) {
        Storage value = optional.orElse(null);
        if (this.replication == value) {
            return this;
        }
        return new ImmutableMongodArguments(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, this.verbosityLevel, this.isQuiet, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, this.master, value, this.isConfigServer, this.isShardServer, this.params, this.args);
    }

    public final ImmutableMongodArguments withIsConfigServer(boolean value) {
        if (this.isConfigServer == value) {
            return this;
        }
        return new ImmutableMongodArguments(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, this.verbosityLevel, this.isQuiet, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, this.master, this.replication, value, this.isShardServer, this.params, this.args);
    }

    public final ImmutableMongodArguments withIsShardServer(boolean value) {
        if (this.isShardServer == value) {
            return this;
        }
        return new ImmutableMongodArguments(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, this.verbosityLevel, this.isQuiet, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, this.master, this.replication, this.isConfigServer, value, this.params, this.args);
    }

    public final ImmutableMongodArguments withParams(Map<String, ? extends String> entries) {
        if (this.params == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableMongodArguments.createUnmodifiableMap(true, false, entries);
        return new ImmutableMongodArguments(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, this.verbosityLevel, this.isQuiet, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, this.master, this.replication, this.isConfigServer, this.isShardServer, newValue, this.args);
    }

    public final ImmutableMongodArguments withArgs(Map<String, ? extends String> entries) {
        if (this.args == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableMongodArguments.createUnmodifiableMap(true, false, entries);
        return new ImmutableMongodArguments(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, this.verbosityLevel, this.isQuiet, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, this.master, this.replication, this.isConfigServer, this.isShardServer, this.params, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongodArguments && this.equalTo(0, (ImmutableMongodArguments)another);
    }

    private boolean equalTo(int synthetic, ImmutableMongodArguments another) {
        return this.syncDelay == another.syncDelay && this.useDefaultSyncDelay == another.useDefaultSyncDelay && Objects.equals(this.storageEngine, another.storageEngine) && this.isVerbose == another.isVerbose && this.verbosityLevel == another.verbosityLevel && this.isQuiet == another.isQuiet && this.useNoPrealloc == another.useNoPrealloc && this.useSmallFiles == another.useSmallFiles && this.useNoJournal == another.useNoJournal && this.enableTextSearch == another.enableTextSearch && this.auth == another.auth && this.master == another.master && Objects.equals(this.replication, another.replication) && this.isConfigServer == another.isConfigServer && this.isShardServer == another.isShardServer && this.params.equals(another.params) && this.args.equals(another.args);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.syncDelay;
        h += (h << 5) + Boolean.hashCode(this.useDefaultSyncDelay);
        h += (h << 5) + Objects.hashCode(this.storageEngine);
        h += (h << 5) + Boolean.hashCode(this.isVerbose);
        h += (h << 5) + this.verbosityLevel;
        h += (h << 5) + Boolean.hashCode(this.isQuiet);
        h += (h << 5) + Boolean.hashCode(this.useNoPrealloc);
        h += (h << 5) + Boolean.hashCode(this.useSmallFiles);
        h += (h << 5) + Boolean.hashCode(this.useNoJournal);
        h += (h << 5) + Boolean.hashCode(this.enableTextSearch);
        h += (h << 5) + Boolean.hashCode(this.auth);
        h += (h << 5) + Boolean.hashCode(this.master);
        h += (h << 5) + Objects.hashCode(this.replication);
        h += (h << 5) + Boolean.hashCode(this.isConfigServer);
        h += (h << 5) + Boolean.hashCode(this.isShardServer);
        h += (h << 5) + this.params.hashCode();
        h += (h << 5) + this.args.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MongodArguments{");
        builder.append("syncDelay=").append(this.syncDelay);
        builder.append(", ");
        builder.append("useDefaultSyncDelay=").append(this.useDefaultSyncDelay);
        if (this.storageEngine != null) {
            builder.append(", ");
            builder.append("storageEngine=").append(this.storageEngine);
        }
        builder.append(", ");
        builder.append("isVerbose=").append(this.isVerbose);
        builder.append(", ");
        builder.append("verbosityLevel=").append(this.verbosityLevel);
        builder.append(", ");
        builder.append("isQuiet=").append(this.isQuiet);
        builder.append(", ");
        builder.append("useNoPrealloc=").append(this.useNoPrealloc);
        builder.append(", ");
        builder.append("useSmallFiles=").append(this.useSmallFiles);
        builder.append(", ");
        builder.append("useNoJournal=").append(this.useNoJournal);
        builder.append(", ");
        builder.append("enableTextSearch=").append(this.enableTextSearch);
        builder.append(", ");
        builder.append("auth=").append(this.auth);
        builder.append(", ");
        builder.append("master=").append(this.master);
        if (this.replication != null) {
            builder.append(", ");
            builder.append("replication=").append(this.replication);
        }
        builder.append(", ");
        builder.append("isConfigServer=").append(this.isConfigServer);
        builder.append(", ");
        builder.append("isShardServer=").append(this.isShardServer);
        builder.append(", ");
        builder.append("params=").append(this.params);
        builder.append(", ");
        builder.append("args=").append(this.args);
        return builder.append("}").toString();
    }

    public static ImmutableMongodArguments copyOf(MongodArguments instance) {
        if (instance instanceof ImmutableMongodArguments) {
            return (ImmutableMongodArguments)instance;
        }
        return ImmutableMongodArguments.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private static final long OPT_BIT_SYNC_DELAY = 1L;
        private static final long OPT_BIT_USE_DEFAULT_SYNC_DELAY = 2L;
        private static final long OPT_BIT_IS_VERBOSE = 4L;
        private static final long OPT_BIT_VERBOSITY_LEVEL = 8L;
        private static final long OPT_BIT_IS_QUIET = 16L;
        private static final long OPT_BIT_USE_NO_PREALLOC = 32L;
        private static final long OPT_BIT_USE_SMALL_FILES = 64L;
        private static final long OPT_BIT_USE_NO_JOURNAL = 128L;
        private static final long OPT_BIT_ENABLE_TEXT_SEARCH = 256L;
        private static final long OPT_BIT_AUTH = 512L;
        private static final long OPT_BIT_MASTER = 1024L;
        private static final long OPT_BIT_IS_CONFIG_SERVER = 2048L;
        private static final long OPT_BIT_IS_SHARD_SERVER = 4096L;
        private long optBits;
        private int syncDelay;
        private boolean useDefaultSyncDelay;
        private String storageEngine;
        private boolean isVerbose;
        private int verbosityLevel;
        private boolean isQuiet;
        private boolean useNoPrealloc;
        private boolean useSmallFiles;
        private boolean useNoJournal;
        private boolean enableTextSearch;
        private boolean auth;
        private boolean master;
        private Storage replication;
        private boolean isConfigServer;
        private boolean isShardServer;
        private Map<String, String> params = new LinkedHashMap<String, String>();
        private Map<String, String> args = new LinkedHashMap<String, String>();

        private Builder() {
        }

        public final Builder from(MongodArguments instance) {
            Objects.requireNonNull(instance, "instance");
            this.syncDelay(instance.syncDelay());
            this.useDefaultSyncDelay(instance.useDefaultSyncDelay());
            Optional<String> storageEngineOptional = instance.storageEngine();
            if (storageEngineOptional.isPresent()) {
                this.storageEngine(storageEngineOptional);
            }
            this.isVerbose(instance.isVerbose());
            this.verbosityLevel(instance.verbosityLevel());
            this.isQuiet(instance.isQuiet());
            this.useNoPrealloc(instance.useNoPrealloc());
            this.useSmallFiles(instance.useSmallFiles());
            this.useNoJournal(instance.useNoJournal());
            this.enableTextSearch(instance.enableTextSearch());
            this.auth(instance.auth());
            this.master(instance.master());
            Optional<Storage> replicationOptional = instance.replication();
            if (replicationOptional.isPresent()) {
                this.replication(replicationOptional);
            }
            this.isConfigServer(instance.isConfigServer());
            this.isShardServer(instance.isShardServer());
            this.putAllParams(instance.params());
            this.putAllArgs(instance.args());
            return this;
        }

        public final Builder syncDelay(int syncDelay) {
            this.syncDelay = syncDelay;
            this.optBits |= 1L;
            return this;
        }

        public final Builder useDefaultSyncDelay(boolean useDefaultSyncDelay) {
            this.useDefaultSyncDelay = useDefaultSyncDelay;
            this.optBits |= 2L;
            return this;
        }

        public final Builder storageEngine(String storageEngine) {
            this.storageEngine = Objects.requireNonNull(storageEngine, "storageEngine");
            return this;
        }

        public final Builder storageEngine(Optional<String> storageEngine) {
            this.storageEngine = storageEngine.orElse(null);
            return this;
        }

        public final Builder isVerbose(boolean isVerbose) {
            this.isVerbose = isVerbose;
            this.optBits |= 4L;
            return this;
        }

        public final Builder verbosityLevel(int verbosityLevel) {
            this.verbosityLevel = verbosityLevel;
            this.optBits |= 8L;
            return this;
        }

        public final Builder isQuiet(boolean isQuiet) {
            this.isQuiet = isQuiet;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder useNoPrealloc(boolean useNoPrealloc) {
            this.useNoPrealloc = useNoPrealloc;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder useSmallFiles(boolean useSmallFiles) {
            this.useSmallFiles = useSmallFiles;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder useNoJournal(boolean useNoJournal) {
            this.useNoJournal = useNoJournal;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder enableTextSearch(boolean enableTextSearch) {
            this.enableTextSearch = enableTextSearch;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder auth(boolean auth) {
            this.auth = auth;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder master(boolean master) {
            this.master = master;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder replication(Storage replication) {
            this.replication = Objects.requireNonNull(replication, "replication");
            return this;
        }

        public final Builder replication(Optional<? extends Storage> replication) {
            this.replication = replication.orElse(null);
            return this;
        }

        public final Builder isConfigServer(boolean isConfigServer) {
            this.isConfigServer = isConfigServer;
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder isShardServer(boolean isShardServer) {
            this.isShardServer = isShardServer;
            this.optBits |= 0x1000L;
            return this;
        }

        public final Builder putParams(String key, String value) {
            this.params.put(Objects.requireNonNull(key, "params key"), value == null ? Objects.requireNonNull(value, "params value for key: " + key) : value);
            return this;
        }

        public final Builder putParams(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.params.put(Objects.requireNonNull(k, "params key"), v == null ? Objects.requireNonNull(v, "params value for key: " + k) : v);
            return this;
        }

        public final Builder params(Map<String, ? extends String> entries) {
            this.params.clear();
            return this.putAllParams(entries);
        }

        public final Builder putAllParams(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.params.put(Objects.requireNonNull(k, "params key"), v == null ? Objects.requireNonNull(v, "params value for key: " + k) : v);
            }
            return this;
        }

        public final Builder putArgs(String key, String value) {
            this.args.put(Objects.requireNonNull(key, "args key"), value == null ? Objects.requireNonNull(value, "args value for key: " + key) : value);
            return this;
        }

        public final Builder putArgs(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.args.put(Objects.requireNonNull(k, "args key"), v == null ? Objects.requireNonNull(v, "args value for key: " + k) : v);
            return this;
        }

        public final Builder args(Map<String, ? extends String> entries) {
            this.args.clear();
            return this.putAllArgs(entries);
        }

        public final Builder putAllArgs(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.args.put(Objects.requireNonNull(k, "args key"), v == null ? Objects.requireNonNull(v, "args value for key: " + k) : v);
            }
            return this;
        }

        public ImmutableMongodArguments build() {
            return new ImmutableMongodArguments(this);
        }

        private boolean syncDelayIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean useDefaultSyncDelayIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean isVerboseIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean verbosityLevelIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean isQuietIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean useNoPreallocIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean useSmallFilesIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean useNoJournalIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean enableTextSearchIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean authIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean masterIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean isConfigServerIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private boolean isShardServerIsSet() {
            return (this.optBits & 0x1000L) != 0L;
        }
    }

    private final class InitShim {
        private byte syncDelayBuildStage = 0;
        private int syncDelay;
        private byte useDefaultSyncDelayBuildStage = 0;
        private boolean useDefaultSyncDelay;
        private byte isVerboseBuildStage = 0;
        private boolean isVerbose;
        private byte verbosityLevelBuildStage = 0;
        private int verbosityLevel;
        private byte isQuietBuildStage = 0;
        private boolean isQuiet;
        private byte useNoPreallocBuildStage = 0;
        private boolean useNoPrealloc;
        private byte useSmallFilesBuildStage = 0;
        private boolean useSmallFiles;
        private byte useNoJournalBuildStage = 0;
        private boolean useNoJournal;
        private byte enableTextSearchBuildStage = 0;
        private boolean enableTextSearch;
        private byte authBuildStage = 0;
        private boolean auth;
        private byte masterBuildStage = 0;
        private boolean master;
        private byte isConfigServerBuildStage = 0;
        private boolean isConfigServer;
        private byte isShardServerBuildStage = 0;
        private boolean isShardServer;

        private InitShim() {
        }

        int syncDelay() {
            if (this.syncDelayBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.syncDelayBuildStage == 0) {
                this.syncDelayBuildStage = (byte)-1;
                this.syncDelay = ImmutableMongodArguments.super.syncDelay();
                this.syncDelayBuildStage = 1;
            }
            return this.syncDelay;
        }

        void syncDelay(int syncDelay) {
            this.syncDelay = syncDelay;
            this.syncDelayBuildStage = 1;
        }

        boolean useDefaultSyncDelay() {
            if (this.useDefaultSyncDelayBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useDefaultSyncDelayBuildStage == 0) {
                this.useDefaultSyncDelayBuildStage = (byte)-1;
                this.useDefaultSyncDelay = ImmutableMongodArguments.super.useDefaultSyncDelay();
                this.useDefaultSyncDelayBuildStage = 1;
            }
            return this.useDefaultSyncDelay;
        }

        void useDefaultSyncDelay(boolean useDefaultSyncDelay) {
            this.useDefaultSyncDelay = useDefaultSyncDelay;
            this.useDefaultSyncDelayBuildStage = 1;
        }

        boolean isVerbose() {
            if (this.isVerboseBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isVerboseBuildStage == 0) {
                this.isVerboseBuildStage = (byte)-1;
                this.isVerbose = ImmutableMongodArguments.super.isVerbose();
                this.isVerboseBuildStage = 1;
            }
            return this.isVerbose;
        }

        void isVerbose(boolean isVerbose) {
            this.isVerbose = isVerbose;
            this.isVerboseBuildStage = 1;
        }

        int verbosityLevel() {
            if (this.verbosityLevelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.verbosityLevelBuildStage == 0) {
                this.verbosityLevelBuildStage = (byte)-1;
                this.verbosityLevel = ImmutableMongodArguments.super.verbosityLevel();
                this.verbosityLevelBuildStage = 1;
            }
            return this.verbosityLevel;
        }

        void verbosityLevel(int verbosityLevel) {
            this.verbosityLevel = verbosityLevel;
            this.verbosityLevelBuildStage = 1;
        }

        boolean isQuiet() {
            if (this.isQuietBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isQuietBuildStage == 0) {
                this.isQuietBuildStage = (byte)-1;
                this.isQuiet = ImmutableMongodArguments.super.isQuiet();
                this.isQuietBuildStage = 1;
            }
            return this.isQuiet;
        }

        void isQuiet(boolean isQuiet) {
            this.isQuiet = isQuiet;
            this.isQuietBuildStage = 1;
        }

        boolean useNoPrealloc() {
            if (this.useNoPreallocBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useNoPreallocBuildStage == 0) {
                this.useNoPreallocBuildStage = (byte)-1;
                this.useNoPrealloc = ImmutableMongodArguments.super.useNoPrealloc();
                this.useNoPreallocBuildStage = 1;
            }
            return this.useNoPrealloc;
        }

        void useNoPrealloc(boolean useNoPrealloc) {
            this.useNoPrealloc = useNoPrealloc;
            this.useNoPreallocBuildStage = 1;
        }

        boolean useSmallFiles() {
            if (this.useSmallFilesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useSmallFilesBuildStage == 0) {
                this.useSmallFilesBuildStage = (byte)-1;
                this.useSmallFiles = ImmutableMongodArguments.super.useSmallFiles();
                this.useSmallFilesBuildStage = 1;
            }
            return this.useSmallFiles;
        }

        void useSmallFiles(boolean useSmallFiles) {
            this.useSmallFiles = useSmallFiles;
            this.useSmallFilesBuildStage = 1;
        }

        boolean useNoJournal() {
            if (this.useNoJournalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useNoJournalBuildStage == 0) {
                this.useNoJournalBuildStage = (byte)-1;
                this.useNoJournal = ImmutableMongodArguments.super.useNoJournal();
                this.useNoJournalBuildStage = 1;
            }
            return this.useNoJournal;
        }

        void useNoJournal(boolean useNoJournal) {
            this.useNoJournal = useNoJournal;
            this.useNoJournalBuildStage = 1;
        }

        boolean enableTextSearch() {
            if (this.enableTextSearchBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.enableTextSearchBuildStage == 0) {
                this.enableTextSearchBuildStage = (byte)-1;
                this.enableTextSearch = ImmutableMongodArguments.super.enableTextSearch();
                this.enableTextSearchBuildStage = 1;
            }
            return this.enableTextSearch;
        }

        void enableTextSearch(boolean enableTextSearch) {
            this.enableTextSearch = enableTextSearch;
            this.enableTextSearchBuildStage = 1;
        }

        boolean auth() {
            if (this.authBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.authBuildStage == 0) {
                this.authBuildStage = (byte)-1;
                this.auth = ImmutableMongodArguments.super.auth();
                this.authBuildStage = 1;
            }
            return this.auth;
        }

        void auth(boolean auth) {
            this.auth = auth;
            this.authBuildStage = 1;
        }

        boolean master() {
            if (this.masterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.masterBuildStage == 0) {
                this.masterBuildStage = (byte)-1;
                this.master = ImmutableMongodArguments.super.master();
                this.masterBuildStage = 1;
            }
            return this.master;
        }

        void master(boolean master) {
            this.master = master;
            this.masterBuildStage = 1;
        }

        boolean isConfigServer() {
            if (this.isConfigServerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isConfigServerBuildStage == 0) {
                this.isConfigServerBuildStage = (byte)-1;
                this.isConfigServer = ImmutableMongodArguments.super.isConfigServer();
                this.isConfigServerBuildStage = 1;
            }
            return this.isConfigServer;
        }

        void isConfigServer(boolean isConfigServer) {
            this.isConfigServer = isConfigServer;
            this.isConfigServerBuildStage = 1;
        }

        boolean isShardServer() {
            if (this.isShardServerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isShardServerBuildStage == 0) {
                this.isShardServerBuildStage = (byte)-1;
                this.isShardServer = ImmutableMongodArguments.super.isShardServer();
                this.isShardServerBuildStage = 1;
            }
            return this.isShardServer;
        }

        void isShardServer(boolean isShardServer) {
            this.isShardServer = isShardServer;
            this.isShardServerBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.syncDelayBuildStage == -1) {
                attributes.add("syncDelay");
            }
            if (this.useDefaultSyncDelayBuildStage == -1) {
                attributes.add("useDefaultSyncDelay");
            }
            if (this.isVerboseBuildStage == -1) {
                attributes.add("isVerbose");
            }
            if (this.verbosityLevelBuildStage == -1) {
                attributes.add("verbosityLevel");
            }
            if (this.isQuietBuildStage == -1) {
                attributes.add("isQuiet");
            }
            if (this.useNoPreallocBuildStage == -1) {
                attributes.add("useNoPrealloc");
            }
            if (this.useSmallFilesBuildStage == -1) {
                attributes.add("useSmallFiles");
            }
            if (this.useNoJournalBuildStage == -1) {
                attributes.add("useNoJournal");
            }
            if (this.enableTextSearchBuildStage == -1) {
                attributes.add("enableTextSearch");
            }
            if (this.authBuildStage == -1) {
                attributes.add("auth");
            }
            if (this.masterBuildStage == -1) {
                attributes.add("master");
            }
            if (this.isConfigServerBuildStage == -1) {
                attributes.add("isConfigServer");
            }
            if (this.isShardServerBuildStage == -1) {
                attributes.add("isShardServer");
            }
            return "Cannot build MongodArguments, attribute initializers form cycle " + attributes;
        }
    }
}

