/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.config;

import de.flapdoodle.embed.process.builder.AbstractBuilder;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.runtime.ICommandLinePostProcessor;
import de.flapdoodle.embed.process.store.IArtifactStore;

public class RuntimeConfigBuilder
extends AbstractBuilder<IRuntimeConfig> {
    public RuntimeConfigBuilder artifactStore(AbstractBuilder<IArtifactStore> artifactStoreBuilder) {
        return this.artifactStore(artifactStoreBuilder.build());
    }

    public RuntimeConfigBuilder artifactStore(IArtifactStore artifactStore) {
        this.set(IArtifactStore.class, artifactStore);
        return this;
    }

    public RuntimeConfigBuilder processOutput(ProcessOutput processOutput) {
        this.set(ProcessOutput.class, processOutput);
        return this;
    }

    public RuntimeConfigBuilder commandLinePostProcessor(ICommandLinePostProcessor commandLinePostProcessor) {
        this.set(ICommandLinePostProcessor.class, commandLinePostProcessor);
        return this;
    }

    @Override
    public IRuntimeConfig build() {
        IArtifactStore artifactStore = this.get(IArtifactStore.class);
        ProcessOutput processOutput = this.get(ProcessOutput.class);
        ICommandLinePostProcessor commandLinePostProcessor = this.get(ICommandLinePostProcessor.class);
        return new ImmutableRuntimeConfig(artifactStore, processOutput, commandLinePostProcessor);
    }

    static class ImmutableRuntimeConfig
    implements IRuntimeConfig {
        private final ProcessOutput _processOutput;
        private final ICommandLinePostProcessor _commandLinePostProcessor;
        private final IArtifactStore _artifactStore;

        public ImmutableRuntimeConfig(IArtifactStore artifactStore, ProcessOutput processOutput, ICommandLinePostProcessor commandLinePostProcessor) {
            this._artifactStore = artifactStore;
            this._processOutput = processOutput;
            this._commandLinePostProcessor = commandLinePostProcessor;
        }

        @Override
        public ProcessOutput getProcessOutput() {
            return this._processOutput;
        }

        @Override
        public ICommandLinePostProcessor getCommandLinePostProcessor() {
            return this._commandLinePostProcessor;
        }

        @Override
        public IArtifactStore getArtifactStore() {
            return this._artifactStore;
        }
    }
}

