/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.config.store;

import de.flapdoodle.embed.process.builder.AbstractBuilder;
import de.flapdoodle.embed.process.builder.ImmutableContainer;
import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.config.store.IPackageResolver;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.io.progress.IProgressListener;

public class DownloadConfigBuilder
extends AbstractBuilder<IDownloadConfig> {
    private static final String USER_AGENT = "UserAgent";
    private static final String PROGRESS_LISTENER = "ProgressListener";
    private static final String FILE_NAMING = "FileNaming";
    private static final String ARTIFACT_STORE_PATH = "ArtifactStorePath";
    private static final String PACKAGE_RESOLVER = "PackageResolver";
    private static final String DOWNLOAD_PREFIX = "DownloadPrefix";
    private static final String DOWNLOAD_PATH = "DownloadPath";

    public DownloadConfigBuilder downloadPath(String path) {
        this.set(DOWNLOAD_PATH, DownloadPath.class, new DownloadPath(path));
        return this;
    }

    public DownloadConfigBuilder downloadPrefix(String prefix) {
        this.set(DOWNLOAD_PREFIX, DownloadPrefix.class, new DownloadPrefix(prefix));
        return this;
    }

    public DownloadConfigBuilder packageResolver(IPackageResolver packageResolver) {
        this.set(PACKAGE_RESOLVER, IPackageResolver.class, packageResolver);
        return this;
    }

    public DownloadConfigBuilder artifactStorePath(IDirectory artifactStorePath) {
        this.set(ARTIFACT_STORE_PATH, IDirectory.class, artifactStorePath);
        return this;
    }

    public DownloadConfigBuilder fileNaming(ITempNaming fileNaming) {
        this.set(FILE_NAMING, ITempNaming.class, fileNaming);
        return this;
    }

    public DownloadConfigBuilder progressListener(IProgressListener progressListener) {
        this.set(PROGRESS_LISTENER, IProgressListener.class, progressListener);
        return this;
    }

    public DownloadConfigBuilder userAgent(String userAgent) {
        this.set(DOWNLOAD_PREFIX, UserAgent.class, new UserAgent(userAgent));
        return this;
    }

    @Override
    public IDownloadConfig build() {
        String downloadPath = (String)this.get(DOWNLOAD_PATH, DownloadPath.class).value();
        String downloadPrefix = (String)this.get(DOWNLOAD_PREFIX, DownloadPrefix.class).value();
        IPackageResolver packageResolver = this.get(PACKAGE_RESOLVER, IPackageResolver.class);
        IDirectory artifactStorePath = this.get(ARTIFACT_STORE_PATH, IDirectory.class);
        ITempNaming fileNaming = this.get(FILE_NAMING, ITempNaming.class);
        IProgressListener progressListener = this.get(PROGRESS_LISTENER, IProgressListener.class);
        String userAgent = (String)this.get(USER_AGENT, UserAgent.class).value();
        return new ImmutableDownloadConfig(downloadPath, downloadPrefix, packageResolver, artifactStorePath, fileNaming, progressListener, userAgent);
    }

    protected static class ImmutableDownloadConfig
    implements IDownloadConfig {
        private final String _downloadPath;
        private final IProgressListener _progressListener;
        private final IDirectory _artifactStorePath;
        private final ITempNaming _fileNaming;
        private final String _downloadPrefix;
        private final String _userAgent;
        private final IPackageResolver _packageResolver;

        public ImmutableDownloadConfig(String downloadPath, String downloadPrefix, IPackageResolver packageResolver, IDirectory artifactStorePath, ITempNaming fileNaming, IProgressListener progressListener, String userAgent) {
            this._downloadPath = downloadPath;
            this._downloadPrefix = downloadPrefix;
            this._packageResolver = packageResolver;
            this._artifactStorePath = artifactStorePath;
            this._fileNaming = fileNaming;
            this._progressListener = progressListener;
            this._userAgent = userAgent;
        }

        @Override
        public String getDownloadPath() {
            return this._downloadPath;
        }

        @Override
        public IProgressListener getProgressListener() {
            return this._progressListener;
        }

        @Override
        public IDirectory getArtifactStorePath() {
            return this._artifactStorePath;
        }

        @Override
        public ITempNaming getFileNaming() {
            return this._fileNaming;
        }

        @Override
        public String getDownloadPrefix() {
            return this._downloadPrefix;
        }

        @Override
        public String getUserAgent() {
            return this._userAgent;
        }

        @Override
        public IPackageResolver getPackageResolver() {
            return this._packageResolver;
        }
    }

    protected static class UserAgent
    extends ImmutableContainer<String> {
        public UserAgent(String value) {
            super(value);
        }
    }

    protected static class DownloadPrefix
    extends ImmutableContainer<String> {
        public DownloadPrefix(String value) {
            super(value);
        }
    }

    protected static class DownloadPath
    extends ImmutableContainer<String> {
        public DownloadPath(String value) {
            super(value);
        }
    }
}

