/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.io.file.Files;
import de.flapdoodle.embed.process.runtime.Executable;
import de.flapdoodle.embed.process.runtime.IStopable;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import de.flapdoodle.embed.process.runtime.Processes;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcess<T extends IExecutableProcessConfig, E extends Executable<T, P>, P extends IStopable>
implements IStopable {
    private static Logger logger = LoggerFactory.getLogger(AbstractProcess.class);
    public static final int TIMEOUT = 20000;
    private final T config;
    private final IRuntimeConfig runtimeConfig;
    private final E executable;
    private ProcessControl process;
    private int processId;
    private boolean stopped = false;
    private final Distribution distribution;
    private final File pidFile;

    public AbstractProcess(Distribution distribution, T config, IRuntimeConfig runtimeConfig, E executable) throws IOException {
        this.config = config;
        this.runtimeConfig = runtimeConfig;
        this.executable = executable;
        this.distribution = distribution;
        this.pidFile = this.pidFile(((Executable)this.executable).getFile().executable());
        ProcessOutput outputConfig = runtimeConfig.getProcessOutput();
        String nextCall = "";
        try {
            nextCall = "onBeforeProcess()";
            this.onBeforeProcess(runtimeConfig);
            nextCall = "newProcessBuilder()";
            ProcessBuilder processBuilder = ProcessControl.newProcessBuilder(runtimeConfig.getCommandLinePostProcessor().process(distribution, this.getCommandLine(distribution, config, ((Executable)this.executable).getFile())), this.getEnvironment(distribution, config, ((Executable)this.executable).getFile()), true);
            nextCall = "onBeforeProcessStart()";
            this.onBeforeProcessStart(processBuilder, config, runtimeConfig);
            nextCall = "start()";
            this.process = ProcessControl.start(config.supportConfig(), processBuilder);
            nextCall = "writePidFile()";
            if (this.process.getPid() != null) {
                this.writePidFile(this.pidFile, this.process.getPid());
            }
            nextCall = "addShutdownHook()";
            if (runtimeConfig.isDaemonProcess()) {
                ProcessControl.addShutdownHook(new JobKiller());
            }
            nextCall = "onAfterProcessStart()";
            this.onAfterProcessStart(this.process, runtimeConfig);
        }
        catch (IOException iox) {
            logger.error("failed to call {}", (Object)nextCall, (Object)iox);
            logger.info("construct {}", (Object)config.toString());
            this.stop();
            throw iox;
        }
    }

    protected File pidFile(File executeableFile) {
        return new File(executeableFile.getParentFile(), this.executableBaseName(executeableFile.getName()) + ".pid");
    }

    protected File pidFile() {
        return this.pidFile;
    }

    private String executableBaseName(String name) {
        int idx = name.lastIndexOf(46);
        if (idx != -1) {
            return name.substring(0, idx);
        }
        return name;
    }

    public T getConfig() {
        return this.config;
    }

    protected void onBeforeProcess(IRuntimeConfig runtimeConfig) throws IOException {
    }

    protected void onBeforeProcessStart(ProcessBuilder processBuilder, T config, IRuntimeConfig runtimeConfig) {
    }

    protected void onAfterProcessStart(ProcessControl process, IRuntimeConfig runtimeConfig) throws IOException {
        ProcessOutput outputConfig = runtimeConfig.getProcessOutput();
        Processors.connect(process.getReader(), outputConfig.getOutput());
        Processors.connect(process.getError(), StreamToLineProcessor.wrap(outputConfig.getError()));
    }

    protected abstract List<String> getCommandLine(Distribution var1, T var2, IExtractedFileSet var3) throws IOException;

    protected Map<String, String> getEnvironment(Distribution distribution, T config, IExtractedFileSet exe) {
        return new HashMap<String, String>();
    }

    @Override
    public final synchronized void stop() {
        if (!this.stopped) {
            this.stopped = true;
            this.stopInternal();
            this.onAfterProcessStop(this.config, this.runtimeConfig);
            this.cleanupInternal();
            if (!Files.forceDelete(this.pidFile)) {
                logger.warn("Could not delete pid file: {}", (Object)this.pidFile);
            }
        }
    }

    protected abstract void stopInternal();

    protected abstract void cleanupInternal();

    protected void onAfterProcessStop(T config, IRuntimeConfig runtimeConfig) {
    }

    protected final void stopProcess() {
        if (this.process != null) {
            this.process.stop();
        }
    }

    public int waitFor() throws InterruptedException {
        return this.process.waitFor();
    }

    protected void setProcessId(int processId) {
        this.processId = processId;
    }

    protected boolean sendKillToProcess() {
        if (this.processId > 0) {
            return Processes.killProcess(this.config.supportConfig(), this.distribution.getPlatform(), StreamToLineProcessor.wrap(this.runtimeConfig.getProcessOutput().getCommands()), this.processId);
        }
        return false;
    }

    protected boolean sendTermToProcess() {
        if (this.processId > 0) {
            return Processes.termProcess(this.config.supportConfig(), this.distribution.getPlatform(), StreamToLineProcessor.wrap(this.runtimeConfig.getProcessOutput().getCommands()), this.processId);
        }
        return false;
    }

    protected boolean tryKillToProcess() {
        if (this.processId > 0) {
            return Processes.tryKillProcess(this.config.supportConfig(), this.distribution.getPlatform(), StreamToLineProcessor.wrap(this.runtimeConfig.getProcessOutput().getCommands()), this.processId);
        }
        return false;
    }

    public boolean isProcessRunning() {
        if (this.getProcessId() > 0L) {
            return Processes.isProcessRunning(this.distribution.getPlatform(), this.getProcessId());
        }
        return false;
    }

    public long getProcessId() {
        Long pid = this.process.getPid();
        return pid != null ? pid : (long)this.processId;
    }

    protected static int getPidFromFile(File pidFile) throws IOException {
        int tries;
        for (tries = 0; !pidFile.exists() && tries < 5; ++tries) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            logger.warn("Didn't find pid file in try {}, waiting 100ms...", (Object)tries);
        }
        if (!pidFile.exists()) {
            throw new IOException("Could not find pid file " + pidFile);
        }
        String fileContent = StringUtils.chomp((String)StringUtils.strip((String)FileUtils.readFileToString((File)pidFile)));
        for (tries = 0; StringUtils.isBlank((CharSequence)fileContent) && tries < 5; ++tries) {
            fileContent = StringUtils.chomp((String)StringUtils.strip((String)FileUtils.readFileToString((File)pidFile)));
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
        }
        if (StringUtils.isBlank((CharSequence)fileContent)) {
            throw new IOException("Pidfile " + pidFile + "does not contain a pid. Waited for " + tries * 100 + "ms.");
        }
        try {
            return Integer.parseInt(fileContent);
        }
        catch (NumberFormatException e) {
            throw new IOException("Pidfile " + pidFile + "does not contain a valid pid. Content: " + fileContent);
        }
    }

    protected void writePidFile(File pidFile, long pid) throws IOException {
        Files.write(pid + "\n", pidFile);
    }

    class JobKiller
    implements Runnable {
        JobKiller() {
        }

        @Override
        public void run() {
            AbstractProcess.this.stop();
        }
    }
}

