/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.config.store.IPackageResolver;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.Extractors;
import de.flapdoodle.embed.process.extract.FilesToExtract;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.extract.IExtractor;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.io.file.Files;
import de.flapdoodle.embed.process.store.IArtifactStore;
import de.flapdoodle.embed.process.store.IDownloader;
import de.flapdoodle.embed.process.store.LocalArtifactStore;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactStore
implements IArtifactStore {
    private static Logger logger = LoggerFactory.getLogger(ArtifactStore.class);
    private IDownloadConfig _downloadConfig;
    private IDirectory _tempDirFactory;
    private ITempNaming _executableNaming;
    private IDownloader _downloader;

    public ArtifactStore(IDownloadConfig downloadConfig, IDirectory tempDirFactory, ITempNaming executableNaming, IDownloader downloader) {
        this._downloadConfig = downloadConfig;
        this._tempDirFactory = tempDirFactory;
        this._executableNaming = executableNaming;
        this._downloader = downloader;
    }

    @Override
    public boolean checkDistribution(Distribution distribution) throws IOException {
        if (!LocalArtifactStore.checkArtifact(this._downloadConfig, distribution)) {
            return LocalArtifactStore.store(this._downloadConfig, distribution, this._downloader.download(this._downloadConfig, distribution));
        }
        return true;
    }

    @Override
    public IExtractedFileSet extractFileSet(Distribution distribution) throws IOException {
        IPackageResolver packageResolver = this._downloadConfig.getPackageResolver();
        File artifact = LocalArtifactStore.getArtifact(this._downloadConfig, distribution);
        IExtractor extractor = Extractors.getExtractor(packageResolver.getArchiveType(distribution));
        IExtractedFileSet extracted = extractor.extract(this._downloadConfig, artifact, new FilesToExtract(this._tempDirFactory, this._executableNaming, packageResolver.getFileSet(distribution)));
        return extracted;
    }

    @Override
    public void removeFileSet(Distribution distribution, IExtractedFileSet all) {
        for (FileType type : EnumSet.complementOf(EnumSet.of(FileType.Executable))) {
            for (File file : all.files(type)) {
                if (!file.exists() || Files.forceDelete(file)) continue;
                logger.warn("Could not delete {} NOW: {}", (Object)type, (Object)file);
            }
        }
        File exe = all.executable();
        if (exe.exists() && !Files.forceDelete(exe)) {
            logger.warn("Could not delete executable NOW: {}", (Object)exe);
        }
        if (all.generatedBaseDir() != null && !Files.forceDelete(all.generatedBaseDir())) {
            logger.warn("Could not delete generatedBaseDir: {}", (Object)all.generatedBaseDir());
        }
    }
}

