/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import de.flapdoodle.embed.process.store.IArtifactStore;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingArtifactStore
implements IArtifactStore {
    private static Logger _logger = LoggerFactory.getLogger(CachingArtifactStore.class);
    private final IArtifactStore _delegate;
    Object _lock = new Object();
    HashMap<Distribution, FilesWithCounter> _distributionFiles = new HashMap();

    public CachingArtifactStore(IArtifactStore delegate) {
        this._delegate = delegate;
        ProcessControl.addShutdownHook(new CacheCleaner());
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new CustomThreadFactory());
        executor.scheduleAtFixedRate(new RemoveUnused(), 10L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public boolean checkDistribution(Distribution distribution) throws IOException {
        return this._delegate.checkDistribution(distribution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExtractedFileSet extractFileSet(Distribution distribution) throws IOException {
        FilesWithCounter fileWithCounter;
        Object object = this._lock;
        synchronized (object) {
            fileWithCounter = this._distributionFiles.get(distribution);
            if (fileWithCounter == null) {
                _logger.debug("cache NOT found for {}", (Object)distribution);
                fileWithCounter = new FilesWithCounter(distribution);
                this._distributionFiles.put(distribution, fileWithCounter);
            } else {
                _logger.debug("cache found for {}", (Object)distribution);
            }
        }
        return fileWithCounter.use();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFileSet(Distribution distribution, IExtractedFileSet executable) {
        FilesWithCounter fileWithCounter;
        Object object = this._lock;
        synchronized (object) {
            fileWithCounter = this._distributionFiles.get(distribution);
        }
        if (fileWithCounter != null) {
            fileWithCounter.free(executable);
        } else {
            _logger.warn("Allready removed {} for {}, emergency shutdown?", (Object)executable, (Object)distribution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAll() {
        Object object = this._lock;
        synchronized (object) {
            for (FilesWithCounter fc : this._distributionFiles.values()) {
                fc.forceDelete();
            }
            this._distributionFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnused() {
        Object object = this._lock;
        synchronized (object) {
            for (FilesWithCounter fc : this._distributionFiles.values()) {
                fc.cleanup();
            }
        }
    }

    class CustomThreadFactory
    implements ThreadFactory {
        ThreadFactory factory = Executors.defaultThreadFactory();

        CustomThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread ret = this.factory.newThread(runnable);
            ret.setDaemon(true);
            return ret;
        }
    }

    class CacheCleaner
    implements Runnable {
        CacheCleaner() {
        }

        @Override
        public void run() {
            CachingArtifactStore.this.removeAll();
        }
    }

    class RemoveUnused
    implements Runnable {
        RemoveUnused() {
        }

        @Override
        public void run() {
            CachingArtifactStore.this.removeUnused();
        }
    }

    class FilesWithCounter {
        private IExtractedFileSet _file;
        int _counter = 0;
        private final Distribution _distribution;

        public FilesWithCounter(Distribution distribution) {
            this._distribution = distribution;
        }

        public synchronized void free(IExtractedFileSet executable) {
            if (executable != this._file) {
                throw new RuntimeException("Files does not match: " + this._file + " != " + executable);
            }
            _logger.debug("Free {} {}", (Object)this._counter, (Object)this._file);
            --this._counter;
        }

        public synchronized IExtractedFileSet use() throws IOException {
            ++this._counter;
            if (this._file == null) {
                this._file = CachingArtifactStore.this._delegate.extractFileSet(this._distribution);
                _logger.debug("Not Cached {} {}", (Object)this._counter, (Object)this._file);
            } else {
                _logger.debug("Cached {} {}", (Object)this._counter, (Object)this._file);
            }
            return this._file;
        }

        public synchronized void cleanup() {
            if (this._counter <= 0) {
                if (this._counter < 0) {
                    _logger.warn("Counter < 0 for {} and {}", (Object)this._distribution, (Object)this._file);
                }
                if (this._file != null) {
                    _logger.debug("cleanup for {} and {}", (Object)this._distribution, (Object)this._file);
                    CachingArtifactStore.this._delegate.removeFileSet(this._distribution, this._file);
                    this._file = null;
                }
            }
        }

        public synchronized void forceDelete() {
            if (this._file != null) {
                _logger.debug("force delete for {} and {}", (Object)this._distribution, (Object)this._file);
                CachingArtifactStore.this._delegate.removeFileSet(this._distribution, this._file);
                this._file = null;
                this._counter = 0;
            }
        }
    }
}

