/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.RuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.ExtractedFileSet;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.runtime.Executable;
import de.flapdoodle.embed.process.runtime.IStopable;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import de.flapdoodle.embed.process.runtime.Processes;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcess<T extends ExecutableProcessConfig, E extends Executable<T, P>, P extends IStopable>
implements IStopable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractProcess.class);
    public static final int TIMEOUT = 20000;
    private final T config;
    private final RuntimeConfig runtimeConfig;
    private final E executable;
    private ProcessControl process;
    private long processId;
    private boolean stopped = false;
    private boolean registeredJobKiller;
    private final Distribution distribution;
    private final File pidFile;

    public AbstractProcess(Distribution distribution, T config, RuntimeConfig runtimeConfig, E executable) throws IOException {
        this.config = config;
        this.runtimeConfig = runtimeConfig;
        this.executable = executable;
        this.distribution = distribution;
        this.pidFile = this.pidFile(((Executable)this.executable).getFile().executable());
        String nextCall = "";
        try {
            nextCall = "onBeforeProcess()";
            this.onBeforeProcess(runtimeConfig);
            nextCall = "newProcessBuilder()";
            ProcessBuilder processBuilder = ProcessControl.newProcessBuilder(runtimeConfig.commandLinePostProcessor().process(distribution, this.getCommandLine(distribution, config, ((Executable)this.executable).getFile())), this.getEnvironment(distribution, config, ((Executable)this.executable).getFile()), true);
            nextCall = "onBeforeProcessStart()";
            this.onBeforeProcessStart(processBuilder, config, runtimeConfig);
            nextCall = "start()";
            this.process = ProcessControl.start(config.supportConfig(), processBuilder);
            nextCall = "writePidFile()";
            if (this.process.getPid() != null) {
                this.writePidFile(this.pidFile, this.process.getPid());
            }
            nextCall = "addShutdownHook()";
            if (runtimeConfig.isDaemonProcess() && !((Executable)executable).isRegisteredJobKiller()) {
                ProcessControl.addShutdownHook(new JobKiller());
                this.registeredJobKiller = true;
            }
            nextCall = "onAfterProcessStart()";
            this.onAfterProcessStart(this.process, runtimeConfig);
        }
        catch (IOException iox) {
            logger.error("failed to call {}", (Object)nextCall, (Object)iox);
            logger.info("construct {}", (Object)config.toString());
            this.stop();
            throw iox;
        }
    }

    @Override
    public boolean isRegisteredJobKiller() {
        return this.registeredJobKiller;
    }

    protected File pidFile(File executableFile) {
        return new File(executableFile.getParentFile(), this.executableBaseName(executableFile.getName()) + ".pid");
    }

    protected File pidFile() {
        return this.pidFile;
    }

    private String executableBaseName(String name) {
        int idx = name.lastIndexOf(46);
        if (idx != -1) {
            return name.substring(0, idx);
        }
        return name;
    }

    public T getConfig() {
        return this.config;
    }

    protected void onBeforeProcess(RuntimeConfig runtimeConfig) {
    }

    protected void onBeforeProcessStart(ProcessBuilder processBuilder, T config, RuntimeConfig runtimeConfig) {
    }

    protected void onAfterProcessStart(ProcessControl process, RuntimeConfig runtimeConfig) {
        ProcessOutput outputConfig = runtimeConfig.processOutput();
        Processors.connect(process.getReader(), outputConfig.getOutput());
        Processors.connect(process.getError(), StreamToLineProcessor.wrap(outputConfig.getError()));
    }

    protected abstract List<String> getCommandLine(Distribution var1, T var2, ExtractedFileSet var3) throws IOException;

    protected Map<String, String> getEnvironment(Distribution distribution, T config, ExtractedFileSet exe) {
        return new HashMap<String, String>();
    }

    @Override
    public final synchronized void stop() {
        if (!this.stopped) {
            this.stopped = true;
            this.stopInternal();
            this.onAfterProcessStop(this.config, this.runtimeConfig);
            this.cleanupInternal();
            if (!de.flapdoodle.embed.process.io.file.Files.forceDelete(this.pidFile)) {
                logger.warn("Could not delete pid file: {}", (Object)this.pidFile);
            }
        }
    }

    protected abstract void stopInternal();

    protected abstract void cleanupInternal();

    protected void onAfterProcessStop(T config, RuntimeConfig runtimeConfig) {
    }

    protected final void stopProcess() {
        if (this.process != null) {
            this.config.stopTimeoutInMillis().ifPresentOrElse(this.process::stop, this.process::stop);
        }
    }

    public int waitFor() throws InterruptedException {
        return this.process.waitFor();
    }

    protected void setProcessId(long processId) {
        this.processId = processId;
    }

    protected boolean sendKillToProcess() {
        return this.getProcessId() > 0L && Processes.killProcess(this.config.supportConfig(), this.distribution.platform(), StreamToLineProcessor.wrap(this.runtimeConfig.processOutput().getCommands()), this.getProcessId());
    }

    protected boolean sendTermToProcess() {
        return this.getProcessId() > 0L && Processes.termProcess(this.config.supportConfig(), this.distribution.platform(), StreamToLineProcessor.wrap(this.runtimeConfig.processOutput().getCommands()), this.getProcessId());
    }

    protected boolean tryKillToProcess() {
        return this.getProcessId() > 0L && Processes.tryKillProcess(this.config.supportConfig(), this.distribution.platform(), StreamToLineProcessor.wrap(this.runtimeConfig.processOutput().getCommands()), this.getProcessId());
    }

    public boolean isProcessRunning() {
        return this.getProcessId() > 0L && Processes.isProcessRunning(this.distribution.platform(), this.getProcessId());
    }

    public long getProcessId() {
        Long pid = this.process.getPid();
        return pid != null ? pid : this.processId;
    }

    protected static int getPidFromFile(File pidFile) throws IOException {
        int tries;
        for (tries = 0; !pidFile.exists() && tries < 5; ++tries) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logger.warn("Didn't find pid file in try {}, waiting 100ms...", (Object)tries);
        }
        if (!pidFile.exists()) {
            throw new IOException("Could not find pid file " + pidFile);
        }
        String fileContent = StringUtils.chomp((String)StringUtils.strip((String)new String(Files.readAllBytes(pidFile.toPath()))));
        for (tries = 0; StringUtils.isBlank((CharSequence)fileContent) && tries < 5; ++tries) {
            fileContent = StringUtils.chomp((String)StringUtils.strip((String)new String(Files.readAllBytes(pidFile.toPath()))));
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (StringUtils.isBlank((CharSequence)fileContent)) {
            throw new IOException("Pidfile " + pidFile + "does not contain a pid. Waited for " + tries * 100 + "ms.");
        }
        try {
            return Integer.parseInt(fileContent);
        }
        catch (NumberFormatException e) {
            throw new IOException("Pidfile " + pidFile + "does not contain a valid pid. Content: " + fileContent);
        }
    }

    protected void writePidFile(File pidFile, long pid) throws IOException {
        de.flapdoodle.embed.process.io.file.Files.write(pid + "\n", pidFile);
    }

    class JobKiller
    implements Runnable {
        JobKiller() {
        }

        @Override
        public void run() {
            AbstractProcess.this.stop();
        }
    }
}

