package de.flapdoodle.embed.process.config.store;

import de.flapdoodle.embed.process.extract.TempNaming;
import de.flapdoodle.embed.process.io.directories.Directory;
import de.flapdoodle.embed.process.io.progress.ProgressListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DownloadConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDownloadConfig.builder()}.
 */
@Generated(from = "DownloadConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDownloadConfig implements DownloadConfig {
  private final DistributionDownloadPath downloadPath;
  private final ProgressListener progressListener;
  private final Directory artifactStorePath;
  private final TempNaming fileNaming;
  private final String downloadPrefix;
  private final String userAgent;
  private final PackageResolver packageResolver;
  private final TimeoutConfig timeoutConfig;
  private final ProxyFactory proxyFactory;

  private ImmutableDownloadConfig(ImmutableDownloadConfig.Builder builder) {
    this.downloadPath = builder.downloadPath;
    this.progressListener = builder.progressListener;
    this.artifactStorePath = builder.artifactStorePath;
    this.fileNaming = builder.fileNaming;
    this.downloadPrefix = builder.downloadPrefix;
    this.userAgent = builder.userAgent;
    this.packageResolver = builder.packageResolver;
    this.proxyFactory = builder.proxyFactory;
    this.timeoutConfig = builder.timeoutConfig != null
        ? builder.timeoutConfig
        : Objects.requireNonNull(DownloadConfig.super.getTimeoutConfig(), "timeoutConfig");
  }

  private ImmutableDownloadConfig(
      DistributionDownloadPath downloadPath,
      ProgressListener progressListener,
      Directory artifactStorePath,
      TempNaming fileNaming,
      String downloadPrefix,
      String userAgent,
      PackageResolver packageResolver,
      TimeoutConfig timeoutConfig,
      ProxyFactory proxyFactory) {
    this.downloadPath = downloadPath;
    this.progressListener = progressListener;
    this.artifactStorePath = artifactStorePath;
    this.fileNaming = fileNaming;
    this.downloadPrefix = downloadPrefix;
    this.userAgent = userAgent;
    this.packageResolver = packageResolver;
    this.timeoutConfig = timeoutConfig;
    this.proxyFactory = proxyFactory;
  }

  /**
   * @return The value of the {@code downloadPath} attribute
   */
  @Override
  public DistributionDownloadPath getDownloadPath() {
    return downloadPath;
  }

  /**
   * @return The value of the {@code progressListener} attribute
   */
  @Override
  public ProgressListener getProgressListener() {
    return progressListener;
  }

  /**
   * @return The value of the {@code artifactStorePath} attribute
   */
  @Override
  public Directory getArtifactStorePath() {
    return artifactStorePath;
  }

  /**
   * @return The value of the {@code fileNaming} attribute
   */
  @Override
  public TempNaming getFileNaming() {
    return fileNaming;
  }

  /**
   * @return The value of the {@code downloadPrefix} attribute
   */
  @Override
  public String getDownloadPrefix() {
    return downloadPrefix;
  }

  /**
   * @return The value of the {@code userAgent} attribute
   */
  @Override
  public String getUserAgent() {
    return userAgent;
  }

  /**
   * @return The value of the {@code packageResolver} attribute
   */
  @Override
  public PackageResolver getPackageResolver() {
    return packageResolver;
  }

  /**
   * @return The value of the {@code timeoutConfig} attribute
   */
  @Override
  public TimeoutConfig getTimeoutConfig() {
    return timeoutConfig;
  }

  /**
   * @return The value of the {@code proxyFactory} attribute
   */
  @Override
  public Optional<ProxyFactory> proxyFactory() {
    return Optional.ofNullable(proxyFactory);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DownloadConfig#getDownloadPath() downloadPath} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for downloadPath
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDownloadConfig withDownloadPath(DistributionDownloadPath value) {
    if (this.downloadPath == value) return this;
    DistributionDownloadPath newValue = Objects.requireNonNull(value, "downloadPath");
    return new ImmutableDownloadConfig(
        newValue,
        this.progressListener,
        this.artifactStorePath,
        this.fileNaming,
        this.downloadPrefix,
        this.userAgent,
        this.packageResolver,
        this.timeoutConfig,
        this.proxyFactory);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DownloadConfig#getProgressListener() progressListener} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for progressListener
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDownloadConfig withProgressListener(ProgressListener value) {
    if (this.progressListener == value) return this;
    ProgressListener newValue = Objects.requireNonNull(value, "progressListener");
    return new ImmutableDownloadConfig(
        this.downloadPath,
        newValue,
        this.artifactStorePath,
        this.fileNaming,
        this.downloadPrefix,
        this.userAgent,
        this.packageResolver,
        this.timeoutConfig,
        this.proxyFactory);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DownloadConfig#getArtifactStorePath() artifactStorePath} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for artifactStorePath
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDownloadConfig withArtifactStorePath(Directory value) {
    if (this.artifactStorePath == value) return this;
    Directory newValue = Objects.requireNonNull(value, "artifactStorePath");
    return new ImmutableDownloadConfig(
        this.downloadPath,
        this.progressListener,
        newValue,
        this.fileNaming,
        this.downloadPrefix,
        this.userAgent,
        this.packageResolver,
        this.timeoutConfig,
        this.proxyFactory);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DownloadConfig#getFileNaming() fileNaming} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fileNaming
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDownloadConfig withFileNaming(TempNaming value) {
    if (this.fileNaming == value) return this;
    TempNaming newValue = Objects.requireNonNull(value, "fileNaming");
    return new ImmutableDownloadConfig(
        this.downloadPath,
        this.progressListener,
        this.artifactStorePath,
        newValue,
        this.downloadPrefix,
        this.userAgent,
        this.packageResolver,
        this.timeoutConfig,
        this.proxyFactory);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DownloadConfig#getDownloadPrefix() downloadPrefix} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for downloadPrefix
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDownloadConfig withDownloadPrefix(String value) {
    String newValue = Objects.requireNonNull(value, "downloadPrefix");
    if (this.downloadPrefix.equals(newValue)) return this;
    return new ImmutableDownloadConfig(
        this.downloadPath,
        this.progressListener,
        this.artifactStorePath,
        this.fileNaming,
        newValue,
        this.userAgent,
        this.packageResolver,
        this.timeoutConfig,
        this.proxyFactory);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DownloadConfig#getUserAgent() userAgent} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userAgent
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDownloadConfig withUserAgent(String value) {
    String newValue = Objects.requireNonNull(value, "userAgent");
    if (this.userAgent.equals(newValue)) return this;
    return new ImmutableDownloadConfig(
        this.downloadPath,
        this.progressListener,
        this.artifactStorePath,
        this.fileNaming,
        this.downloadPrefix,
        newValue,
        this.packageResolver,
        this.timeoutConfig,
        this.proxyFactory);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DownloadConfig#getPackageResolver() packageResolver} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for packageResolver
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDownloadConfig withPackageResolver(PackageResolver value) {
    if (this.packageResolver == value) return this;
    PackageResolver newValue = Objects.requireNonNull(value, "packageResolver");
    return new ImmutableDownloadConfig(
        this.downloadPath,
        this.progressListener,
        this.artifactStorePath,
        this.fileNaming,
        this.downloadPrefix,
        this.userAgent,
        newValue,
        this.timeoutConfig,
        this.proxyFactory);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DownloadConfig#getTimeoutConfig() timeoutConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timeoutConfig
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDownloadConfig withTimeoutConfig(TimeoutConfig value) {
    if (this.timeoutConfig == value) return this;
    TimeoutConfig newValue = Objects.requireNonNull(value, "timeoutConfig");
    return new ImmutableDownloadConfig(
        this.downloadPath,
        this.progressListener,
        this.artifactStorePath,
        this.fileNaming,
        this.downloadPrefix,
        this.userAgent,
        this.packageResolver,
        newValue,
        this.proxyFactory);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link DownloadConfig#proxyFactory() proxyFactory} attribute.
   * @param value The value for proxyFactory
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDownloadConfig withProxyFactory(ProxyFactory value) {
    ProxyFactory newValue = Objects.requireNonNull(value, "proxyFactory");
    if (this.proxyFactory == newValue) return this;
    return new ImmutableDownloadConfig(
        this.downloadPath,
        this.progressListener,
        this.artifactStorePath,
        this.fileNaming,
        this.downloadPrefix,
        this.userAgent,
        this.packageResolver,
        this.timeoutConfig,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link DownloadConfig#proxyFactory() proxyFactory} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for proxyFactory
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableDownloadConfig withProxyFactory(Optional<? extends ProxyFactory> optional) {
    ProxyFactory value = optional.orElse(null);
    if (this.proxyFactory == value) return this;
    return new ImmutableDownloadConfig(
        this.downloadPath,
        this.progressListener,
        this.artifactStorePath,
        this.fileNaming,
        this.downloadPrefix,
        this.userAgent,
        this.packageResolver,
        this.timeoutConfig,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDownloadConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDownloadConfig
        && equalTo((ImmutableDownloadConfig) another);
  }

  private boolean equalTo(ImmutableDownloadConfig another) {
    return downloadPath.equals(another.downloadPath)
        && progressListener.equals(another.progressListener)
        && artifactStorePath.equals(another.artifactStorePath)
        && fileNaming.equals(another.fileNaming)
        && downloadPrefix.equals(another.downloadPrefix)
        && userAgent.equals(another.userAgent)
        && packageResolver.equals(another.packageResolver)
        && timeoutConfig.equals(another.timeoutConfig)
        && Objects.equals(proxyFactory, another.proxyFactory);
  }

  /**
   * Computes a hash code from attributes: {@code downloadPath}, {@code progressListener}, {@code artifactStorePath}, {@code fileNaming}, {@code downloadPrefix}, {@code userAgent}, {@code packageResolver}, {@code timeoutConfig}, {@code proxyFactory}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + downloadPath.hashCode();
    h += (h << 5) + progressListener.hashCode();
    h += (h << 5) + artifactStorePath.hashCode();
    h += (h << 5) + fileNaming.hashCode();
    h += (h << 5) + downloadPrefix.hashCode();
    h += (h << 5) + userAgent.hashCode();
    h += (h << 5) + packageResolver.hashCode();
    h += (h << 5) + timeoutConfig.hashCode();
    h += (h << 5) + Objects.hashCode(proxyFactory);
    return h;
  }

  /**
   * Prints the immutable value {@code DownloadConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("DownloadConfig{");
    builder.append("downloadPath=").append(downloadPath);
    builder.append(", ");
    builder.append("progressListener=").append(progressListener);
    builder.append(", ");
    builder.append("artifactStorePath=").append(artifactStorePath);
    builder.append(", ");
    builder.append("fileNaming=").append(fileNaming);
    builder.append(", ");
    builder.append("downloadPrefix=").append(downloadPrefix);
    builder.append(", ");
    builder.append("userAgent=").append(userAgent);
    builder.append(", ");
    builder.append("packageResolver=").append(packageResolver);
    builder.append(", ");
    builder.append("timeoutConfig=").append(timeoutConfig);
    if (proxyFactory != null) {
      builder.append(", ");
      builder.append("proxyFactory=").append(proxyFactory);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link DownloadConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DownloadConfig instance
   */
  public static ImmutableDownloadConfig copyOf(DownloadConfig instance) {
    if (instance instanceof ImmutableDownloadConfig) {
      return (ImmutableDownloadConfig) instance;
    }
    return ImmutableDownloadConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDownloadConfig ImmutableDownloadConfig}.
   * <pre>
   * ImmutableDownloadConfig.builder()
   *    .downloadPath(de.flapdoodle.embed.process.config.store.DistributionDownloadPath) // required {@link DownloadConfig#getDownloadPath() downloadPath}
   *    .progressListener(de.flapdoodle.embed.process.io.progress.ProgressListener) // required {@link DownloadConfig#getProgressListener() progressListener}
   *    .artifactStorePath(de.flapdoodle.embed.process.io.directories.Directory) // required {@link DownloadConfig#getArtifactStorePath() artifactStorePath}
   *    .fileNaming(de.flapdoodle.embed.process.extract.TempNaming) // required {@link DownloadConfig#getFileNaming() fileNaming}
   *    .downloadPrefix(String) // required {@link DownloadConfig#getDownloadPrefix() downloadPrefix}
   *    .userAgent(String) // required {@link DownloadConfig#getUserAgent() userAgent}
   *    .packageResolver(de.flapdoodle.embed.process.config.store.PackageResolver) // required {@link DownloadConfig#getPackageResolver() packageResolver}
   *    .timeoutConfig(de.flapdoodle.embed.process.config.store.TimeoutConfig) // optional {@link DownloadConfig#getTimeoutConfig() timeoutConfig}
   *    .proxyFactory(de.flapdoodle.embed.process.config.store.ProxyFactory) // optional {@link DownloadConfig#proxyFactory() proxyFactory}
   *    .build();
   * </pre>
   * @return A new ImmutableDownloadConfig builder
   */
  public static ImmutableDownloadConfig.Builder builder() {
    return new ImmutableDownloadConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDownloadConfig ImmutableDownloadConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DownloadConfig", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DOWNLOAD_PATH = 0x1L;
    private static final long INIT_BIT_PROGRESS_LISTENER = 0x2L;
    private static final long INIT_BIT_ARTIFACT_STORE_PATH = 0x4L;
    private static final long INIT_BIT_FILE_NAMING = 0x8L;
    private static final long INIT_BIT_DOWNLOAD_PREFIX = 0x10L;
    private static final long INIT_BIT_USER_AGENT = 0x20L;
    private static final long INIT_BIT_PACKAGE_RESOLVER = 0x40L;
    private long initBits = 0x7fL;

    private DistributionDownloadPath downloadPath;
    private ProgressListener progressListener;
    private Directory artifactStorePath;
    private TempNaming fileNaming;
    private String downloadPrefix;
    private String userAgent;
    private PackageResolver packageResolver;
    private TimeoutConfig timeoutConfig;
    private ProxyFactory proxyFactory;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DownloadConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DownloadConfig instance) {
      Objects.requireNonNull(instance, "instance");
      downloadPath(instance.getDownloadPath());
      progressListener(instance.getProgressListener());
      artifactStorePath(instance.getArtifactStorePath());
      fileNaming(instance.getFileNaming());
      downloadPrefix(instance.getDownloadPrefix());
      userAgent(instance.getUserAgent());
      packageResolver(instance.getPackageResolver());
      timeoutConfig(instance.getTimeoutConfig());
      Optional<ProxyFactory> proxyFactoryOptional = instance.proxyFactory();
      if (proxyFactoryOptional.isPresent()) {
        proxyFactory(proxyFactoryOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DownloadConfig#getDownloadPath() downloadPath} attribute.
     * @param downloadPath The value for downloadPath 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder downloadPath(DistributionDownloadPath downloadPath) {
      this.downloadPath = Objects.requireNonNull(downloadPath, "downloadPath");
      initBits &= ~INIT_BIT_DOWNLOAD_PATH;
      return this;
    }

    /**
     * Initializes the value for the {@link DownloadConfig#getProgressListener() progressListener} attribute.
     * @param progressListener The value for progressListener 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder progressListener(ProgressListener progressListener) {
      this.progressListener = Objects.requireNonNull(progressListener, "progressListener");
      initBits &= ~INIT_BIT_PROGRESS_LISTENER;
      return this;
    }

    /**
     * Initializes the value for the {@link DownloadConfig#getArtifactStorePath() artifactStorePath} attribute.
     * @param artifactStorePath The value for artifactStorePath 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder artifactStorePath(Directory artifactStorePath) {
      this.artifactStorePath = Objects.requireNonNull(artifactStorePath, "artifactStorePath");
      initBits &= ~INIT_BIT_ARTIFACT_STORE_PATH;
      return this;
    }

    /**
     * Initializes the value for the {@link DownloadConfig#getFileNaming() fileNaming} attribute.
     * @param fileNaming The value for fileNaming 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder fileNaming(TempNaming fileNaming) {
      this.fileNaming = Objects.requireNonNull(fileNaming, "fileNaming");
      initBits &= ~INIT_BIT_FILE_NAMING;
      return this;
    }

    /**
     * Initializes the value for the {@link DownloadConfig#getDownloadPrefix() downloadPrefix} attribute.
     * @param downloadPrefix The value for downloadPrefix 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder downloadPrefix(String downloadPrefix) {
      this.downloadPrefix = Objects.requireNonNull(downloadPrefix, "downloadPrefix");
      initBits &= ~INIT_BIT_DOWNLOAD_PREFIX;
      return this;
    }

    /**
     * Initializes the value for the {@link DownloadConfig#getUserAgent() userAgent} attribute.
     * @param userAgent The value for userAgent 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userAgent(String userAgent) {
      this.userAgent = Objects.requireNonNull(userAgent, "userAgent");
      initBits &= ~INIT_BIT_USER_AGENT;
      return this;
    }

    /**
     * Initializes the value for the {@link DownloadConfig#getPackageResolver() packageResolver} attribute.
     * @param packageResolver The value for packageResolver 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder packageResolver(PackageResolver packageResolver) {
      this.packageResolver = Objects.requireNonNull(packageResolver, "packageResolver");
      initBits &= ~INIT_BIT_PACKAGE_RESOLVER;
      return this;
    }

    /**
     * Initializes the value for the {@link DownloadConfig#getTimeoutConfig() timeoutConfig} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DownloadConfig#getTimeoutConfig() timeoutConfig}.</em>
     * @param timeoutConfig The value for timeoutConfig 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timeoutConfig(TimeoutConfig timeoutConfig) {
      this.timeoutConfig = Objects.requireNonNull(timeoutConfig, "timeoutConfig");
      return this;
    }

    /**
     * Initializes the optional value {@link DownloadConfig#proxyFactory() proxyFactory} to proxyFactory.
     * @param proxyFactory The value for proxyFactory
     * @return {@code this} builder for chained invocation
     */
    public final Builder proxyFactory(ProxyFactory proxyFactory) {
      this.proxyFactory = Objects.requireNonNull(proxyFactory, "proxyFactory");
      return this;
    }

    /**
     * Initializes the optional value {@link DownloadConfig#proxyFactory() proxyFactory} to proxyFactory.
     * @param proxyFactory The value for proxyFactory
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder proxyFactory(Optional<? extends ProxyFactory> proxyFactory) {
      this.proxyFactory = proxyFactory.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableDownloadConfig ImmutableDownloadConfig}.
     * @return An immutable instance of DownloadConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDownloadConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDownloadConfig(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DOWNLOAD_PATH) != 0) attributes.add("downloadPath");
      if ((initBits & INIT_BIT_PROGRESS_LISTENER) != 0) attributes.add("progressListener");
      if ((initBits & INIT_BIT_ARTIFACT_STORE_PATH) != 0) attributes.add("artifactStorePath");
      if ((initBits & INIT_BIT_FILE_NAMING) != 0) attributes.add("fileNaming");
      if ((initBits & INIT_BIT_DOWNLOAD_PREFIX) != 0) attributes.add("downloadPrefix");
      if ((initBits & INIT_BIT_USER_AGENT) != 0) attributes.add("userAgent");
      if ((initBits & INIT_BIT_PACKAGE_RESOLVER) != 0) attributes.add("packageResolver");
      return "Cannot build DownloadConfig, some of required attributes are not set " + attributes;
    }
  }
}
