/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.RuntimeConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.exceptions.DistributionException;
import de.flapdoodle.embed.process.extract.ExtractedFileSet;
import de.flapdoodle.embed.process.runtime.Executable;
import de.flapdoodle.embed.process.runtime.IStopable;
import de.flapdoodle.embed.process.store.IArtifactStore;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Starter<CONFIG extends ExecutableProcessConfig, EXECUTABLE extends Executable<CONFIG, PROCESS>, PROCESS extends IStopable> {
    private static Logger logger = LoggerFactory.getLogger(Starter.class);
    private final RuntimeConfig runtime;

    protected Starter(RuntimeConfig config) {
        this.runtime = config;
    }

    public EXECUTABLE prepare(CONFIG config) {
        return this.prepare(config, Distribution.detectFor(config.version()));
    }

    public EXECUTABLE prepare(CONFIG config, Distribution distribution) {
        try {
            IArtifactStore artifactStore = this.runtime.artifactStore();
            Optional<ExtractedFileSet> files = artifactStore.extractFileSet(distribution);
            if (files.isPresent()) {
                return this.newExecutable(config, distribution, this.runtime, files.get());
            }
            throw new DistributionException("could not find Distribution", distribution);
        }
        catch (IOException iox) {
            String messageOnException = config.supportConfig().messageOnException().apply(this.getClass(), iox);
            if (messageOnException == null) {
                messageOnException = "prepare executable";
            }
            logger.error(messageOnException, (Throwable)iox);
            throw new DistributionException(distribution, (Throwable)iox);
        }
    }

    protected abstract EXECUTABLE newExecutable(CONFIG var1, Distribution var2, RuntimeConfig var3, ExtractedFileSet var4);
}

