/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.config.store.DownloadConfig;
import de.flapdoodle.embed.process.config.store.ProxyFactory;
import de.flapdoodle.embed.process.config.store.TimeoutConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.io.directories.PropertyOrPlatformTempDir;
import de.flapdoodle.embed.process.io.file.Files;
import de.flapdoodle.embed.process.io.progress.ProgressListener;
import de.flapdoodle.embed.process.store.Downloader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;

public class UrlConnectionDownloader
implements Downloader {
    private static final int DEFAULT_CONTENT_LENGTH = 0x1400000;
    private static final int BUFFER_LENGTH = 65536;
    private static final int READ_COUNT_MULTIPLIER = 100;

    @Override
    public String getDownloadUrl(DownloadConfig runtime, Distribution distribution) {
        return runtime.getDownloadPath().getPath(distribution) + runtime.getPackageResolver().packageFor(distribution).archivePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File download(DownloadConfig downloadConfig, Distribution distribution) throws IOException {
        String progressLabel = "Download " + distribution;
        ProgressListener progress = downloadConfig.getProgressListener();
        progress.start(progressLabel);
        File ret = Files.createTempFile(PropertyOrPlatformTempDir.defaultInstance(), downloadConfig.getFileNaming().nameFor(downloadConfig.getDownloadPrefix(), "." + (Object)((Object)downloadConfig.getPackageResolver().packageFor(distribution).archiveType())));
        if (ret.canWrite()) {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(ret));
            InputStreamAndLength downloadStreamAndLength = this.downloadInputStream(downloadConfig, distribution);
            long length = downloadStreamAndLength.contentLength();
            InputStream downloadStream = downloadStreamAndLength.downloadStream();
            progress.info(progressLabel, "DownloadSize: " + length);
            if (length == -1L) {
                length = 0x1400000L;
            }
            long downloadStartedAt = System.currentTimeMillis();
            try {
                BufferedInputStream bis = new BufferedInputStream(downloadStream);
                byte[] buf = new byte[65536];
                int read = 0;
                long readCount = 0L;
                while ((read = bis.read(buf)) != -1) {
                    bos.write(buf, 0, read);
                    if ((readCount += (long)read) > length) {
                        length = readCount;
                    }
                    progress.progress(progressLabel, (int)(readCount * 100L / length));
                }
                progress.info(progressLabel, "downloaded with " + this.downloadSpeed(downloadStartedAt, length));
            }
            finally {
                downloadStream.close();
                bos.flush();
                bos.close();
            }
        } else {
            throw new IOException("Can not write " + ret);
        }
        progress.done(progressLabel);
        return ret;
    }

    private InputStreamAndLength downloadInputStream(DownloadConfig downloadConfig, Distribution distribution) throws IOException {
        URL url = new URL(this.getDownloadUrl(downloadConfig, distribution));
        Optional<Proxy> proxy = downloadConfig.proxyFactory().map(ProxyFactory::createProxy);
        try {
            URLConnection openConnection = proxy.isPresent() ? url.openConnection(proxy.get()) : url.openConnection();
            openConnection.setRequestProperty("User-Agent", downloadConfig.getUserAgent());
            TimeoutConfig timeoutConfig = downloadConfig.getTimeoutConfig();
            openConnection.setConnectTimeout(timeoutConfig.getConnectionTimeout());
            openConnection.setReadTimeout(downloadConfig.getTimeoutConfig().getReadTimeout());
            InputStream downloadStream = openConnection.getInputStream();
            return new InputStreamAndLength(downloadStream, openConnection.getContentLength());
        }
        catch (IOException iox) {
            throw new IOException("Could not open inputStream for " + url + " with proxy " + proxy, iox);
        }
    }

    private String downloadSpeed(long downloadStartedAt, long downloadSize) {
        long timeUsed = (System.currentTimeMillis() - downloadStartedAt) / 1000L;
        if (timeUsed == 0L) {
            timeUsed = 1L;
        }
        long kbPerSecond = downloadSize / (timeUsed * 1024L);
        return "" + kbPerSecond + "kb/s";
    }

    static class InputStreamAndLength {
        private final InputStream _downloadStream;
        private final int _contentLength;

        public InputStreamAndLength(InputStream downloadStream, int contentLength) {
            this._downloadStream = downloadStream;
            this._contentLength = contentLength;
        }

        public int contentLength() {
            return this._contentLength;
        }

        public InputStream downloadStream() {
            return this._downloadStream;
        }
    }
}

