/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import de.flapdoodle.embed.process.config.SupportConfig;
import de.flapdoodle.embed.process.config.process.ProcessConfig;
import de.flapdoodle.embed.process.io.LogWatchStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.StreamProcessor;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Platform;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import javax.lang.model.SourceVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Processes {
    private static final Logger logger;
    private static final PidHelper PID_HELPER;

    private Processes() {
    }

    public static Long processId(Process process) {
        return PID_HELPER.getPid(process);
    }

    private static Long unixLikeProcessId(Process process) {
        Class<?> clazz = process.getClass();
        try {
            if (clazz.getName().equals("java.lang.UNIXProcess")) {
                Field pidField = clazz.getDeclaredField("pid");
                pidField.setAccessible(true);
                Object value = pidField.get(process);
                if (value instanceof Integer) {
                    logger.debug("Detected pid: {}", value);
                    return ((Integer)value).longValue();
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException sx) {
            sx.printStackTrace();
        }
        return null;
    }

    private static Long windowsProcessId(Process process) {
        if (process.getClass().getName().equals("java.lang.Win32Process") || process.getClass().getName().equals("java.lang.ProcessImpl")) {
            try {
                Field f = process.getClass().getDeclaredField("handle");
                f.setAccessible(true);
                long handl = f.getLong(process);
                Kernel32 kernel = Kernel32.INSTANCE;
                WinNT.HANDLE handle = new WinNT.HANDLE();
                handle.setPointer(Pointer.createConstant((long)handl));
                int ret = kernel.GetProcessId(handle);
                logger.debug("Detected pid: {}", (Object)ret);
                return ret;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean killProcess(SupportConfig support, Platform platform, StreamProcessor output, long pid) {
        return Processes.isUnixLike(platform) && ProcessControl.executeCommandLine(support, "[kill process]", ProcessConfig.builder().commandLine(Arrays.asList("kill", "-2", "" + pid)).output(output).build());
    }

    public static boolean termProcess(SupportConfig support, Platform platform, StreamProcessor output, long pid) {
        return Processes.isUnixLike(platform) && ProcessControl.executeCommandLine(support, "[term process]", ProcessConfig.builder().commandLine(Arrays.asList("kill", "" + pid)).output(output).build());
    }

    public static boolean tryKillProcess(SupportConfig support, Platform platform, StreamProcessor output, long pid) {
        return platform.operatingSystem() == OS.Windows && ProcessControl.executeCommandLine(support, "[taskkill process]", ProcessConfig.builder().commandLine(Arrays.asList("taskkill", "/F", "/pid", "" + pid)).output(output).build());
    }

    private static boolean isUnixLike(Platform platform) {
        return platform.operatingSystem() != OS.Windows;
    }

    public static boolean isProcessRunning(Platform platform, long pid) {
        try {
            if (Processes.isUnixLike(platform)) {
                Process pidof = Runtime.getRuntime().exec(new String[]{"kill", "-0", "" + pid});
                return pidof.waitFor() == 0;
            }
            String[] cmd = new String[]{"tasklist.exe", "/FI", "PID eq " + pid, "/FO", "CSV"};
            logger.trace("Command: {}", Arrays.asList(cmd));
            ProcessBuilder processBuilder = ProcessControl.newProcessBuilder(Arrays.asList(cmd), true);
            Process process = processBuilder.start();
            LogWatchStreamProcessor logWatch = new LogWatchStreamProcessor("" + pid, new HashSet<String>(), StreamToLineProcessor.wrap(Processors.silent()));
            Processors.connect(new InputStreamReader(process.getInputStream()), logWatch);
            logWatch.waitForResult(2000L);
            logger.trace("logWatch output: {}", (Object)logWatch.getOutput());
            return logWatch.isInitWithSuccess();
        }
        catch (IOException | InterruptedException e) {
            logger.error("Trying to get process status", (Throwable)e);
            e.printStackTrace();
            return false;
        }
    }

    static {
        String sourceVersion;
        logger = LoggerFactory.getLogger(ProcessControl.class);
        switch (sourceVersion = SourceVersion.latest().toString()) {
            case "RELEASE_9": {
                PID_HELPER = PidHelper.JDK_9;
                break;
            }
            case "RELEASE_10": 
            case "RELEASE_11": 
            case "RELEASE_12": 
            case "RELEASE_13": 
            case "RELEASE_14": 
            case "RELEASE_15": 
            case "RELEASE_16": 
            case "RELEASE_17": {
                PID_HELPER = PidHelper.JDK_11;
                break;
            }
            default: {
                PID_HELPER = PidHelper.LEGACY;
            }
        }
    }

    private static enum PidHelper {
        JDK_9{

            @Override
            Long getPid(Process process) {
                try {
                    Method getPid = Process.class.getMethod("getPid", new Class[0]);
                    return (Long)getPid.invoke((Object)process, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        ,
        JDK_11{

            @Override
            Long getPid(Process process) {
                try {
                    Method getPid = Process.class.getMethod("pid", new Class[0]);
                    return (Long)getPid.invoke((Object)process, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        ,
        LEGACY{

            @Override
            Long getPid(Process process) {
                Long pid = Processes.unixLikeProcessId(process);
                if (pid == null) {
                    pid = Processes.windowsProcessId(process);
                }
                return pid;
            }
        };


        abstract Long getPid(Process var1);
    }
}

