package de.flapdoodle.embed.process.config;

import de.flapdoodle.embed.process.config.process.ProcessOutput;
import de.flapdoodle.embed.process.runtime.CommandLinePostProcessor;
import de.flapdoodle.embed.process.store.IArtifactStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RuntimeConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRuntimeConfig.builder()}.
 */
@Generated(from = "RuntimeConfig", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableRuntimeConfig implements RuntimeConfig {
  private final ProcessOutput processOutput;
  private final CommandLinePostProcessor commandLinePostProcessor;
  private final IArtifactStore artifactStore;
  private final boolean isDaemonProcess;

  private ImmutableRuntimeConfig(ImmutableRuntimeConfig.Builder builder) {
    this.processOutput = builder.processOutput;
    this.artifactStore = builder.artifactStore;
    if (builder.commandLinePostProcessor != null) {
      initShim.commandLinePostProcessor(builder.commandLinePostProcessor);
    }
    if (builder.isDaemonProcessIsSet()) {
      initShim.isDaemonProcess(builder.isDaemonProcess);
    }
    this.commandLinePostProcessor = initShim.commandLinePostProcessor();
    this.isDaemonProcess = initShim.isDaemonProcess();
    this.initShim = null;
  }

  private ImmutableRuntimeConfig(
      ProcessOutput processOutput,
      CommandLinePostProcessor commandLinePostProcessor,
      IArtifactStore artifactStore,
      boolean isDaemonProcess) {
    this.processOutput = processOutput;
    this.commandLinePostProcessor = commandLinePostProcessor;
    this.artifactStore = artifactStore;
    this.isDaemonProcess = isDaemonProcess;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "RuntimeConfig", generator = "Immutables")
  private final class InitShim {
    private byte commandLinePostProcessorBuildStage = STAGE_UNINITIALIZED;
    private CommandLinePostProcessor commandLinePostProcessor;

    CommandLinePostProcessor commandLinePostProcessor() {
      if (commandLinePostProcessorBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (commandLinePostProcessorBuildStage == STAGE_UNINITIALIZED) {
        commandLinePostProcessorBuildStage = STAGE_INITIALIZING;
        this.commandLinePostProcessor = Objects.requireNonNull(commandLinePostProcessorInitialize(), "commandLinePostProcessor");
        commandLinePostProcessorBuildStage = STAGE_INITIALIZED;
      }
      return this.commandLinePostProcessor;
    }

    void commandLinePostProcessor(CommandLinePostProcessor commandLinePostProcessor) {
      this.commandLinePostProcessor = commandLinePostProcessor;
      commandLinePostProcessorBuildStage = STAGE_INITIALIZED;
    }

    private byte isDaemonProcessBuildStage = STAGE_UNINITIALIZED;
    private boolean isDaemonProcess;

    boolean isDaemonProcess() {
      if (isDaemonProcessBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isDaemonProcessBuildStage == STAGE_UNINITIALIZED) {
        isDaemonProcessBuildStage = STAGE_INITIALIZING;
        this.isDaemonProcess = isDaemonProcessInitialize();
        isDaemonProcessBuildStage = STAGE_INITIALIZED;
      }
      return this.isDaemonProcess;
    }

    void isDaemonProcess(boolean isDaemonProcess) {
      this.isDaemonProcess = isDaemonProcess;
      isDaemonProcessBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (commandLinePostProcessorBuildStage == STAGE_INITIALIZING) attributes.add("commandLinePostProcessor");
      if (isDaemonProcessBuildStage == STAGE_INITIALIZING) attributes.add("isDaemonProcess");
      return "Cannot build RuntimeConfig, attribute initializers form cycle " + attributes;
    }
  }

  private CommandLinePostProcessor commandLinePostProcessorInitialize() {
    return RuntimeConfig.super.commandLinePostProcessor();
  }

  private boolean isDaemonProcessInitialize() {
    return RuntimeConfig.super.isDaemonProcess();
  }

  /**
   * @return The value of the {@code processOutput} attribute
   */
  @Override
  public ProcessOutput processOutput() {
    return processOutput;
  }

  /**
   * @return The value of the {@code commandLinePostProcessor} attribute
   */
  @Override
  public CommandLinePostProcessor commandLinePostProcessor() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.commandLinePostProcessor()
        : this.commandLinePostProcessor;
  }

  /**
   * @return The value of the {@code artifactStore} attribute
   */
  @Override
  public IArtifactStore artifactStore() {
    return artifactStore;
  }

  /**
   * @return The value of the {@code isDaemonProcess} attribute
   */
  @Override
  public boolean isDaemonProcess() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isDaemonProcess()
        : this.isDaemonProcess;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RuntimeConfig#processOutput() processOutput} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processOutput
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRuntimeConfig withProcessOutput(ProcessOutput value) {
    if (this.processOutput == value) return this;
    ProcessOutput newValue = Objects.requireNonNull(value, "processOutput");
    return new ImmutableRuntimeConfig(newValue, this.commandLinePostProcessor, this.artifactStore, this.isDaemonProcess);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RuntimeConfig#commandLinePostProcessor() commandLinePostProcessor} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commandLinePostProcessor
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRuntimeConfig withCommandLinePostProcessor(CommandLinePostProcessor value) {
    if (this.commandLinePostProcessor == value) return this;
    CommandLinePostProcessor newValue = Objects.requireNonNull(value, "commandLinePostProcessor");
    return new ImmutableRuntimeConfig(this.processOutput, newValue, this.artifactStore, this.isDaemonProcess);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RuntimeConfig#artifactStore() artifactStore} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for artifactStore
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRuntimeConfig withArtifactStore(IArtifactStore value) {
    if (this.artifactStore == value) return this;
    IArtifactStore newValue = Objects.requireNonNull(value, "artifactStore");
    return new ImmutableRuntimeConfig(this.processOutput, this.commandLinePostProcessor, newValue, this.isDaemonProcess);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RuntimeConfig#isDaemonProcess() isDaemonProcess} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isDaemonProcess
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRuntimeConfig withIsDaemonProcess(boolean value) {
    if (this.isDaemonProcess == value) return this;
    return new ImmutableRuntimeConfig(this.processOutput, this.commandLinePostProcessor, this.artifactStore, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRuntimeConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRuntimeConfig
        && equalTo(0, (ImmutableRuntimeConfig) another);
  }

  private boolean equalTo(int synthetic, ImmutableRuntimeConfig another) {
    return processOutput.equals(another.processOutput)
        && commandLinePostProcessor.equals(another.commandLinePostProcessor)
        && artifactStore.equals(another.artifactStore)
        && isDaemonProcess == another.isDaemonProcess;
  }

  /**
   * Computes a hash code from attributes: {@code processOutput}, {@code commandLinePostProcessor}, {@code artifactStore}, {@code isDaemonProcess}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + processOutput.hashCode();
    h += (h << 5) + commandLinePostProcessor.hashCode();
    h += (h << 5) + artifactStore.hashCode();
    h += (h << 5) + Boolean.hashCode(isDaemonProcess);
    return h;
  }

  /**
   * Prints the immutable value {@code RuntimeConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RuntimeConfig{"
        + "processOutput=" + processOutput
        + ", commandLinePostProcessor=" + commandLinePostProcessor
        + ", artifactStore=" + artifactStore
        + ", isDaemonProcess=" + isDaemonProcess
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link RuntimeConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RuntimeConfig instance
   */
  public static ImmutableRuntimeConfig copyOf(RuntimeConfig instance) {
    if (instance instanceof ImmutableRuntimeConfig) {
      return (ImmutableRuntimeConfig) instance;
    }
    return ImmutableRuntimeConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRuntimeConfig ImmutableRuntimeConfig}.
   * <pre>
   * ImmutableRuntimeConfig.builder()
   *    .processOutput(de.flapdoodle.embed.process.config.process.ProcessOutput) // required {@link RuntimeConfig#processOutput() processOutput}
   *    .commandLinePostProcessor(de.flapdoodle.embed.process.runtime.CommandLinePostProcessor) // optional {@link RuntimeConfig#commandLinePostProcessor() commandLinePostProcessor}
   *    .artifactStore(de.flapdoodle.embed.process.store.IArtifactStore) // required {@link RuntimeConfig#artifactStore() artifactStore}
   *    .isDaemonProcess(boolean) // optional {@link RuntimeConfig#isDaemonProcess() isDaemonProcess}
   *    .build();
   * </pre>
   * @return A new ImmutableRuntimeConfig builder
   */
  public static ImmutableRuntimeConfig.Builder builder() {
    return new ImmutableRuntimeConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRuntimeConfig ImmutableRuntimeConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RuntimeConfig", generator = "Immutables")
  public static final class Builder implements RuntimeConfig.Builder {
    private static final long INIT_BIT_PROCESS_OUTPUT = 0x1L;
    private static final long INIT_BIT_ARTIFACT_STORE = 0x2L;
    private static final long OPT_BIT_IS_DAEMON_PROCESS = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private ProcessOutput processOutput;
    private CommandLinePostProcessor commandLinePostProcessor;
    private IArtifactStore artifactStore;
    private boolean isDaemonProcess;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RuntimeConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RuntimeConfig instance) {
      Objects.requireNonNull(instance, "instance");
      processOutput(instance.processOutput());
      commandLinePostProcessor(instance.commandLinePostProcessor());
      artifactStore(instance.artifactStore());
      isDaemonProcess(instance.isDaemonProcess());
      return this;
    }

    /**
     * Initializes the value for the {@link RuntimeConfig#processOutput() processOutput} attribute.
     * @param processOutput The value for processOutput 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processOutput(ProcessOutput processOutput) {
      this.processOutput = Objects.requireNonNull(processOutput, "processOutput");
      initBits &= ~INIT_BIT_PROCESS_OUTPUT;
      return this;
    }

    /**
     * Initializes the value for the {@link RuntimeConfig#commandLinePostProcessor() commandLinePostProcessor} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link RuntimeConfig#commandLinePostProcessor() commandLinePostProcessor}.</em>
     * @param commandLinePostProcessor The value for commandLinePostProcessor 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder commandLinePostProcessor(CommandLinePostProcessor commandLinePostProcessor) {
      this.commandLinePostProcessor = Objects.requireNonNull(commandLinePostProcessor, "commandLinePostProcessor");
      return this;
    }

    /**
     * Initializes the value for the {@link RuntimeConfig#artifactStore() artifactStore} attribute.
     * @param artifactStore The value for artifactStore 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder artifactStore(IArtifactStore artifactStore) {
      this.artifactStore = Objects.requireNonNull(artifactStore, "artifactStore");
      initBits &= ~INIT_BIT_ARTIFACT_STORE;
      return this;
    }

    /**
     * Initializes the value for the {@link RuntimeConfig#isDaemonProcess() isDaemonProcess} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link RuntimeConfig#isDaemonProcess() isDaemonProcess}.</em>
     * @param isDaemonProcess The value for isDaemonProcess 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isDaemonProcess(boolean isDaemonProcess) {
      this.isDaemonProcess = isDaemonProcess;
      optBits |= OPT_BIT_IS_DAEMON_PROCESS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRuntimeConfig ImmutableRuntimeConfig}.
     * @return An immutable instance of RuntimeConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRuntimeConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRuntimeConfig(this);
    }

    private boolean isDaemonProcessIsSet() {
      return (optBits & OPT_BIT_IS_DAEMON_PROCESS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PROCESS_OUTPUT) != 0) attributes.add("processOutput");
      if ((initBits & INIT_BIT_ARTIFACT_STORE) != 0) attributes.add("artifactStore");
      return "Cannot build RuntimeConfig, some of required attributes are not set " + attributes;
    }
  }
}
