package de.flapdoodle.embed.process.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SupportConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSupportConfig.builder()}.
 */
@Generated(from = "SupportConfig", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableSupportConfig implements SupportConfig {
  private final String name;
  private final String supportUrl;
  private final BiFunction<Class<?>, Exception, String> messageOnException;

  private ImmutableSupportConfig(
      String name,
      String supportUrl,
      BiFunction<Class<?>, Exception, String> messageOnException) {
    this.name = name;
    this.supportUrl = supportUrl;
    this.messageOnException = messageOnException;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code supportUrl} attribute
   */
  @Override
  public String supportUrl() {
    return supportUrl;
  }

  /**
   * @return The value of the {@code messageOnException} attribute
   */
  @Override
  public BiFunction<Class<?>, Exception, String> messageOnException() {
    return messageOnException;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SupportConfig#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSupportConfig withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableSupportConfig(newValue, this.supportUrl, this.messageOnException);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SupportConfig#supportUrl() supportUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for supportUrl
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSupportConfig withSupportUrl(String value) {
    String newValue = Objects.requireNonNull(value, "supportUrl");
    if (this.supportUrl.equals(newValue)) return this;
    return new ImmutableSupportConfig(this.name, newValue, this.messageOnException);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SupportConfig#messageOnException() messageOnException} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for messageOnException
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSupportConfig withMessageOnException(BiFunction<Class<?>, Exception, String> value) {
    if (this.messageOnException == value) return this;
    BiFunction<Class<?>, Exception, String> newValue = Objects.requireNonNull(value, "messageOnException");
    return new ImmutableSupportConfig(this.name, this.supportUrl, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSupportConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSupportConfig
        && equalTo(0, (ImmutableSupportConfig) another);
  }

  private boolean equalTo(int synthetic, ImmutableSupportConfig another) {
    return name.equals(another.name)
        && supportUrl.equals(another.supportUrl)
        && messageOnException.equals(another.messageOnException);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code supportUrl}, {@code messageOnException}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + supportUrl.hashCode();
    h += (h << 5) + messageOnException.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SupportConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SupportConfig{"
        + "name=" + name
        + ", supportUrl=" + supportUrl
        + ", messageOnException=" + messageOnException
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link SupportConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SupportConfig instance
   */
  public static ImmutableSupportConfig copyOf(SupportConfig instance) {
    if (instance instanceof ImmutableSupportConfig) {
      return (ImmutableSupportConfig) instance;
    }
    return ImmutableSupportConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSupportConfig ImmutableSupportConfig}.
   * <pre>
   * ImmutableSupportConfig.builder()
   *    .name(String) // required {@link SupportConfig#name() name}
   *    .supportUrl(String) // required {@link SupportConfig#supportUrl() supportUrl}
   *    .messageOnException(function.BiFunction&amp;lt;Class&amp;lt;?&amp;gt;, Exception, String&amp;gt;) // required {@link SupportConfig#messageOnException() messageOnException}
   *    .build();
   * </pre>
   * @return A new ImmutableSupportConfig builder
   */
  public static ImmutableSupportConfig.Builder builder() {
    return new ImmutableSupportConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSupportConfig ImmutableSupportConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SupportConfig", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_SUPPORT_URL = 0x2L;
    private static final long INIT_BIT_MESSAGE_ON_EXCEPTION = 0x4L;
    private long initBits = 0x7L;

    private String name;
    private String supportUrl;
    private BiFunction<Class<?>, Exception, String> messageOnException;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SupportConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SupportConfig instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      supportUrl(instance.supportUrl());
      messageOnException(instance.messageOnException());
      return this;
    }

    /**
     * Initializes the value for the {@link SupportConfig#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link SupportConfig#supportUrl() supportUrl} attribute.
     * @param supportUrl The value for supportUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportUrl(String supportUrl) {
      this.supportUrl = Objects.requireNonNull(supportUrl, "supportUrl");
      initBits &= ~INIT_BIT_SUPPORT_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link SupportConfig#messageOnException() messageOnException} attribute.
     * @param messageOnException The value for messageOnException 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder messageOnException(BiFunction<Class<?>, Exception, String> messageOnException) {
      this.messageOnException = Objects.requireNonNull(messageOnException, "messageOnException");
      initBits &= ~INIT_BIT_MESSAGE_ON_EXCEPTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSupportConfig ImmutableSupportConfig}.
     * @return An immutable instance of SupportConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSupportConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSupportConfig(name, supportUrl, messageOnException);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_SUPPORT_URL) != 0) attributes.add("supportUrl");
      if ((initBits & INIT_BIT_MESSAGE_ON_EXCEPTION) != 0) attributes.add("messageOnException");
      return "Cannot build SupportConfig, some of required attributes are not set " + attributes;
    }
  }
}
