package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.config.store.DownloadConfig;
import de.flapdoodle.embed.process.extract.TempNaming;
import de.flapdoodle.embed.process.io.directories.Directory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ArtifactStore}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableArtifactStore.builder()}.
 */
@Generated(from = "ArtifactStore", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableArtifactStore extends ArtifactStore {
  private final DownloadConfig downloadConfig;
  private final Directory tempDirFactory;
  private final TempNaming executableNaming;
  private final Downloader downloader;

  private ImmutableArtifactStore(
      DownloadConfig downloadConfig,
      Directory tempDirFactory,
      TempNaming executableNaming,
      Downloader downloader) {
    this.downloadConfig = downloadConfig;
    this.tempDirFactory = tempDirFactory;
    this.executableNaming = executableNaming;
    this.downloader = downloader;
  }

  /**
   * @return The value of the {@code downloadConfig} attribute
   */
  @Override
  DownloadConfig downloadConfig() {
    return downloadConfig;
  }

  /**
   * @return The value of the {@code tempDirFactory} attribute
   */
  @Override
  Directory tempDirFactory() {
    return tempDirFactory;
  }

  /**
   * @return The value of the {@code executableNaming} attribute
   */
  @Override
  TempNaming executableNaming() {
    return executableNaming;
  }

  /**
   * @return The value of the {@code downloader} attribute
   */
  @Override
  Downloader downloader() {
    return downloader;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ArtifactStore#downloadConfig() downloadConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for downloadConfig
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArtifactStore withDownloadConfig(DownloadConfig value) {
    if (this.downloadConfig == value) return this;
    DownloadConfig newValue = Objects.requireNonNull(value, "downloadConfig");
    return new ImmutableArtifactStore(newValue, this.tempDirFactory, this.executableNaming, this.downloader);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ArtifactStore#tempDirFactory() tempDirFactory} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tempDirFactory
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArtifactStore withTempDirFactory(Directory value) {
    if (this.tempDirFactory == value) return this;
    Directory newValue = Objects.requireNonNull(value, "tempDirFactory");
    return new ImmutableArtifactStore(this.downloadConfig, newValue, this.executableNaming, this.downloader);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ArtifactStore#executableNaming() executableNaming} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for executableNaming
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArtifactStore withExecutableNaming(TempNaming value) {
    if (this.executableNaming == value) return this;
    TempNaming newValue = Objects.requireNonNull(value, "executableNaming");
    return new ImmutableArtifactStore(this.downloadConfig, this.tempDirFactory, newValue, this.downloader);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ArtifactStore#downloader() downloader} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for downloader
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArtifactStore withDownloader(Downloader value) {
    if (this.downloader == value) return this;
    Downloader newValue = Objects.requireNonNull(value, "downloader");
    return new ImmutableArtifactStore(this.downloadConfig, this.tempDirFactory, this.executableNaming, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableArtifactStore} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableArtifactStore
        && equalTo(0, (ImmutableArtifactStore) another);
  }

  private boolean equalTo(int synthetic, ImmutableArtifactStore another) {
    return downloadConfig.equals(another.downloadConfig)
        && tempDirFactory.equals(another.tempDirFactory)
        && executableNaming.equals(another.executableNaming)
        && downloader.equals(another.downloader);
  }

  /**
   * Computes a hash code from attributes: {@code downloadConfig}, {@code tempDirFactory}, {@code executableNaming}, {@code downloader}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + downloadConfig.hashCode();
    h += (h << 5) + tempDirFactory.hashCode();
    h += (h << 5) + executableNaming.hashCode();
    h += (h << 5) + downloader.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ArtifactStore} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ArtifactStore{"
        + "downloadConfig=" + downloadConfig
        + ", tempDirFactory=" + tempDirFactory
        + ", executableNaming=" + executableNaming
        + ", downloader=" + downloader
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ArtifactStore} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ArtifactStore instance
   */
  public static ImmutableArtifactStore copyOf(ArtifactStore instance) {
    if (instance instanceof ImmutableArtifactStore) {
      return (ImmutableArtifactStore) instance;
    }
    return ImmutableArtifactStore.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableArtifactStore ImmutableArtifactStore}.
   * <pre>
   * ImmutableArtifactStore.builder()
   *    .downloadConfig(de.flapdoodle.embed.process.config.store.DownloadConfig) // required {@link ArtifactStore#downloadConfig() downloadConfig}
   *    .tempDirFactory(de.flapdoodle.embed.process.io.directories.Directory) // required {@link ArtifactStore#tempDirFactory() tempDirFactory}
   *    .executableNaming(de.flapdoodle.embed.process.extract.TempNaming) // required {@link ArtifactStore#executableNaming() executableNaming}
   *    .downloader(de.flapdoodle.embed.process.store.Downloader) // required {@link ArtifactStore#downloader() downloader}
   *    .build();
   * </pre>
   * @return A new ImmutableArtifactStore builder
   */
  public static ImmutableArtifactStore.Builder builder() {
    return new ImmutableArtifactStore.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableArtifactStore ImmutableArtifactStore}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ArtifactStore", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DOWNLOAD_CONFIG = 0x1L;
    private static final long INIT_BIT_TEMP_DIR_FACTORY = 0x2L;
    private static final long INIT_BIT_EXECUTABLE_NAMING = 0x4L;
    private static final long INIT_BIT_DOWNLOADER = 0x8L;
    private long initBits = 0xfL;

    private DownloadConfig downloadConfig;
    private Directory tempDirFactory;
    private TempNaming executableNaming;
    private Downloader downloader;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ArtifactStore} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ArtifactStore instance) {
      Objects.requireNonNull(instance, "instance");
      downloadConfig(instance.downloadConfig());
      tempDirFactory(instance.tempDirFactory());
      executableNaming(instance.executableNaming());
      downloader(instance.downloader());
      return this;
    }

    /**
     * Initializes the value for the {@link ArtifactStore#downloadConfig() downloadConfig} attribute.
     * @param downloadConfig The value for downloadConfig 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder downloadConfig(DownloadConfig downloadConfig) {
      this.downloadConfig = Objects.requireNonNull(downloadConfig, "downloadConfig");
      initBits &= ~INIT_BIT_DOWNLOAD_CONFIG;
      return this;
    }

    /**
     * Initializes the value for the {@link ArtifactStore#tempDirFactory() tempDirFactory} attribute.
     * @param tempDirFactory The value for tempDirFactory 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tempDirFactory(Directory tempDirFactory) {
      this.tempDirFactory = Objects.requireNonNull(tempDirFactory, "tempDirFactory");
      initBits &= ~INIT_BIT_TEMP_DIR_FACTORY;
      return this;
    }

    /**
     * Initializes the value for the {@link ArtifactStore#executableNaming() executableNaming} attribute.
     * @param executableNaming The value for executableNaming 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder executableNaming(TempNaming executableNaming) {
      this.executableNaming = Objects.requireNonNull(executableNaming, "executableNaming");
      initBits &= ~INIT_BIT_EXECUTABLE_NAMING;
      return this;
    }

    /**
     * Initializes the value for the {@link ArtifactStore#downloader() downloader} attribute.
     * @param downloader The value for downloader 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder downloader(Downloader downloader) {
      this.downloader = Objects.requireNonNull(downloader, "downloader");
      initBits &= ~INIT_BIT_DOWNLOADER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableArtifactStore ImmutableArtifactStore}.
     * @return An immutable instance of ArtifactStore
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableArtifactStore build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableArtifactStore(downloadConfig, tempDirFactory, executableNaming, downloader);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DOWNLOAD_CONFIG) != 0) attributes.add("downloadConfig");
      if ((initBits & INIT_BIT_TEMP_DIR_FACTORY) != 0) attributes.add("tempDirFactory");
      if ((initBits & INIT_BIT_EXECUTABLE_NAMING) != 0) attributes.add("executableNaming");
      if ((initBits & INIT_BIT_DOWNLOADER) != 0) attributes.add("downloader");
      return "Cannot build ArtifactStore, some of required attributes are not set " + attributes;
    }
  }
}
