/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.extract;

import de.flapdoodle.embed.process.config.store.DownloadConfig;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.extract.ArchiveEntry;
import de.flapdoodle.embed.process.extract.ExtractedFileSet;
import de.flapdoodle.embed.process.extract.ExtractionMatch;
import de.flapdoodle.embed.process.extract.Extractor;
import de.flapdoodle.embed.process.extract.FilesToExtract;
import de.flapdoodle.embed.process.extract.ImmutableExtractedFileSet;
import de.flapdoodle.embed.process.io.progress.ProgressListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class ArchiveIsFileExtractor
implements Extractor {
    @Override
    public ExtractedFileSet extract(DownloadConfig runtime, File source, FilesToExtract toExtract) throws IOException {
        ImmutableExtractedFileSet.Builder builder = ExtractedFileSet.builder(toExtract.baseDir()).baseDirIsGenerated(toExtract.baseDirIsGenerated());
        ProgressListener progressListener = runtime.getProgressListener();
        String progressLabel = "Extract (not really) " + source;
        progressListener.start(progressLabel);
        ExtractionMatch match = toExtract.find(new FileAsArchiveEntry(source));
        if (match != null) {
            try (FileInputStream fin = new FileInputStream(source);
                 BufferedInputStream in = new BufferedInputStream(fin);){
                File file = match.write(in, source.length());
                FileType type = match.type();
                if (type == FileType.Executable) {
                    builder.executable(file);
                } else {
                    builder.addLibraryFiles(file);
                }
                if (!toExtract.nothingLeft()) {
                    progressListener.info(progressLabel, "Something went a little wrong. Listener say something is left, but we dont have anything");
                }
                progressListener.done(progressLabel);
            }
        }
        return builder.build();
    }

    static class FileAsArchiveEntry
    implements ArchiveEntry {
        private final File _source;

        public FileAsArchiveEntry(File source) {
            this._source = source;
        }

        @Override
        public boolean isDirectory() {
            return this._source.isDirectory();
        }

        @Override
        public String getName() {
            return this._source.getName();
        }
    }
}

