package de.flapdoodle.embed.process.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Percent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePercent.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutablePercent.of()}.
 */
@Generated(from = "Percent", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutablePercent extends Percent {
  private final int value;

  private ImmutablePercent(int value) {
    this.value = value;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public int value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Percent#value() value} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePercent withValue(int value) {
    if (this.value == value) return this;
    return validate(new ImmutablePercent(value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePercent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePercent
        && equalTo(0, (ImmutablePercent) another);
  }

  private boolean equalTo(int synthetic, ImmutablePercent another) {
    return value == another.value;
  }

  /**
   * Computes a hash code from attributes: {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + value;
    return h;
  }

  /**
   * Prints the immutable value {@code Percent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Percent{"
        + "value=" + value
        + "}";
  }

  /**
   * Construct a new immutable {@code Percent} instance.
   * @param value The value for the {@code value} attribute
   * @return An immutable Percent instance
   */
  public static ImmutablePercent of(int value) {
    return validate(new ImmutablePercent(value));
  }

  private static ImmutablePercent validate(ImmutablePercent instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Percent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Percent instance
   */
  public static ImmutablePercent copyOf(Percent instance) {
    if (instance instanceof ImmutablePercent) {
      return (ImmutablePercent) instance;
    }
    return ImmutablePercent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePercent ImmutablePercent}.
   * <pre>
   * ImmutablePercent.builder()
   *    .value(int) // required {@link Percent#value() value}
   *    .build();
   * </pre>
   * @return A new ImmutablePercent builder
   */
  public static ImmutablePercent.Builder builder() {
    return new ImmutablePercent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePercent ImmutablePercent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Percent", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    private int value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Percent} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Percent instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.value());
      return this;
    }

    /**
     * Initializes the value for the {@link Percent#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder value(int value) {
      this.value = value;
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePercent ImmutablePercent}.
     * @return An immutable instance of Percent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePercent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutablePercent.validate(new ImmutablePercent(value));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build Percent, some of required attributes are not set " + attributes;
    }
  }
}
