/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import de.flapdoodle.embed.process.config.SupportConfig;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.ReaderProcessor;
import de.flapdoodle.embed.process.io.StreamProcessor;
import de.flapdoodle.embed.process.runtime.Processes;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessControl {
    private static final long MAX_STOP_TIMEOUT_MS = 5000L;
    private static Logger logger = LoggerFactory.getLogger(ProcessControl.class);
    private final Process process;
    private InputStreamReader reader;
    private final InputStreamReader error;
    private final Long pid;
    private final SupportConfig runtime;

    public ProcessControl(SupportConfig runtime, Process process) {
        this.process = process;
        this.runtime = runtime;
        this.reader = new InputStreamReader(this.process.getInputStream());
        this.error = new InputStreamReader(this.process.getErrorStream());
        this.pid = Processes.processId(this.process);
    }

    public Reader getReader() {
        return this.reader;
    }

    public InputStreamReader getError() {
        return this.error;
    }

    public int stop() {
        return this.stop(5000L);
    }

    public int stop(long maxStopTimeoutMillis) {
        return this.waitForProcessGotKilled(maxStopTimeoutMillis);
    }

    private void closeIOAndDestroy() {
        if (this.process != null) {
            try {
                this.process.getErrorStream().close();
                this.process.getInputStream().close();
                this.process.getOutputStream().close();
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
            this.reader = null;
        }
    }

    private Integer stopOrDestroyProcess(long maxStopTimeoutMillis) {
        Integer returnCode;
        block9: {
            returnCode = null;
            if (maxStopTimeoutMillis < 3000L) {
                maxStopTimeoutMillis = 5000L;
            }
            try {
                returnCode = this.process.exitValue();
            }
            catch (IllegalThreadStateException itsx) {
                logger.info("stopOrDestroyProcess: " + itsx.getMessage() + " " + (itsx.getCause() != null ? itsx.getCause() : ""));
                Callable<Integer> callable = this.process::waitFor;
                FutureTask<Integer> task = new FutureTask<Integer>(callable);
                new Thread(task).start();
                boolean stopped = false;
                try {
                    try {
                        returnCode = task.get(100L, TimeUnit.MILLISECONDS);
                        stopped = true;
                    }
                    catch (ExecutionException | TimeoutException exception) {
                        // empty catch block
                    }
                    this.closeIOAndDestroy();
                    try {
                        returnCode = task.get(maxStopTimeoutMillis, TimeUnit.MILLISECONDS);
                        stopped = true;
                    }
                    catch (ExecutionException | TimeoutException exception) {}
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (stopped) break block9;
                this.process.destroy();
            }
        }
        return returnCode;
    }

    private int waitForProcessGotKilled(long maxStopTimeoutMillis) {
        Integer retCode = this.stopOrDestroyProcess(maxStopTimeoutMillis);
        if (retCode == null) {
            String message = "\n\n----------------------------------------------------\nSomething bad happened. We couldn't kill " + this.runtime.name() + " process, and tried a lot.\nIf you want this problem solved you can help us if you open a new issue.\n\nFollow this link:\n" + this.runtime.supportUrl() + "\nThank you:)\n----------------------------------------------------\n\n";
            throw new IllegalStateException("Couldn't kill " + this.runtime.name() + " process!" + message);
        }
        return retCode;
    }

    public static ProcessControl fromCommandLine(SupportConfig runtime, List<String> commandLine, boolean redirectErrorStream) throws IOException {
        ProcessBuilder processBuilder = ProcessControl.newProcessBuilder(commandLine, redirectErrorStream);
        return ProcessControl.start(runtime, processBuilder);
    }

    public static ProcessControl start(SupportConfig runtime, ProcessBuilder processBuilder) throws IOException {
        return new ProcessControl(runtime, processBuilder.start());
    }

    public static ProcessBuilder newProcessBuilder(List<String> commandLine, boolean redirectErrorStream) {
        return ProcessControl.newProcessBuilder(commandLine, new HashMap<String, String>(), redirectErrorStream);
    }

    public static ProcessBuilder newProcessBuilder(List<String> commandLine, Map<String, String> environment, boolean redirectErrorStream) {
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        if (!environment.isEmpty()) {
            processBuilder.environment().putAll(environment);
        }
        if (redirectErrorStream) {
            processBuilder.redirectErrorStream();
        }
        return processBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeCommandLine(SupportConfig support, List<String> commandLine, Consumer<ProcessControl> beforeStop, StreamProcessor output, boolean redirectErrorStream) {
        ProcessControl process = ProcessControl.fromCommandLine(support, commandLine, redirectErrorStream);
        ReaderProcessor processor = Processors.connect(process.getReader(), output);
        try {
            beforeStop.accept(process);
            boolean ret = process.stop() == 0;
            logger.info("execSuccess: {} {}", (Object)ret, commandLine);
            boolean bl = ret;
            processor.abort();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                processor.abort();
                throw throwable;
            }
            catch (IOException e) {
                logger.error("" + commandLine, (Throwable)e);
                return false;
            }
        }
    }

    public int waitFor() throws InterruptedException {
        return this.process.waitFor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitFor(long timeoutInMs) throws InterruptedException {
        Process process = this.process;
        synchronized (process) {
            while (this.process.isAlive()) {
                this.process.wait(timeoutInMs);
            }
            return this.process.exitValue();
        }
    }

    public static void addShutdownHook(Runnable runnable) {
        Runtime.getRuntime().addShutdownHook(new Thread(runnable));
    }

    public Long getPid() {
        return this.pid;
    }
}

