/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.net;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.embed.process.config.TimeoutConfig;
import de.flapdoodle.embed.process.io.progress.ProgressListener;
import de.flapdoodle.types.Optionals;
import de.flapdoodle.types.ThrowingFunction;
import de.flapdoodle.types.ThrowingSupplier;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;

public abstract class UrlStreams {
    static final int BUFFER_LENGTH = 65536;
    static final int READ_COUNT_MULTIPLIER = 100;

    public static <E extends Exception> void downloadTo(URLConnection connection, Path destination, DownloadCopyListener copyListener) throws IOException {
        UrlStreams.downloadTo(connection, destination, c -> UrlStreams.downloadIntoTempFile(c, copyListener));
    }

    protected static <E extends Exception> void downloadTo(URLConnection connection, Path destination, ThrowingFunction<URLConnection, Path, E> urlToTempFile) throws IOException, E {
        Preconditions.checkArgument((!destination.toFile().exists() ? 1 : 0) != 0, (String)"destination exists: %s", (Object[])new Object[]{destination});
        Path tempFile = (Path)urlToTempFile.apply((Object)connection);
        Files.copy(tempFile, destination, new CopyOption[0]);
        Files.delete(tempFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Path downloadIntoTempFile(URLConnection connection, DownloadCopyListener copyListener) throws IOException, FileNotFoundException {
        Path tempFile = Files.createTempFile("download", "", new FileAttribute[0]);
        boolean downloadSucceeded = false;
        try {
            UrlStreams.downloadAndCopy(connection, () -> new BufferedOutputStream(Files.newOutputStream(tempFile.toFile().toPath(), new OpenOption[0])), copyListener);
            downloadSucceeded = true;
            Path path = tempFile;
            return path;
        }
        finally {
            if (!downloadSucceeded) {
                Files.delete(tempFile);
            }
        }
    }

    private static <E extends Exception> void downloadAndCopy(URLConnection connection, ThrowingSupplier<BufferedOutputStream, E> output, DownloadCopyListener copyListener) throws IOException, E {
        long length = connection.getContentLengthLong();
        copyListener.downloaded(connection.getURL(), 0L, length);
        try (BufferedInputStream bis = new BufferedInputStream(connection.getInputStream());
             BufferedOutputStream bos = (BufferedOutputStream)output.get();){
            byte[] buf = new byte[65536];
            int read = 0;
            long readCount = 0L;
            while ((read = bis.read(buf)) != -1) {
                bos.write(buf, 0, read);
                Preconditions.checkArgument((length == -1L || length >= (readCount += (long)read) ? 1 : 0) != 0, (String)"hmm.. readCount bigger than contentLength(more than we want to): %s > %s", (Object[])new Object[]{readCount, length});
                copyListener.downloaded(connection.getURL(), readCount, length);
            }
            bos.flush();
            Preconditions.checkArgument((length == -1L || length == readCount ? 1 : 0) != 0, (String)"hmm.. readCount smaller than contentLength(partial download?): %s > %s", (Object[])new Object[]{readCount, length});
        }
    }

    public static URLConnection urlConnectionOf(URL url, String userAgent, TimeoutConfig timeoutConfig, Optional<Proxy> proxy) throws IOException {
        URLConnection openConnection = (URLConnection)Optionals.with(proxy).map(url::openConnection).orElseGet(url::openConnection);
        openConnection.setRequestProperty("User-Agent", userAgent);
        openConnection.setConnectTimeout(timeoutConfig.getConnectionTimeout());
        openConnection.setReadTimeout(timeoutConfig.getReadTimeout());
        return openConnection;
    }

    public static DownloadCopyListener downloadCopyListenerDelegatingTo(ProgressListener progressListener) {
        return (url, bytesCopied, contentLength) -> {
            if (bytesCopied == 0L) {
                progressListener.start("download " + url);
            } else if (contentLength != -1L) {
                if (bytesCopied == contentLength) {
                    progressListener.done("download " + url);
                } else {
                    int percent = (int)(bytesCopied * 100L / contentLength);
                    progressListener.progress("download " + url, percent);
                }
            } else {
                progressListener.info("download " + url, bytesCopied + " bytes");
            }
        };
    }

    public static interface DownloadCopyListener {
        public void downloaded(URL var1, long var2, long var4);
    }
}

