/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo;

import de.flapdoodle.embedmongo.Downloader;
import de.flapdoodle.embedmongo.Files;
import de.flapdoodle.embedmongo.LocalArtifactStore;
import de.flapdoodle.embedmongo.MongodExecutable;
import de.flapdoodle.embedmongo.Paths;
import de.flapdoodle.embedmongo.config.MongodConfig;
import de.flapdoodle.embedmongo.config.RuntimeConfig;
import de.flapdoodle.embedmongo.distribution.Distribution;
import de.flapdoodle.embedmongo.exceptions.MongodException;
import de.flapdoodle.embedmongo.extract.Extractors;
import de.flapdoodle.embedmongo.extract.IExtractor;
import de.flapdoodle.embedmongo.output.IProgressListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MongoDBRuntime {
    private static Logger logger = Logger.getLogger(MongoDBRuntime.class.getName());
    private final RuntimeConfig runtime;

    private MongoDBRuntime(RuntimeConfig config) {
        this.runtime = config;
    }

    public static MongoDBRuntime getInstance(RuntimeConfig config) {
        return new MongoDBRuntime(config);
    }

    public static MongoDBRuntime getDefaultInstance() {
        return MongoDBRuntime.getInstance(new RuntimeConfig());
    }

    public boolean checkDistribution(Distribution distribution) throws IOException {
        if (!LocalArtifactStore.checkArtifact(this.runtime, distribution)) {
            return LocalArtifactStore.store(this.runtime, distribution, Downloader.download(this.runtime, distribution));
        }
        return true;
    }

    public MongodExecutable prepare(MongodConfig mongodConfig) {
        Distribution distribution = Distribution.detectFor(mongodConfig.getVersion());
        try {
            IProgressListener progress = this.runtime.getProgressListener();
            progress.done("Detect Distribution");
            if (this.checkDistribution(distribution)) {
                progress.done("Check Distribution");
                File mongodExe = this.extractMongod(distribution);
                return new MongodExecutable(distribution, mongodConfig, this.runtime, mongodExe);
            }
            throw new MongodException("could not find Distribution", distribution);
        }
        catch (IOException iox) {
            logger.log(Level.SEVERE, "start", iox);
            throw new MongodException(distribution, (Throwable)iox);
        }
    }

    protected File extractMongod(Distribution distribution) throws IOException {
        File artifact = LocalArtifactStore.getArtifact(this.runtime, distribution);
        IExtractor extractor = Extractors.getExtractor(distribution);
        File mongodExe = Files.createTempFile(this.runtime.getExecutableNaming().nameFor("extract", Paths.getMongodExecutable(distribution)));
        extractor.extract(this.runtime, artifact, mongodExe, Paths.getMongodExecutablePattern(distribution));
        return mongodExe;
    }
}

