package de.flapdoodle.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GraphAsDot}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGraphAsDot.builder()}.
 */
@Generated(from = "GraphAsDot", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableGraphAsDot<T> extends GraphAsDot<T> {
  private final Function<T, String> nodeAsId;
  private final String subGraphIdSeparator;
  private final Function<T, String> nodeAsLabel;
  private final BiFunction<T, T, Map<String, String>> edgeAttributes;
  private final Function<T, Map<String, String>> nodeAttributes;
  private final Function<T, Optional<GraphAsDot.SubGraph<T>>> subGraph;
  private final Function<T, Comparable> sortedBy;
  private final String label;

  private ImmutableGraphAsDot(ImmutableGraphAsDot.Builder<T> builder) {
    this.nodeAsId = builder.nodeAsId;
    this.sortedBy = builder.sortedBy;
    if (builder.subGraphIdSeparator != null) {
      initShim.subGraphIdSeparator(builder.subGraphIdSeparator);
    }
    if (builder.nodeAsLabel != null) {
      initShim.nodeAsLabel(builder.nodeAsLabel);
    }
    if (builder.edgeAttributes != null) {
      initShim.edgeAttributes(builder.edgeAttributes);
    }
    if (builder.nodeAttributes != null) {
      initShim.nodeAttributes(builder.nodeAttributes);
    }
    if (builder.subGraph != null) {
      initShim.subGraph(builder.subGraph);
    }
    if (builder.label != null) {
      initShim.label(builder.label);
    }
    this.subGraphIdSeparator = initShim.subGraphIdSeparator();
    this.nodeAsLabel = initShim.nodeAsLabel();
    this.edgeAttributes = initShim.edgeAttributes();
    this.nodeAttributes = initShim.nodeAttributes();
    this.subGraph = initShim.subGraph();
    this.label = initShim.label();
    this.initShim = null;
  }

  private ImmutableGraphAsDot(
      Function<T, String> nodeAsId,
      String subGraphIdSeparator,
      Function<T, String> nodeAsLabel,
      BiFunction<T, T, Map<String, String>> edgeAttributes,
      Function<T, Map<String, String>> nodeAttributes,
      Function<T, Optional<GraphAsDot.SubGraph<T>>> subGraph,
      Function<T, Comparable> sortedBy,
      String label) {
    this.nodeAsId = nodeAsId;
    this.subGraphIdSeparator = subGraphIdSeparator;
    this.nodeAsLabel = nodeAsLabel;
    this.edgeAttributes = edgeAttributes;
    this.nodeAttributes = nodeAttributes;
    this.subGraph = subGraph;
    this.sortedBy = sortedBy;
    this.label = label;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "GraphAsDot", generator = "Immutables")
  private final class InitShim {
    private byte subGraphIdSeparatorBuildStage = STAGE_UNINITIALIZED;
    private String subGraphIdSeparator;

    String subGraphIdSeparator() {
      if (subGraphIdSeparatorBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (subGraphIdSeparatorBuildStage == STAGE_UNINITIALIZED) {
        subGraphIdSeparatorBuildStage = STAGE_INITIALIZING;
        this.subGraphIdSeparator = Objects.requireNonNull(ImmutableGraphAsDot.super.subGraphIdSeparator(), "subGraphIdSeparator");
        subGraphIdSeparatorBuildStage = STAGE_INITIALIZED;
      }
      return this.subGraphIdSeparator;
    }

    void subGraphIdSeparator(String subGraphIdSeparator) {
      this.subGraphIdSeparator = subGraphIdSeparator;
      subGraphIdSeparatorBuildStage = STAGE_INITIALIZED;
    }

    private byte nodeAsLabelBuildStage = STAGE_UNINITIALIZED;
    private Function<T, String> nodeAsLabel;

    Function<T, String> nodeAsLabel() {
      if (nodeAsLabelBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nodeAsLabelBuildStage == STAGE_UNINITIALIZED) {
        nodeAsLabelBuildStage = STAGE_INITIALIZING;
        this.nodeAsLabel = Objects.requireNonNull(ImmutableGraphAsDot.super.nodeAsLabel(), "nodeAsLabel");
        nodeAsLabelBuildStage = STAGE_INITIALIZED;
      }
      return this.nodeAsLabel;
    }

    void nodeAsLabel(Function<T, String> nodeAsLabel) {
      this.nodeAsLabel = nodeAsLabel;
      nodeAsLabelBuildStage = STAGE_INITIALIZED;
    }

    private byte edgeAttributesBuildStage = STAGE_UNINITIALIZED;
    private BiFunction<T, T, Map<String, String>> edgeAttributes;

    BiFunction<T, T, Map<String, String>> edgeAttributes() {
      if (edgeAttributesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (edgeAttributesBuildStage == STAGE_UNINITIALIZED) {
        edgeAttributesBuildStage = STAGE_INITIALIZING;
        this.edgeAttributes = Objects.requireNonNull(ImmutableGraphAsDot.super.edgeAttributes(), "edgeAttributes");
        edgeAttributesBuildStage = STAGE_INITIALIZED;
      }
      return this.edgeAttributes;
    }

    void edgeAttributes(BiFunction<T, T, Map<String, String>> edgeAttributes) {
      this.edgeAttributes = edgeAttributes;
      edgeAttributesBuildStage = STAGE_INITIALIZED;
    }

    private byte nodeAttributesBuildStage = STAGE_UNINITIALIZED;
    private Function<T, Map<String, String>> nodeAttributes;

    Function<T, Map<String, String>> nodeAttributes() {
      if (nodeAttributesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nodeAttributesBuildStage == STAGE_UNINITIALIZED) {
        nodeAttributesBuildStage = STAGE_INITIALIZING;
        this.nodeAttributes = Objects.requireNonNull(ImmutableGraphAsDot.super.nodeAttributes(), "nodeAttributes");
        nodeAttributesBuildStage = STAGE_INITIALIZED;
      }
      return this.nodeAttributes;
    }

    void nodeAttributes(Function<T, Map<String, String>> nodeAttributes) {
      this.nodeAttributes = nodeAttributes;
      nodeAttributesBuildStage = STAGE_INITIALIZED;
    }

    private byte subGraphBuildStage = STAGE_UNINITIALIZED;
    private Function<T, Optional<GraphAsDot.SubGraph<T>>> subGraph;

    Function<T, Optional<GraphAsDot.SubGraph<T>>> subGraph() {
      if (subGraphBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (subGraphBuildStage == STAGE_UNINITIALIZED) {
        subGraphBuildStage = STAGE_INITIALIZING;
        this.subGraph = Objects.requireNonNull(ImmutableGraphAsDot.super.subGraph(), "subGraph");
        subGraphBuildStage = STAGE_INITIALIZED;
      }
      return this.subGraph;
    }

    void subGraph(Function<T, Optional<GraphAsDot.SubGraph<T>>> subGraph) {
      this.subGraph = subGraph;
      subGraphBuildStage = STAGE_INITIALIZED;
    }

    private byte labelBuildStage = STAGE_UNINITIALIZED;
    private String label;

    String label() {
      if (labelBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (labelBuildStage == STAGE_UNINITIALIZED) {
        labelBuildStage = STAGE_INITIALIZING;
        this.label = Objects.requireNonNull(ImmutableGraphAsDot.super.label(), "label");
        labelBuildStage = STAGE_INITIALIZED;
      }
      return this.label;
    }

    void label(String label) {
      this.label = label;
      labelBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (subGraphIdSeparatorBuildStage == STAGE_INITIALIZING) attributes.add("subGraphIdSeparator");
      if (nodeAsLabelBuildStage == STAGE_INITIALIZING) attributes.add("nodeAsLabel");
      if (edgeAttributesBuildStage == STAGE_INITIALIZING) attributes.add("edgeAttributes");
      if (nodeAttributesBuildStage == STAGE_INITIALIZING) attributes.add("nodeAttributes");
      if (subGraphBuildStage == STAGE_INITIALIZING) attributes.add("subGraph");
      if (labelBuildStage == STAGE_INITIALIZING) attributes.add("label");
      return "Cannot build GraphAsDot, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code nodeAsId} attribute
   */
  @Override
  public Function<T, String> nodeAsId() {
    return nodeAsId;
  }

  /**
   * @return The value of the {@code subGraphIdSeparator} attribute
   */
  @Override
  public String subGraphIdSeparator() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.subGraphIdSeparator()
        : this.subGraphIdSeparator;
  }

  /**
   * @return The value of the {@code nodeAsLabel} attribute
   */
  @Override
  public Function<T, String> nodeAsLabel() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.nodeAsLabel()
        : this.nodeAsLabel;
  }

  /**
   * @return The value of the {@code edgeAttributes} attribute
   */
  @Override
  public BiFunction<T, T, Map<String, String>> edgeAttributes() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.edgeAttributes()
        : this.edgeAttributes;
  }

  /**
   * @return The value of the {@code nodeAttributes} attribute
   */
  @Override
  public Function<T, Map<String, String>> nodeAttributes() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.nodeAttributes()
        : this.nodeAttributes;
  }

  /**
   * @return The value of the {@code subGraph} attribute
   */
  @Override
  public Function<T, Optional<GraphAsDot.SubGraph<T>>> subGraph() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.subGraph()
        : this.subGraph;
  }

  /**
   * @return The value of the {@code sortedBy} attribute
   */
  @Override
  public Optional<Function<T, Comparable>> sortedBy() {
    return Optional.ofNullable(sortedBy);
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @Override
  public String label() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.label()
        : this.label;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GraphAsDot#nodeAsId() nodeAsId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nodeAsId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGraphAsDot<T> withNodeAsId(Function<T, String> value) {
    if (this.nodeAsId == value) return this;
    Function<T, String> newValue = Objects.requireNonNull(value, "nodeAsId");
    return new ImmutableGraphAsDot<>(
        newValue,
        this.subGraphIdSeparator,
        this.nodeAsLabel,
        this.edgeAttributes,
        this.nodeAttributes,
        this.subGraph,
        this.sortedBy,
        this.label);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GraphAsDot#subGraphIdSeparator() subGraphIdSeparator} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for subGraphIdSeparator
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGraphAsDot<T> withSubGraphIdSeparator(String value) {
    String newValue = Objects.requireNonNull(value, "subGraphIdSeparator");
    if (this.subGraphIdSeparator.equals(newValue)) return this;
    return new ImmutableGraphAsDot<>(
        this.nodeAsId,
        newValue,
        this.nodeAsLabel,
        this.edgeAttributes,
        this.nodeAttributes,
        this.subGraph,
        this.sortedBy,
        this.label);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GraphAsDot#nodeAsLabel() nodeAsLabel} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nodeAsLabel
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGraphAsDot<T> withNodeAsLabel(Function<T, String> value) {
    if (this.nodeAsLabel == value) return this;
    Function<T, String> newValue = Objects.requireNonNull(value, "nodeAsLabel");
    return new ImmutableGraphAsDot<>(
        this.nodeAsId,
        this.subGraphIdSeparator,
        newValue,
        this.edgeAttributes,
        this.nodeAttributes,
        this.subGraph,
        this.sortedBy,
        this.label);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GraphAsDot#edgeAttributes() edgeAttributes} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for edgeAttributes
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGraphAsDot<T> withEdgeAttributes(BiFunction<T, T, Map<String, String>> value) {
    if (this.edgeAttributes == value) return this;
    BiFunction<T, T, Map<String, String>> newValue = Objects.requireNonNull(value, "edgeAttributes");
    return new ImmutableGraphAsDot<>(
        this.nodeAsId,
        this.subGraphIdSeparator,
        this.nodeAsLabel,
        newValue,
        this.nodeAttributes,
        this.subGraph,
        this.sortedBy,
        this.label);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GraphAsDot#nodeAttributes() nodeAttributes} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nodeAttributes
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGraphAsDot<T> withNodeAttributes(Function<T, Map<String, String>> value) {
    if (this.nodeAttributes == value) return this;
    Function<T, Map<String, String>> newValue = Objects.requireNonNull(value, "nodeAttributes");
    return new ImmutableGraphAsDot<>(
        this.nodeAsId,
        this.subGraphIdSeparator,
        this.nodeAsLabel,
        this.edgeAttributes,
        newValue,
        this.subGraph,
        this.sortedBy,
        this.label);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GraphAsDot#subGraph() subGraph} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for subGraph
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGraphAsDot<T> withSubGraph(Function<T, Optional<GraphAsDot.SubGraph<T>>> value) {
    if (this.subGraph == value) return this;
    Function<T, Optional<GraphAsDot.SubGraph<T>>> newValue = Objects.requireNonNull(value, "subGraph");
    return new ImmutableGraphAsDot<>(
        this.nodeAsId,
        this.subGraphIdSeparator,
        this.nodeAsLabel,
        this.edgeAttributes,
        this.nodeAttributes,
        newValue,
        this.sortedBy,
        this.label);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link GraphAsDot#sortedBy() sortedBy} attribute.
   * @param value The value for sortedBy
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGraphAsDot<T> withSortedBy(Function<T, Comparable> value) {
    Function<T, Comparable> newValue = Objects.requireNonNull(value, "sortedBy");
    if (this.sortedBy == newValue) return this;
    return new ImmutableGraphAsDot<>(
        this.nodeAsId,
        this.subGraphIdSeparator,
        this.nodeAsLabel,
        this.edgeAttributes,
        this.nodeAttributes,
        this.subGraph,
        newValue,
        this.label);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link GraphAsDot#sortedBy() sortedBy} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for sortedBy
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableGraphAsDot<T> withSortedBy(Optional<? extends Function<T, Comparable>> optional) {
    Function<T, Comparable> value = optional.orElse(null);
    if (this.sortedBy == value) return this;
    return new ImmutableGraphAsDot<>(
        this.nodeAsId,
        this.subGraphIdSeparator,
        this.nodeAsLabel,
        this.edgeAttributes,
        this.nodeAttributes,
        this.subGraph,
        value,
        this.label);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GraphAsDot#label() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for label
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGraphAsDot<T> withLabel(String value) {
    String newValue = Objects.requireNonNull(value, "label");
    if (this.label.equals(newValue)) return this;
    return new ImmutableGraphAsDot<>(
        this.nodeAsId,
        this.subGraphIdSeparator,
        this.nodeAsLabel,
        this.edgeAttributes,
        this.nodeAttributes,
        this.subGraph,
        this.sortedBy,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGraphAsDot} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGraphAsDot<?>
        && equalTo(0, (ImmutableGraphAsDot<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableGraphAsDot<?> another) {
    return nodeAsId.equals(another.nodeAsId)
        && subGraphIdSeparator.equals(another.subGraphIdSeparator)
        && nodeAsLabel.equals(another.nodeAsLabel)
        && edgeAttributes.equals(another.edgeAttributes)
        && nodeAttributes.equals(another.nodeAttributes)
        && subGraph.equals(another.subGraph)
        && Objects.equals(sortedBy, another.sortedBy)
        && label.equals(another.label);
  }

  /**
   * Computes a hash code from attributes: {@code nodeAsId}, {@code subGraphIdSeparator}, {@code nodeAsLabel}, {@code edgeAttributes}, {@code nodeAttributes}, {@code subGraph}, {@code sortedBy}, {@code label}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + nodeAsId.hashCode();
    h += (h << 5) + subGraphIdSeparator.hashCode();
    h += (h << 5) + nodeAsLabel.hashCode();
    h += (h << 5) + edgeAttributes.hashCode();
    h += (h << 5) + nodeAttributes.hashCode();
    h += (h << 5) + subGraph.hashCode();
    h += (h << 5) + Objects.hashCode(sortedBy);
    h += (h << 5) + label.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GraphAsDot} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("GraphAsDot{");
    builder.append("nodeAsId=").append(nodeAsId);
    builder.append(", ");
    builder.append("subGraphIdSeparator=").append(subGraphIdSeparator);
    builder.append(", ");
    builder.append("nodeAsLabel=").append(nodeAsLabel);
    builder.append(", ");
    builder.append("edgeAttributes=").append(edgeAttributes);
    builder.append(", ");
    builder.append("nodeAttributes=").append(nodeAttributes);
    builder.append(", ");
    builder.append("subGraph=").append(subGraph);
    if (sortedBy != null) {
      builder.append(", ");
      builder.append("sortedBy=").append(sortedBy);
    }
    builder.append(", ");
    builder.append("label=").append(label);
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link GraphAsDot} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable GraphAsDot instance
   */
  public static <T> ImmutableGraphAsDot<T> copyOf(GraphAsDot<T> instance) {
    if (instance instanceof ImmutableGraphAsDot<?>) {
      return (ImmutableGraphAsDot<T>) instance;
    }
    return ImmutableGraphAsDot.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGraphAsDot ImmutableGraphAsDot}.
   * <pre>
   * ImmutableGraphAsDot.&amp;lt;T&amp;gt;builder()
   *    .nodeAsId(function.Function&amp;lt;T, String&amp;gt;) // required {@link GraphAsDot#nodeAsId() nodeAsId}
   *    .subGraphIdSeparator(String) // optional {@link GraphAsDot#subGraphIdSeparator() subGraphIdSeparator}
   *    .nodeAsLabel(function.Function&amp;lt;T, String&amp;gt;) // optional {@link GraphAsDot#nodeAsLabel() nodeAsLabel}
   *    .edgeAttributes(function.BiFunction&amp;lt;T, T, Map&amp;lt;String, String&amp;gt;&amp;gt;) // optional {@link GraphAsDot#edgeAttributes() edgeAttributes}
   *    .nodeAttributes(function.Function&amp;lt;T, Map&amp;lt;String, String&amp;gt;&amp;gt;) // optional {@link GraphAsDot#nodeAttributes() nodeAttributes}
   *    .subGraph(function.Function&amp;lt;T, Optional&amp;lt;de.flapdoodle.graph.GraphAsDot.SubGraph&amp;lt;T&amp;gt;&amp;gt;&amp;gt;) // optional {@link GraphAsDot#subGraph() subGraph}
   *    .sortedBy(function.Function&amp;lt;T, Comparable&amp;gt;) // optional {@link GraphAsDot#sortedBy() sortedBy}
   *    .label(String) // optional {@link GraphAsDot#label() label}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @param nodeAsId {@code nodeAsId} parameter
   * @return A new ImmutableGraphAsDot builder
   */
  public static <T> ImmutableGraphAsDot.Builder<T> builder(Function<T, String> nodeAsId) {
    return new ImmutableGraphAsDot.Builder<>(nodeAsId);
  }

  static <T> ImmutableGraphAsDot.Builder<T> builder() {
    return new ImmutableGraphAsDot.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableGraphAsDot ImmutableGraphAsDot}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GraphAsDot", generator = "Immutables")
  public static final class Builder<T> {
    private static final long INIT_BIT_NODE_AS_ID = 0x1L;
    private long initBits = 0x1L;

    private Function<T, String> nodeAsId;
    private String subGraphIdSeparator;
    private Function<T, String> nodeAsLabel;
    private BiFunction<T, T, Map<String, String>> edgeAttributes;
    private Function<T, Map<String, String>> nodeAttributes;
    private Function<T, Optional<GraphAsDot.SubGraph<T>>> subGraph;
    private Function<T, Comparable> sortedBy;
    private String label;

    private Builder(Function<T, String> nodeAsId) {
      nodeAsId(nodeAsId);
    }

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GraphAsDot} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(GraphAsDot<T> instance) {
      Objects.requireNonNull(instance, "instance");
      this.nodeAsId(instance.nodeAsId());
      this.subGraphIdSeparator(instance.subGraphIdSeparator());
      this.nodeAsLabel(instance.nodeAsLabel());
      this.edgeAttributes(instance.edgeAttributes());
      this.nodeAttributes(instance.nodeAttributes());
      this.subGraph(instance.subGraph());
      Optional<Function<T, Comparable>> sortedByOptional = instance.sortedBy();
      if (sortedByOptional.isPresent()) {
        sortedBy(sortedByOptional);
      }
      this.label(instance.label());
      return this;
    }

    /**
     * Initializes the value for the {@link GraphAsDot#nodeAsId() nodeAsId} attribute.
     * @param nodeAsId The value for nodeAsId 
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder<T> nodeAsId(Function<T, String> nodeAsId) {
      this.nodeAsId = Objects.requireNonNull(nodeAsId, "nodeAsId");
      initBits &= ~INIT_BIT_NODE_AS_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link GraphAsDot#subGraphIdSeparator() subGraphIdSeparator} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GraphAsDot#subGraphIdSeparator() subGraphIdSeparator}.</em>
     * @param subGraphIdSeparator The value for subGraphIdSeparator 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> subGraphIdSeparator(String subGraphIdSeparator) {
      this.subGraphIdSeparator = Objects.requireNonNull(subGraphIdSeparator, "subGraphIdSeparator");
      return this;
    }

    /**
     * Initializes the value for the {@link GraphAsDot#nodeAsLabel() nodeAsLabel} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GraphAsDot#nodeAsLabel() nodeAsLabel}.</em>
     * @param nodeAsLabel The value for nodeAsLabel 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> nodeAsLabel(Function<T, String> nodeAsLabel) {
      this.nodeAsLabel = Objects.requireNonNull(nodeAsLabel, "nodeAsLabel");
      return this;
    }

    /**
     * Initializes the value for the {@link GraphAsDot#edgeAttributes() edgeAttributes} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GraphAsDot#edgeAttributes() edgeAttributes}.</em>
     * @param edgeAttributes The value for edgeAttributes 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> edgeAttributes(BiFunction<T, T, Map<String, String>> edgeAttributes) {
      this.edgeAttributes = Objects.requireNonNull(edgeAttributes, "edgeAttributes");
      return this;
    }

    /**
     * Initializes the value for the {@link GraphAsDot#nodeAttributes() nodeAttributes} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GraphAsDot#nodeAttributes() nodeAttributes}.</em>
     * @param nodeAttributes The value for nodeAttributes 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> nodeAttributes(Function<T, Map<String, String>> nodeAttributes) {
      this.nodeAttributes = Objects.requireNonNull(nodeAttributes, "nodeAttributes");
      return this;
    }

    /**
     * Initializes the value for the {@link GraphAsDot#subGraph() subGraph} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GraphAsDot#subGraph() subGraph}.</em>
     * @param subGraph The value for subGraph 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> subGraph(Function<T, Optional<GraphAsDot.SubGraph<T>>> subGraph) {
      this.subGraph = Objects.requireNonNull(subGraph, "subGraph");
      return this;
    }

    /**
     * Initializes the optional value {@link GraphAsDot#sortedBy() sortedBy} to sortedBy.
     * @param sortedBy The value for sortedBy
     * @return {@code this} builder for chained invocation
     */
    public final Builder<T> sortedBy(Function<T, Comparable> sortedBy) {
      this.sortedBy = Objects.requireNonNull(sortedBy, "sortedBy");
      return this;
    }

    /**
     * Initializes the optional value {@link GraphAsDot#sortedBy() sortedBy} to sortedBy.
     * @param sortedBy The value for sortedBy
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> sortedBy(Optional<? extends Function<T, Comparable>> sortedBy) {
      this.sortedBy = sortedBy.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link GraphAsDot#label() label} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GraphAsDot#label() label}.</em>
     * @param label The value for label 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> label(String label) {
      this.label = Objects.requireNonNull(label, "label");
      return this;
    }

    /**
     * Builds a new {@link ImmutableGraphAsDot ImmutableGraphAsDot}.
     * @return An immutable instance of GraphAsDot
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGraphAsDot<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGraphAsDot<T>(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NODE_AS_ID) != 0) attributes.add("nodeAsId");
      return "Cannot build GraphAsDot, some of required attributes are not set " + attributes;
    }
  }
}
