/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse;

import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.StateMapping;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="StateMapping", generator="Immutables")
public final class ImmutableStateMapping<T>
extends StateMapping<T> {
    private final StateID<T> source;
    private final StateID<T> destination;

    private ImmutableStateMapping(StateID<T> source, StateID<T> destination) {
        this.source = Objects.requireNonNull(source, "source");
        this.destination = Objects.requireNonNull(destination, "destination");
    }

    private ImmutableStateMapping(ImmutableStateMapping<T> original, StateID<T> source, StateID<T> destination) {
        this.source = source;
        this.destination = destination;
    }

    @Override
    public StateID<T> source() {
        return this.source;
    }

    @Override
    public StateID<T> destination() {
        return this.destination;
    }

    public final ImmutableStateMapping<T> withSource(StateID<T> value) {
        if (this.source == value) {
            return this;
        }
        StateID<T> newValue = Objects.requireNonNull(value, "source");
        return new ImmutableStateMapping<T>(this, newValue, this.destination);
    }

    public final ImmutableStateMapping<T> withDestination(StateID<T> value) {
        if (this.destination == value) {
            return this;
        }
        StateID<T> newValue = Objects.requireNonNull(value, "destination");
        return new ImmutableStateMapping<T>(this, this.source, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStateMapping && this.equalTo((ImmutableStateMapping)another);
    }

    private boolean equalTo(ImmutableStateMapping<?> another) {
        return this.source.equals(another.source) && this.destination.equals(another.destination);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + this.destination.hashCode();
        return h;
    }

    public String toString() {
        return "StateMapping{source=" + this.source + ", destination=" + this.destination + "}";
    }

    public static <T> ImmutableStateMapping<T> of(StateID<T> source, StateID<T> destination) {
        return new ImmutableStateMapping<T>(source, destination);
    }

    public static <T> ImmutableStateMapping<T> copyOf(StateMapping<T> instance) {
        if (instance instanceof ImmutableStateMapping) {
            return (ImmutableStateMapping)instance;
        }
        return ImmutableStateMapping.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="StateMapping", generator="Immutables")
    public static final class Builder<T> {
        private static final long INIT_BIT_SOURCE = 1L;
        private static final long INIT_BIT_DESTINATION = 2L;
        private long initBits = 3L;
        private StateID<T> source;
        private StateID<T> destination;

        private Builder() {
        }

        public final Builder<T> from(StateMapping<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.source(instance.source());
            this.destination(instance.destination());
            return this;
        }

        public final Builder<T> source(StateID<T> source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<T> destination(StateID<T> destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableStateMapping<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStateMapping(null, this.source, this.destination);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("source");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("destination");
            }
            return "Cannot build StateMapping, some of required attributes are not set " + attributes;
        }
    }
}

