/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.testdoc;

import de.flapdoodle.testdoc.Line;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="Line", generator="Immutables")
public final class ImmutableLine
implements Line {
    private final String className;
    private final String fileName;
    private final String methodName;
    private final int lineNumber;

    private ImmutableLine(String className, String fileName, String methodName, int lineNumber) {
        this.className = className;
        this.fileName = fileName;
        this.methodName = methodName;
        this.lineNumber = lineNumber;
    }

    @Override
    public String className() {
        return this.className;
    }

    @Override
    public String fileName() {
        return this.fileName;
    }

    @Override
    public String methodName() {
        return this.methodName;
    }

    @Override
    public int lineNumber() {
        return this.lineNumber;
    }

    public final ImmutableLine withClassName(String value) {
        String newValue = Objects.requireNonNull(value, "className");
        if (this.className.equals(newValue)) {
            return this;
        }
        return ImmutableLine.validate(new ImmutableLine(newValue, this.fileName, this.methodName, this.lineNumber));
    }

    public final ImmutableLine withFileName(String value) {
        String newValue = Objects.requireNonNull(value, "fileName");
        if (this.fileName.equals(newValue)) {
            return this;
        }
        return ImmutableLine.validate(new ImmutableLine(this.className, newValue, this.methodName, this.lineNumber));
    }

    public final ImmutableLine withMethodName(String value) {
        String newValue = Objects.requireNonNull(value, "methodName");
        if (this.methodName.equals(newValue)) {
            return this;
        }
        return ImmutableLine.validate(new ImmutableLine(this.className, this.fileName, newValue, this.lineNumber));
    }

    public final ImmutableLine withLineNumber(int value) {
        if (this.lineNumber == value) {
            return this;
        }
        return ImmutableLine.validate(new ImmutableLine(this.className, this.fileName, this.methodName, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLine && this.equalTo(0, (ImmutableLine)another);
    }

    private boolean equalTo(int synthetic, ImmutableLine another) {
        return this.className.equals(another.className) && this.fileName.equals(another.fileName) && this.methodName.equals(another.methodName) && this.lineNumber == another.lineNumber;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.className.hashCode();
        h += (h << 5) + this.fileName.hashCode();
        h += (h << 5) + this.methodName.hashCode();
        h += (h << 5) + this.lineNumber;
        return h;
    }

    public String toString() {
        return "Line{className=" + this.className + ", fileName=" + this.fileName + ", methodName=" + this.methodName + ", lineNumber=" + this.lineNumber + "}";
    }

    private static ImmutableLine validate(ImmutableLine instance) {
        instance.check();
        return instance;
    }

    public static ImmutableLine copyOf(Line instance) {
        if (instance instanceof ImmutableLine) {
            return (ImmutableLine)instance;
        }
        return ImmutableLine.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Line", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CLASS_NAME = 1L;
        private static final long INIT_BIT_FILE_NAME = 2L;
        private static final long INIT_BIT_METHOD_NAME = 4L;
        private static final long INIT_BIT_LINE_NUMBER = 8L;
        private long initBits = 15L;
        private String className;
        private String fileName;
        private String methodName;
        private int lineNumber;

        private Builder() {
        }

        public final Builder from(Line instance) {
            Objects.requireNonNull(instance, "instance");
            this.className(instance.className());
            this.fileName(instance.fileName());
            this.methodName(instance.methodName());
            this.lineNumber(instance.lineNumber());
            return this;
        }

        public final Builder className(String className) {
            this.className = Objects.requireNonNull(className, "className");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder fileName(String fileName) {
            this.fileName = Objects.requireNonNull(fileName, "fileName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder methodName(String methodName) {
            this.methodName = Objects.requireNonNull(methodName, "methodName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder lineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableLine build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableLine.validate(new ImmutableLine(this.className, this.fileName, this.methodName, this.lineNumber));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("className");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fileName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("methodName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("lineNumber");
            }
            return "Cannot build Line, some of required attributes are not set " + attributes;
        }
    }
}

