/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.testdoc;

import de.flapdoodle.testdoc.Includes;
import de.flapdoodle.testdoc.Line;
import de.flapdoodle.testdoc.Recording;
import de.flapdoodle.testdoc.ReplacementPattern;
import de.flapdoodle.testdoc.Resources;
import de.flapdoodle.testdoc.Stacktraces;
import de.flapdoodle.testdoc.TabSize;
import de.flapdoodle.testdoc.TemplateReference;

public class Recorder {
    public static Recording with(String template) {
        return Recorder.generateMarkDown(Stacktraces.Scope.CallerOfCallerWithDelegate, template, ReplacementPattern.DEFAULT, TabSize.spaces(8));
    }

    public static Recording with(String template, TabSize tabSize) {
        return Recorder.generateMarkDown(Stacktraces.Scope.CallerOfCallerWithDelegate, template, ReplacementPattern.DEFAULT, tabSize);
    }

    public static Recording with(String template, ReplacementPattern replacementPattern, TabSize tabSize) {
        return Recorder.generateMarkDown(Stacktraces.Scope.CallerOfCallerWithDelegate, template, replacementPattern, tabSize);
    }

    private static Recording generateMarkDown(Stacktraces.Scope scope, String template, ReplacementPattern replacementPattern, TabSize tabSize) {
        try {
            Line currentLine = Stacktraces.currentLine(scope);
            String testClassName = currentLine.className();
            Class<?> clazz = Class.forName(testClassName);
            return Recorder.with(clazz, template, replacementPattern, tabSize);
        }
        catch (ClassNotFoundException | RuntimeException rx) {
            throw new RuntimeException(rx);
        }
    }

    @Deprecated
    protected static Recording with(Class<?> clazz, String template, TabSize tabSize) {
        return new Recording(TemplateReference.of(clazz, template, ReplacementPattern.DEFAULT), Resources.sourceCodeOf(clazz, tabSize, new Includes[0]).get(), tabSize);
    }

    protected static Recording with(Class<?> clazz, String template, ReplacementPattern replacementPattern, TabSize tabSize) {
        return new Recording(TemplateReference.of(clazz, template, replacementPattern), Resources.sourceCodeOf(clazz, tabSize, new Includes[0]).get(), tabSize);
    }
}

