/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.testdoc;

import de.flapdoodle.testdoc.ImmutableTemplate;
import de.flapdoodle.testdoc.Preconditions;
import de.flapdoodle.testdoc.ReplacementPattern;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Template {
    public abstract String source();

    @Value.Default
    public ReplacementPattern pattern() {
        return ReplacementPattern.DEFAULT;
    }

    public static Template of(String source) {
        return ImmutableTemplate.builder().source(source).build();
    }

    public static Template of(String source, ReplacementPattern pattern) {
        return ImmutableTemplate.builder().source(source).pattern(pattern).build();
    }

    public static String render(Template template, Map<String, String> replacements) {
        return Template.render(template, (String key) -> (String)Preconditions.checkNotNull(replacements.get(key), "could not resolve %s in %s", key, replacements.keySet()));
    }

    public static String render(Template template, Map<String, String> replacements, BiFunction<String, Set<String>, String> fallback) {
        return Template.render(template, (String key) -> {
            String replacement = (String)replacements.get(key);
            if (replacement == null) {
                replacement = (String)Preconditions.checkNotNull(fallback.apply((String)key, replacements.keySet()), "fallback return null for %s", key);
            }
            return replacement;
        });
    }

    public static String render(Template template, Function<String, String> variableLookUp) {
        StringBuilder sb = new StringBuilder();
        String source = template.source();
        Matcher matcher = template.pattern().matcher(source);
        int lastEnd = 0;
        while (matcher.find()) {
            sb.append(source, lastEnd, matcher.start());
            sb.append(variableLookUp.apply(matcher.group("label")));
            lastEnd = matcher.end();
        }
        sb.append(source.substring(lastEnd));
        return sb.toString();
    }
}

