/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.testdoc;

import de.flapdoodle.testdoc.ImmutableTemplateReference;
import de.flapdoodle.testdoc.Preconditions;
import de.flapdoodle.testdoc.ReplacementPattern;
import de.flapdoodle.testdoc.Resources;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public interface TemplateReference {
    @Value.Parameter
    public Class<?> clazz();

    @Value.Parameter
    public String templateName();

    @Value.Default
    default public ReplacementPattern replacementPattern() {
        return ReplacementPattern.DEFAULT;
    }

    @Value.Lazy
    default public Optional<String> readContent() {
        try {
            return Optional.of(TemplateReference.readContent(this.clazz(), this.templateName()));
        }
        catch (RuntimeException rx) {
            return Optional.empty();
        }
    }

    public static TemplateReference of(Class<?> clazz, String templateName) {
        return ImmutableTemplateReference.of(clazz, templateName);
    }

    public static TemplateReference of(Class<?> clazz, String templateName, ReplacementPattern replacementPattern) {
        return ImmutableTemplateReference.of(clazz, templateName).withReplacementPattern(replacementPattern);
    }

    public static String readContent(Class<?> clazz, String template) {
        return Resources.read(() -> Preconditions.checkNotNull(clazz.getResourceAsStream(template), "could not get %s for %s", template, clazz));
    }
}

