/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.testdoc;

import de.flapdoodle.testdoc.ImmutableLine;
import de.flapdoodle.testdoc.Preconditions;
import org.immutables.value.Value;

@Value.Immutable
public interface Line {
    public String className();

    public String fileName();

    public String methodName();

    public int lineNumber();

    @Value.Auxiliary
    default public int lineIndex() {
        return this.lineNumber() - 1;
    }

    @Value.Check
    default public void check() {
        Preconditions.checkArgument(this.lineNumber() > 0, "invalid lineNumber: %s", this.lineNumber());
    }

    public static ImmutableLine.Builder builder() {
        return ImmutableLine.builder();
    }
}

