/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.testdoc;

import de.flapdoodle.testdoc.CalledMethod;
import de.flapdoodle.testdoc.End;
import de.flapdoodle.testdoc.HasLine;
import de.flapdoodle.testdoc.ImmutableReplacements;
import de.flapdoodle.testdoc.Preconditions;
import de.flapdoodle.testdoc.Recordings;
import de.flapdoodle.testdoc.ReplacementPattern;
import de.flapdoodle.testdoc.Replacements;
import de.flapdoodle.testdoc.Start;
import de.flapdoodle.testdoc.Template;
import de.flapdoodle.testdoc.TemplateReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class Renderer {
    private static Pattern WHITESPACES = Pattern.compile("\\s*");
    private static final String CLOSING_BRACE_REGEX = "\\s*}\\s*";

    protected static String renderTemplate(Recordings recordings) {
        Map<String, List<HasLine>> usedFilenames = recordings.lines().stream().collect(Collectors.groupingBy(l -> l.line().fileName()));
        Preconditions.checkArgument(usedFilenames.size() <= 1, "more than one used filename: ", usedFilenames.keySet());
        Map<String, List<HasLine>> methodNames = recordings.lines().stream().collect(Collectors.groupingBy(l -> l.line().methodName()));
        Map<String, List<Block>> recordingsByMethod = Renderer.recordingsByMethod(methodNames, recordings.linesOfCode());
        return Renderer.render(recordings, recordingsByMethod);
    }

    private static String render(Recordings recordings, Map<String, List<Block>> recordingsByMethod) {
        Map<String, String> joinedMap = Renderer.merge(recordings, recordingsByMethod);
        String templateContent = recordings.templateReference().readContent().orElseGet(() -> Renderer.templateFrom(recordings.templateReference(), joinedMap));
        ReplacementPattern replacementPattern = recordings.templateReference().replacementPattern();
        return recordings.replacementNotFoundFallback().isPresent() ? Template.render(Template.of(templateContent, replacementPattern), joinedMap, recordings.replacementNotFoundFallback().get()) : Template.render(Template.of(templateContent, replacementPattern), joinedMap);
    }

    private static String templateFrom(TemplateReference templateReference, Map<String, String> joinedMap) {
        String source = TemplateReference.readContent(Renderer.class, "template-is-missing-fallback.md");
        return Template.render(Template.of(source), Replacements.builder().putReplacement("templateName", templateReference.templateName()).putReplacement("templateClass", templateReference.clazz().getName()).putReplacement("recordedParts", joinedMap.keySet().stream().map(key -> "* `" + key + "`").collect(Collectors.joining("\n"))).build().replacement());
    }

    private static Map<String, String> merge(Recordings recordings, Map<String, List<Block>> recordingsByMethod) {
        LinkedHashSet usedKeys = new LinkedHashSet();
        ImmutableReplacements.Builder builder = Replacements.builder();
        recordingsByMethod.forEach((method, blocks) -> {
            builder.putReplacement((String)method, Renderer.formatBlocks(blocks));
            usedKeys.add(method);
            AtomicInteger counter = new AtomicInteger(0);
            for (Block block : blocks) {
                String blockLabel = method + "." + counter.incrementAndGet();
                builder.putReplacement(blockLabel, block.content);
                usedKeys.add(blockLabel);
                if (!block.label.isPresent()) continue;
                String secondBlockLabel = method + "." + block.label.get();
                builder.putReplacement(secondBlockLabel, block.content);
                usedKeys.add(secondBlockLabel);
            }
        });
        Function<String, BiConsumer> checkAndAddToBuilderFactory = scope -> (key, value) -> {
            Preconditions.checkArgument(!usedKeys.contains(key), scope + ": already set: %s", key);
            builder.putReplacement((String)key, (String)value);
            usedKeys.add(key);
        };
        recordings.classes().forEach(checkAndAddToBuilderFactory.apply("classes"));
        recordings.resources().forEach(checkAndAddToBuilderFactory.apply("resources"));
        recordings.output().forEach(checkAndAddToBuilderFactory.apply("output"));
        recordings.methodsCalled().forEach((label, calledMethod) -> {
            String methodCode = Renderer.findSurroundingMethodOf(recordings.linesOfCode(), calledMethod);
            builder.putReplacement((String)label, methodCode);
        });
        return builder.build().replacement();
    }

    private static String findSurroundingMethodOf(List<String> linesOfCode, CalledMethod calledMethod) {
        int i;
        int lineIndex = calledMethod.line().lineIndex();
        Preconditions.checkArgument(lineIndex <= linesOfCode.size(), "line number(%s) > lines of code(%s)", lineIndex, linesOfCode.size());
        int start = -1;
        int end = -1;
        for (i = lineIndex - 1; i >= 0; --i) {
            String line = linesOfCode.get(i);
            if (!line.contains(calledMethod.line().methodName())) continue;
            start = i;
            break;
        }
        Preconditions.checkArgument(start != -1, "could not find method declaration for " + calledMethod.line().methodName(), new Object[0]);
        for (i = lineIndex; i < linesOfCode.size(); ++i) {
            String lastLine = i > 0 ? linesOfCode.get(i - 1) : "{}";
            String line = linesOfCode.get(i);
            if (line.trim().isEmpty() && i > lineIndex) {
                if (!lastLine.matches(CLOSING_BRACE_REGEX)) continue;
                end = i;
                break;
            }
            if (i + 1 != linesOfCode.size() || !line.matches(CLOSING_BRACE_REGEX) || !lastLine.matches(CLOSING_BRACE_REGEX)) continue;
            end = i;
        }
        Preconditions.checkArgument(end != -1, "could not find end of method declaration for " + calledMethod.line().methodName(), new Object[0]);
        ArrayList<String> lines = new ArrayList<String>();
        lines.addAll(linesOfCode.subList(start, lineIndex));
        lines.addAll(linesOfCode.subList(lineIndex + 1, end + 1));
        return Renderer.blockOf(lines, 0, lines.size());
    }

    private static String formatBlocks(List<Block> blocks) {
        return blocks.stream().map(block -> block.content).collect(Collectors.joining("\n...\n\n"));
    }

    private static Map<String, List<Block>> recordingsByMethod(Map<String, List<HasLine>> methodNames, List<String> linesOfCode) {
        LinkedHashMap<String, List<Block>> ret = new LinkedHashMap<String, List<Block>>();
        for (String key : methodNames.keySet()) {
            ret.put(key, Renderer.recordings(methodNames.get(key), linesOfCode));
        }
        return ret;
    }

    private static List<Block> recordings(List<HasLine> list, List<String> linesOfCode) {
        ArrayList<Block> ret = new ArrayList<Block>();
        List sortedLineNumbers = list.stream().sorted(Comparator.comparingInt(a -> a.line().lineNumber())).collect(Collectors.toList());
        Preconditions.checkArgument(sortedLineNumbers.size() % 2 == 0, "odd number of markers: %s", sortedLineNumbers);
        Start lastStart = null;
        for (HasLine line : sortedLineNumbers) {
            if (line instanceof Start) {
                Preconditions.checkArgument(lastStart == null, "start after start: %s - %s", lastStart, line);
                lastStart = (Start)line;
                continue;
            }
            if (line instanceof End) {
                Preconditions.checkNotNull(lastStart, "end but no start: %s", line);
                ret.add(new Block(Renderer.blockOf(linesOfCode, lastStart.line().lineNumber(), line.line().lineNumber()), lastStart.label()));
                lastStart = null;
                continue;
            }
            Preconditions.checkArgument(false, "hmm... should not happen: %s", line);
        }
        return ret;
    }

    private static String blockOf(List<String> linesOfCode, int startLineNumber, int endLineNumber) {
        return Renderer.shiftLeft(linesOfCode.subList(startLineNumber, endLineNumber - 1)).stream().collect(Collectors.joining("\n"));
    }

    private static List<String> shiftLeft(List<String> subList) {
        Optional<Integer> minWhitespaces = subList.stream().filter(line -> !line.trim().isEmpty()).map(line -> WHITESPACES.matcher((CharSequence)line)).filter(matcher -> matcher.find()).map(matcher -> matcher.end()).min(Comparator.naturalOrder());
        if (minWhitespaces.isPresent()) {
            int offset = minWhitespaces.get();
            return subList.stream().map(line -> line.length() < offset ? "" : line.substring(offset)).collect(Collectors.toList());
        }
        return subList;
    }

    private static class Block {
        final String content;
        final Optional<String> label;

        Block(String content, Optional<String> label) {
            this.content = content;
            this.label = label;
        }
    }
}

