/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.datasource;

import de.focus_shift.ManagerParameter;
import de.focus_shift.spi.ConfigurationService;
import de.focus_shift.util.ClassLoadingUtil;

public class ConfigurationServiceManager {
    private final ClassLoadingUtil classLoadingUtil = new ClassLoadingUtil();

    public ConfigurationService getConfigurationService(ManagerParameter parameter) {
        this.validateConfiguration(parameter);
        String dataSourceClassName = parameter.getProperty("configuration.datasource.impl");
        return this.instantiateDataSource(dataSourceClassName);
    }

    private ConfigurationService instantiateDataSource(String dataSourceClassName) {
        try {
            Class<?> dataSourceClass = this.classLoadingUtil.loadClass(dataSourceClassName);
            return (ConfigurationService)dataSourceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot instantiate datasource instance of " + dataSourceClassName, e);
        }
    }

    private void validateConfiguration(ManagerParameter parameter) {
        if (parameter.getProperty("configuration.datasource.impl") == null) {
            throw new IllegalStateException("Missing holiday configuration datasource implementation class under config key configuration.datasource.impl");
        }
    }
}

