/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoadingUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ClassLoadingUtil.class);

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className, true, this.getClassloader());
        }
        catch (Exception e) {
            LOG.warn("Could not load class with current threads context classloader. Using default. Reason: {}: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return Class.forName(className);
        }
    }

    public ClassLoader getClassloader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

