/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.configuration.impl;

import de.focus_shift.configuration.ConfigurationProvider;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLConfigurationProvider
implements ConfigurationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(URLConfigurationProvider.class);

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        String configURLs = System.getProperty("de.focus_shift.config.urls");
        if (configURLs != null) {
            String[] strConfigURLs;
            for (String strURL : strConfigURLs = configURLs.split(",")) {
                this.readPropertiesFromURL(properties, strURL);
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPropertiesFromURL(Properties properties, String strURL) {
        if (strURL == null || "".equals(strURL)) {
            return;
        }
        InputStream inputStream = null;
        try {
            URL configURL = new URL(strURL.trim());
            inputStream = configURL.openStream();
            properties.load(inputStream);
            this.closeStreamFromURL(strURL, inputStream);
        }
        catch (Exception e) {
            try {
                LOG.warn("Cannot read configuration from '{}'.", (Object)strURL, (Object)e);
                this.closeStreamFromURL(strURL, inputStream);
            }
            catch (Throwable throwable) {
                this.closeStreamFromURL(strURL, inputStream);
                throw throwable;
            }
        }
    }

    private void closeStreamFromURL(String strURL, InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                LOG.warn("Cannot close stream for configuration URL {}.", (Object)strURL);
            }
        }
    }
}

