/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.parser.functions;

import de.focus_shift.spi.FixedWeekdayInMonth;
import de.focus_shift.spi.Occurrance;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.function.Function;

public class FindWeekDayInMonth
implements Function<FixedWeekdayInMonth, LocalDate> {
    private final int year;

    public FindWeekDayInMonth(int year) {
        this.year = year;
    }

    @Override
    public LocalDate apply(FixedWeekdayInMonth fixedWeekdayInMonth) {
        LocalDate date = LocalDate.of(this.year, fixedWeekdayInMonth.month(), 1);
        DayOfWeek weekday = fixedWeekdayInMonth.weekday();
        if (Occurrance.LAST == fixedWeekdayInMonth.which()) {
            return date.with(TemporalAdjusters.lastInMonth(weekday));
        }
        return date.with(TemporalAdjusters.dayOfWeekInMonth(fixedWeekdayInMonth.which().ordinal() + 1, weekday));
    }
}

