/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.caching;

import de.focus_shift.jollyday.core.HolidayManager;
import de.focus_shift.jollyday.core.ManagerParameter;
import de.focus_shift.jollyday.core.caching.Cache;
import de.focus_shift.jollyday.core.datasource.ConfigurationServiceManager;
import de.focus_shift.jollyday.core.spi.ConfigurationService;
import de.focus_shift.jollyday.core.util.ClassLoadingUtil;

public class HolidayManagerValueHandler
implements Cache.ValueHandler<HolidayManager> {
    private final ManagerParameter parameter;
    private final String managerImplClassName;
    private final ConfigurationServiceManager configurationServiceManager = new ConfigurationServiceManager();
    private final ClassLoadingUtil classLoadingUtil = new ClassLoadingUtil();

    public HolidayManagerValueHandler(ManagerParameter parameter, String managerImplClassName) {
        this.parameter = parameter;
        this.managerImplClassName = managerImplClassName;
    }

    @Override
    public String getKey() {
        return this.parameter.createCacheKey();
    }

    @Override
    public HolidayManager createValue() {
        HolidayManager manager = this.instantiateManagerImpl(this.managerImplClassName);
        ConfigurationService configurationService = this.configurationServiceManager.getConfigurationService(this.parameter);
        manager.setConfigurationService(configurationService);
        manager.init(this.parameter);
        return manager;
    }

    private HolidayManager instantiateManagerImpl(String managerImplClassName) {
        try {
            Class<?> managerImplClass = this.classLoadingUtil.loadClass(managerImplClassName);
            return (HolidayManager)managerImplClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create manager class " + managerImplClassName, e);
        }
    }
}

