/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.parameter;

import de.focus_shift.jollyday.core.parameter.BaseManagerParameter;
import de.focus_shift.jollyday.core.util.ResourceUtil;
import java.net.URL;
import java.util.Properties;

public class CalendarPartManagerParameter
extends BaseManagerParameter {
    private static final String FILE_PREFIX = "holidays/Holidays";
    private static final String FILE_SUFFIX = ".xml";
    private final ResourceUtil resourceUtil = new ResourceUtil();
    private final String calendarPart;

    public CalendarPartManagerParameter(String calendarPart, Properties properties) {
        super(properties);
        this.calendarPart = calendarPart;
    }

    @Override
    public String createCacheKey() {
        return this.calendarPart;
    }

    @Override
    public String getDisplayName() {
        return this.calendarPart;
    }

    @Override
    public URL createResourceUrl() {
        String configurationFileName = CalendarPartManagerParameter.getConfigurationFileName(this.calendarPart);
        return this.resourceUtil.getResource(configurationFileName);
    }

    @Override
    public String getManagerImplClassName() {
        String className = this.getProperty("manager.impl." + this.calendarPart);
        if (className == null) {
            className = super.getManagerImplClassName();
        }
        return className;
    }

    public static String getConfigurationFileName(String country) {
        return "holidays/Holidays_" + country + FILE_SUFFIX;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " - " + this.calendarPart;
    }
}

