/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.caching;

import de.focus_shift.HolidayManager;
import de.focus_shift.ManagerParameter;
import de.focus_shift.datasource.ConfigurationServiceManager;
import de.focus_shift.spi.ConfigurationService;
import de.focus_shift.util.Cache;
import de.focus_shift.util.ClassLoadingUtil;

public class HolidayManagerValueHandler
implements Cache.ValueHandler<HolidayManager> {
    private final ManagerParameter parameter;
    private final String managerImplClassName;
    private final ConfigurationServiceManager configurationServiceManager = new ConfigurationServiceManager();
    private final ClassLoadingUtil classLoadingUtil = new ClassLoadingUtil();

    public HolidayManagerValueHandler(ManagerParameter parameter, String managerImplClassName) {
        this.parameter = parameter;
        this.managerImplClassName = managerImplClassName;
    }

    @Override
    public String getKey() {
        return this.parameter.createCacheKey();
    }

    @Override
    public HolidayManager createValue() {
        HolidayManager manager = this.instantiateManagerImpl(this.managerImplClassName);
        ConfigurationService configurationService = this.configurationServiceManager.getConfigurationService(this.parameter);
        manager.setConfigurationService(configurationService);
        manager.init(this.parameter);
        return manager;
    }

    private HolidayManager instantiateManagerImpl(String managerImplClassName) {
        try {
            Class<?> managerImplClass = this.classLoadingUtil.loadClass(managerImplClassName);
            Object managerImplObject = managerImplClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return (HolidayManager)HolidayManager.class.cast(managerImplObject);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create manager class " + managerImplClassName, e);
        }
    }
}

