/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.jackson;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import de.focus_shift.jollyday.jackson.mapping.Configuration;
import de.focus_shift.jollyday.jackson.mapping.HolidayType;
import de.focus_shift.jollyday.jackson.mapping.Month;
import de.focus_shift.jollyday.jackson.mapping.Weekday;
import java.io.InputStream;
import java.time.DayOfWeek;

public class XMLUtil {
    private final XmlMapper mapper = new XmlMapper();

    public XMLUtil() {
        this.mapper.setPropertyNamingStrategy(PropertyNamingStrategies.UPPER_CAMEL_CASE);
    }

    public Configuration unmarshallConfiguration(InputStream stream) {
        try {
            return (Configuration)this.mapper.readValue(stream, Configuration.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot parse holidays XML file.", e);
        }
    }

    public final DayOfWeek getWeekday(Weekday weekday) {
        return DayOfWeek.valueOf(weekday.value());
    }

    public int getMonth(Month month) {
        return month.ordinal() + 1;
    }

    public de.focus_shift.jollyday.core.HolidayType getType(HolidayType type) {
        switch (type) {
            case OFFICIAL_HOLIDAY: {
                return de.focus_shift.jollyday.core.HolidayType.OFFICIAL_HOLIDAY;
            }
            case UNOFFICIAL_HOLIDAY: {
                return de.focus_shift.jollyday.core.HolidayType.UNOFFICIAL_HOLIDAY;
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }
}

