/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.jaxb;

import de.focus_shift.jollyday.core.util.ClassLoadingUtil;
import de.focus_shift.jollyday.jaxb.mapping.Configuration;
import de.focus_shift.jollyday.jaxb.mapping.HolidayType;
import de.focus_shift.jollyday.jaxb.mapping.Month;
import de.focus_shift.jollyday.jaxb.mapping.ObjectFactory;
import de.focus_shift.jollyday.jaxb.mapping.Weekday;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.InputStream;
import java.time.DayOfWeek;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLUtil {
    private static final String PACKAGE = "de.focus_shift.jollyday.jaxb.mapping";
    private static final Logger LOG = LoggerFactory.getLogger(XMLUtil.class);
    private JAXBContextCreator contextCreator = new JAXBContextCreator();

    public Configuration unmarshallConfiguration(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("Stream is NULL. Cannot read XML.");
        }
        try {
            JAXBContext ctx;
            try {
                ctx = this.contextCreator.create(PACKAGE, ClassLoadingUtil.getClassloader());
            }
            catch (JAXBException e) {
                LOG.warn("Could not create JAXB context using the current threads context classloader. Falling back to ObjectFactory class classloader.");
                ctx = null;
            }
            if (ctx == null) {
                ctx = this.contextCreator.create(PACKAGE, ObjectFactory.class.getClassLoader());
            }
            Unmarshaller um = ctx.createUnmarshaller();
            JAXBElement el = (JAXBElement)um.unmarshal(stream);
            return (Configuration)el.getValue();
        }
        catch (JAXBException ue) {
            throw new IllegalStateException("Cannot parse holidays XML file.", ue);
        }
    }

    public final DayOfWeek getWeekday(Weekday weekday) {
        return DayOfWeek.valueOf(weekday.value());
    }

    public int getMonth(Month month) {
        return month.ordinal() + 1;
    }

    public de.focus_shift.jollyday.core.HolidayType getType(HolidayType type) {
        switch (type) {
            case OFFICIAL_HOLIDAY: {
                return de.focus_shift.jollyday.core.HolidayType.OFFICIAL_HOLIDAY;
            }
            case UNOFFICIAL_HOLIDAY: {
                return de.focus_shift.jollyday.core.HolidayType.UNOFFICIAL_HOLIDAY;
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    public static class JAXBContextCreator {
        public JAXBContext create(String packageName, ClassLoader classLoader) throws JAXBException {
            return JAXBContext.newInstance((String)packageName, (ClassLoader)classLoader);
        }
    }
}

