/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.launchpad.core;

import de.focus_shift.launchpad.core.AppName;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;

public final class App {
    private final URL url;
    private final AppName appName;
    private final String icon;
    private final String authority;

    App(URL url, AppName appName, String icon) {
        this(url, appName, icon, null);
    }

    App(URL url, AppName appName, String icon, String authority) {
        this.url = url;
        this.appName = appName;
        this.icon = icon;
        this.authority = authority;
    }

    public URL getUrl() {
        return this.url;
    }

    public AppName getAppName() {
        return this.appName;
    }

    public String getIcon() {
        return this.icon;
    }

    public Optional<String> getAuthority() {
        return Optional.ofNullable(this.authority);
    }

    public String toString() {
        return "App{url=" + this.url + ", appName=" + this.appName + ", icon='" + this.icon + "', authority='" + this.authority + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        App app = (App)o;
        return Objects.equals(this.url, app.url) && Objects.equals(this.appName, app.appName) && Objects.equals(this.icon, app.icon) && Objects.equals(this.authority, app.authority);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.appName, this.icon, this.authority);
    }
}

