/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.launchpad.core;

import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="launchpad")
class LaunchpadConfigProperties {
    @NotNull
    private Locale nameDefaultLocale;
    private List<App> apps = List.of();

    LaunchpadConfigProperties() {
    }

    public Locale getNameDefaultLocale() {
        return this.nameDefaultLocale;
    }

    public void setNameDefaultLocale(Locale nameDefaultLocale) {
        this.nameDefaultLocale = nameDefaultLocale;
    }

    List<App> getApps() {
        return this.apps;
    }

    void setApps(List<App> apps) {
        this.apps = apps;
    }

    @Validated
    static class App {
        @NotNull
        private String url;
        @NotNull
        private Map<Locale, String> name;
        @NotEmpty
        private String icon;
        private String authority;

        App() {
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Map<Locale, String> getName() {
            return this.name;
        }

        public void setName(Map<Locale, String> name) {
            this.name = name;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public String getAuthority() {
            return this.authority;
        }

        public void setAuthority(String authority) {
            this.authority = authority;
        }
    }
}

