/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.launchpad.core;

import de.focus_shift.launchpad.api.LaunchpadAppUrlCustomizer;
import de.focus_shift.launchpad.core.App;
import de.focus_shift.launchpad.core.AppName;
import de.focus_shift.launchpad.core.Launchpad;
import de.focus_shift.launchpad.core.LaunchpadConfigProperties;
import de.focus_shift.launchpad.core.LaunchpadService;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

class LaunchpadServiceImpl
implements LaunchpadService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final LaunchpadConfigProperties appsProperties;
    private final LaunchpadAppUrlCustomizer appUrlCustomizer;

    LaunchpadServiceImpl(LaunchpadConfigProperties appsProperties, LaunchpadAppUrlCustomizer appUrlCustomizer) {
        this.appsProperties = appsProperties;
        this.appUrlCustomizer = appUrlCustomizer;
    }

    @Override
    public Launchpad getLaunchpad(Authentication authentication) {
        return new Launchpad(this.getApplications(authentication));
    }

    private List<App> getApplications(Authentication authentication) {
        return this.appsProperties.getApps().stream().map(this::toApp).filter(Optional::isPresent).flatMap(Optional::stream).filter(app -> this.isAllowed((App)app, authentication)).collect(Collectors.toList());
    }

    private boolean isAllowed(App app, Authentication authentication) {
        return app.getAuthority().map(authority -> authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).anyMatch(authority::equals)).orElse(true);
    }

    private Optional<App> toApp(LaunchpadConfigProperties.App app) {
        return this.getAppUrl(app).map(url -> {
            String defaultName = app.getName().get(this.appsProperties.getNameDefaultLocale());
            return new App((URL)url, new AppName(defaultName, app.getName()), app.getIcon(), app.getAuthority());
        });
    }

    private Optional<URL> getAppUrl(LaunchpadConfigProperties.App app) {
        try {
            return Optional.of(this.appUrlCustomizer.customize(app.getUrl()));
        }
        catch (MalformedURLException e) {
            LOG.info("ignoring launchpad app: could not build URL for app={}", (Object)app, (Object)e);
            return Optional.empty();
        }
    }
}

