/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.urlaubsverwaltung.extension.api.application;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import de.focus_shift.urlaubsverwaltung.extension.api.application.DayLength;
import java.time.Instant;
import java.util.Objects;
import lombok.NonNull;

@JsonDeserialize(builder=ApplicationPeriodDTOBuilder.class)
public final class ApplicationPeriodDTO {
    @NonNull
    private final Instant startDate;
    @NonNull
    private final Instant endDate;
    @NonNull
    private final DayLength dayLength;

    ApplicationPeriodDTO(@NonNull Instant startDate, @NonNull Instant endDate, @NonNull DayLength dayLength) {
        Objects.requireNonNull(startDate, "startDate is marked non-null but is null");
        Objects.requireNonNull(endDate, "endDate is marked non-null but is null");
        Objects.requireNonNull(dayLength, "dayLength is marked non-null but is null");
        this.startDate = startDate;
        this.endDate = endDate;
        this.dayLength = dayLength;
    }

    public static ApplicationPeriodDTOBuilder builder() {
        return new ApplicationPeriodDTOBuilder();
    }

    @NonNull
    public Instant getStartDate() {
        return this.startDate;
    }

    @NonNull
    public Instant getEndDate() {
        return this.endDate;
    }

    @NonNull
    public DayLength getDayLength() {
        return this.dayLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationPeriodDTO)) {
            return false;
        }
        ApplicationPeriodDTO other = (ApplicationPeriodDTO)o;
        Instant this$startDate = this.getStartDate();
        Instant other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Instant this$endDate = this.getEndDate();
        Instant other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        DayLength this$dayLength = this.getDayLength();
        DayLength other$dayLength = other.getDayLength();
        return !(this$dayLength == null ? other$dayLength != null : !((Object)((Object)this$dayLength)).equals((Object)other$dayLength));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Instant $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Instant $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        DayLength $dayLength = this.getDayLength();
        result = result * 59 + ($dayLength == null ? 43 : ((Object)((Object)$dayLength)).hashCode());
        return result;
    }

    public String toString() {
        return "ApplicationPeriodDTO(startDate=" + String.valueOf(this.getStartDate()) + ", endDate=" + String.valueOf(this.getEndDate()) + ", dayLength=" + String.valueOf((Object)this.getDayLength()) + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class ApplicationPeriodDTOBuilder {
        private Instant startDate;
        private Instant endDate;
        private DayLength dayLength;

        ApplicationPeriodDTOBuilder() {
        }

        public ApplicationPeriodDTOBuilder startDate(@NonNull Instant startDate) {
            Objects.requireNonNull(startDate, "startDate is marked non-null but is null");
            this.startDate = startDate;
            return this;
        }

        public ApplicationPeriodDTOBuilder endDate(@NonNull Instant endDate) {
            Objects.requireNonNull(endDate, "endDate is marked non-null but is null");
            this.endDate = endDate;
            return this;
        }

        public ApplicationPeriodDTOBuilder dayLength(@NonNull DayLength dayLength) {
            Objects.requireNonNull(dayLength, "dayLength is marked non-null but is null");
            this.dayLength = dayLength;
            return this;
        }

        public ApplicationPeriodDTO build() {
            return new ApplicationPeriodDTO(this.startDate, this.endDate, this.dayLength);
        }

        public String toString() {
            return "ApplicationPeriodDTO.ApplicationPeriodDTOBuilder(startDate=" + String.valueOf(this.startDate) + ", endDate=" + String.valueOf(this.endDate) + ", dayLength=" + String.valueOf((Object)this.dayLength) + ")";
        }
    }
}

