/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.urlaubsverwaltung.extension.api.person;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Clock;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import lombok.NonNull;

@JsonDeserialize(builder=PersonDeletedEventDTOBuilder.class)
public final class PersonDeletedEventDTO {
    @NonNull
    private final UUID id;
    @NonNull
    private final Instant createdAt;
    @NonNull
    private final String tenantId;
    @NonNull
    private final Long personId;
    @NonNull
    private final String username;
    @NonNull
    private final String lastName;
    @NonNull
    private final String firstName;
    @NonNull
    private final String email;
    private final boolean enabled;

    public static PersonDeletedEventDTO create(String tenantId, Long personId, String username, String lastName, String firstName, String email, boolean enabled) {
        return PersonDeletedEventDTO.create(tenantId, personId, username, lastName, firstName, email, enabled, Clock.systemUTC());
    }

    public static PersonDeletedEventDTO create(String tenantId, Long personId, String username, String lastName, String firstName, String email, boolean enabled, Clock clock) {
        return new PersonDeletedEventDTO(UUID.randomUUID(), Instant.now(clock), tenantId, personId, username, lastName, firstName, email, enabled);
    }

    PersonDeletedEventDTO(@NonNull UUID id, @NonNull Instant createdAt, @NonNull String tenantId, @NonNull Long personId, @NonNull String username, @NonNull String lastName, @NonNull String firstName, @NonNull String email, boolean enabled) {
        Objects.requireNonNull(id, "id is marked non-null but is null");
        Objects.requireNonNull(createdAt, "createdAt is marked non-null but is null");
        Objects.requireNonNull(tenantId, "tenantId is marked non-null but is null");
        Objects.requireNonNull(personId, "personId is marked non-null but is null");
        Objects.requireNonNull(username, "username is marked non-null but is null");
        Objects.requireNonNull(lastName, "lastName is marked non-null but is null");
        Objects.requireNonNull(firstName, "firstName is marked non-null but is null");
        Objects.requireNonNull(email, "email is marked non-null but is null");
        this.id = id;
        this.createdAt = createdAt;
        this.tenantId = tenantId;
        this.personId = personId;
        this.username = username;
        this.lastName = lastName;
        this.firstName = firstName;
        this.email = email;
        this.enabled = enabled;
    }

    public static PersonDeletedEventDTOBuilder builder() {
        return new PersonDeletedEventDTOBuilder();
    }

    @NonNull
    public UUID getId() {
        return this.id;
    }

    @NonNull
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @NonNull
    public String getTenantId() {
        return this.tenantId;
    }

    @NonNull
    public Long getPersonId() {
        return this.personId;
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    @NonNull
    public String getLastName() {
        return this.lastName;
    }

    @NonNull
    public String getFirstName() {
        return this.firstName;
    }

    @NonNull
    public String getEmail() {
        return this.email;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PersonDeletedEventDTO)) {
            return false;
        }
        PersonDeletedEventDTO other = (PersonDeletedEventDTO)o;
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Long this$personId = this.getPersonId();
        Long other$personId = other.getPersonId();
        if (this$personId == null ? other$personId != null : !((Object)this$personId).equals(other$personId)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        return !(this$email == null ? other$email != null : !this$email.equals(other$email));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Long $personId = this.getPersonId();
        result = result * 59 + ($personId == null ? 43 : ((Object)$personId).hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        return result;
    }

    public String toString() {
        return "PersonDeletedEventDTO(id=" + String.valueOf(this.getId()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", tenantId=" + this.getTenantId() + ", personId=" + this.getPersonId() + ", username=" + this.getUsername() + ", lastName=" + this.getLastName() + ", firstName=" + this.getFirstName() + ", email=" + this.getEmail() + ", enabled=" + this.isEnabled() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class PersonDeletedEventDTOBuilder {
        private UUID id;
        private Instant createdAt;
        private String tenantId;
        private Long personId;
        private String username;
        private String lastName;
        private String firstName;
        private String email;
        private boolean enabled;

        PersonDeletedEventDTOBuilder() {
        }

        public PersonDeletedEventDTOBuilder id(@NonNull UUID id) {
            Objects.requireNonNull(id, "id is marked non-null but is null");
            this.id = id;
            return this;
        }

        public PersonDeletedEventDTOBuilder createdAt(@NonNull Instant createdAt) {
            Objects.requireNonNull(createdAt, "createdAt is marked non-null but is null");
            this.createdAt = createdAt;
            return this;
        }

        public PersonDeletedEventDTOBuilder tenantId(@NonNull String tenantId) {
            Objects.requireNonNull(tenantId, "tenantId is marked non-null but is null");
            this.tenantId = tenantId;
            return this;
        }

        public PersonDeletedEventDTOBuilder personId(@NonNull Long personId) {
            Objects.requireNonNull(personId, "personId is marked non-null but is null");
            this.personId = personId;
            return this;
        }

        public PersonDeletedEventDTOBuilder username(@NonNull String username) {
            Objects.requireNonNull(username, "username is marked non-null but is null");
            this.username = username;
            return this;
        }

        public PersonDeletedEventDTOBuilder lastName(@NonNull String lastName) {
            Objects.requireNonNull(lastName, "lastName is marked non-null but is null");
            this.lastName = lastName;
            return this;
        }

        public PersonDeletedEventDTOBuilder firstName(@NonNull String firstName) {
            Objects.requireNonNull(firstName, "firstName is marked non-null but is null");
            this.firstName = firstName;
            return this;
        }

        public PersonDeletedEventDTOBuilder email(@NonNull String email) {
            Objects.requireNonNull(email, "email is marked non-null but is null");
            this.email = email;
            return this;
        }

        public PersonDeletedEventDTOBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public PersonDeletedEventDTO build() {
            return new PersonDeletedEventDTO(this.id, this.createdAt, this.tenantId, this.personId, this.username, this.lastName, this.firstName, this.email, this.enabled);
        }

        public String toString() {
            return "PersonDeletedEventDTO.PersonDeletedEventDTOBuilder(id=" + String.valueOf(this.id) + ", createdAt=" + String.valueOf(this.createdAt) + ", tenantId=" + this.tenantId + ", personId=" + this.personId + ", username=" + this.username + ", lastName=" + this.lastName + ", firstName=" + this.firstName + ", email=" + this.email + ", enabled=" + this.enabled + ")";
        }
    }
}

