/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.typeinference;

import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.symbolsolver.resolution.typeinference.Bound;
import com.github.javaparser.symbolsolver.resolution.typeinference.ConstraintFormulaSet;
import com.github.javaparser.symbolsolver.resolution.typeinference.InferenceVariable;
import com.github.javaparser.symbolsolver.resolution.typeinference.Instantiation;
import com.github.javaparser.symbolsolver.resolution.typeinference.InstantiationSet;
import com.github.javaparser.symbolsolver.resolution.typeinference.Substitution;
import com.github.javaparser.symbolsolver.resolution.typeinference.TypeHelper;
import com.github.javaparser.symbolsolver.resolution.typeinference.bounds.CapturesBound;
import com.github.javaparser.symbolsolver.resolution.typeinference.bounds.FalseBound;
import com.github.javaparser.symbolsolver.resolution.typeinference.bounds.SameAsBound;
import com.github.javaparser.symbolsolver.resolution.typeinference.bounds.SubtypeOfBound;
import com.github.javaparser.symbolsolver.resolution.typeinference.constraintformulas.TypeSameAsType;
import com.github.javaparser.symbolsolver.resolution.typeinference.constraintformulas.TypeSubtypeOfType;
import com.github.javaparser.utils.Pair;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class BoundSet {
    private List<Bound> bounds = new LinkedList<Bound>();
    private static final BoundSet EMPTY = new BoundSet();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundSet boundSet = (BoundSet)o;
        return new HashSet<Bound>(this.bounds).equals(new HashSet<Bound>(boundSet.bounds));
    }

    public int hashCode() {
        return this.bounds.hashCode();
    }

    public String toString() {
        return "BoundSet{bounds=" + this.bounds + '}';
    }

    public boolean isTrue() {
        return this.bounds.isEmpty();
    }

    public static BoundSet empty() {
        return EMPTY;
    }

    public BoundSet withBound(Bound bound) {
        if (this.bounds.contains(bound)) {
            return this;
        }
        BoundSet boundSet = new BoundSet();
        boundSet.bounds.addAll(this.bounds);
        boundSet.bounds.add(bound);
        return boundSet;
    }

    private Optional<Pair<SameAsBound, SameAsBound>> findPairSameAs(Predicate<Pair<SameAsBound, SameAsBound>> condition) {
        for (int i = 0; i < this.bounds.size(); ++i) {
            Bound bi = this.bounds.get(i);
            if (!(bi instanceof SameAsBound)) continue;
            SameAsBound si = (SameAsBound)bi;
            for (int j = i + 1; j < this.bounds.size(); ++j) {
                SameAsBound sj;
                Pair<SameAsBound, SameAsBound> pair;
                Bound bj = this.bounds.get(j);
                if (!(bj instanceof SameAsBound) || !condition.test(pair = new Pair<SameAsBound, SameAsBound>(si, sj = (SameAsBound)bj))) continue;
                return Optional.of(pair);
            }
        }
        return Optional.empty();
    }

    public boolean isEmpty() {
        return this.bounds.isEmpty();
    }

    private <T> T forEachPairSameAs(Processor<SameAsBound, SameAsBound, T> processor, T initialValue) {
        T currentValue = initialValue;
        for (int i = 0; i < this.bounds.size(); ++i) {
            Bound bi = this.bounds.get(i);
            if (!(bi instanceof SameAsBound)) continue;
            SameAsBound si = (SameAsBound)bi;
            for (int j = i + 1; j < this.bounds.size(); ++j) {
                Bound bj = this.bounds.get(j);
                if (!(bj instanceof SameAsBound)) continue;
                SameAsBound sj = (SameAsBound)bj;
                currentValue = processor.process(si, sj, currentValue);
            }
        }
        return currentValue;
    }

    private <T> T forEachPairSameAndSubtype(Processor<SameAsBound, SubtypeOfBound, T> processor, T initialValue) {
        T currentValue = initialValue;
        for (int i = 0; i < this.bounds.size(); ++i) {
            Bound bi = this.bounds.get(i);
            if (!(bi instanceof SameAsBound)) continue;
            SameAsBound si = (SameAsBound)bi;
            for (int j = i + 1; j < this.bounds.size(); ++j) {
                Bound bj = this.bounds.get(j);
                if (!(bj instanceof SubtypeOfBound)) continue;
                SubtypeOfBound sj = (SubtypeOfBound)bj;
                currentValue = processor.process(si, sj, currentValue);
            }
        }
        return currentValue;
    }

    private <T> T forEachPairSubtypeAndSubtype(Processor<SubtypeOfBound, SubtypeOfBound, T> processor, T initialValue) {
        T currentValue = initialValue;
        for (int i = 0; i < this.bounds.size(); ++i) {
            Bound bi = this.bounds.get(i);
            if (!(bi instanceof SubtypeOfBound)) continue;
            SubtypeOfBound si = (SubtypeOfBound)bi;
            for (int j = i + 1; j < this.bounds.size(); ++j) {
                Bound bj = this.bounds.get(j);
                if (!(bj instanceof SubtypeOfBound)) continue;
                SubtypeOfBound sj = (SubtypeOfBound)bj;
                currentValue = processor.process(si, sj, currentValue);
            }
        }
        return currentValue;
    }

    private boolean areSameTypeInference(ResolvedType a, ResolvedType b) {
        return TypeHelper.isInferenceVariable(a) && TypeHelper.isInferenceVariable(b) && a.equals(b);
    }

    private List<Pair<ResolvedReferenceType, ResolvedReferenceType>> findPairsOfCommonAncestors(ResolvedReferenceType r1, ResolvedReferenceType r2) {
        LinkedList<ResolvedReferenceType> set1 = new LinkedList<ResolvedReferenceType>();
        set1.add(r1);
        set1.addAll(r1.getAllAncestors());
        LinkedList<ResolvedReferenceType> set2 = new LinkedList<ResolvedReferenceType>();
        set2.add(r2);
        set2.addAll(r2.getAllAncestors());
        LinkedList<Pair<ResolvedReferenceType, ResolvedReferenceType>> pairs = new LinkedList<Pair<ResolvedReferenceType, ResolvedReferenceType>>();
        for (ResolvedReferenceType rtFrom1 : set1) {
            for (ResolvedReferenceType rtFrom2 : set2) {
                Optional<ResolvedReferenceTypeDeclaration> rtFrom1TypeDeclaration = rtFrom1.getTypeDeclaration();
                Optional<ResolvedReferenceTypeDeclaration> rtFrom2TypeDeclaration = rtFrom2.getTypeDeclaration();
                if (!rtFrom1TypeDeclaration.isPresent() || !rtFrom2TypeDeclaration.isPresent() || !rtFrom1TypeDeclaration.get().equals(rtFrom2TypeDeclaration.get())) continue;
                pairs.add(new Pair<ResolvedReferenceType, ResolvedReferenceType>(rtFrom1, rtFrom2));
            }
        }
        return pairs;
    }

    public BoundSet incorporate(BoundSet otherBounds, TypeSolver typeSolver) {
        BoundSet newBoundSet = this;
        for (Bound b : otherBounds.bounds) {
            newBoundSet = newBoundSet.withBound(b);
        }
        return newBoundSet.deriveImpliedBounds(typeSolver);
    }

    public BoundSet deriveImpliedBounds(TypeSolver typeSolver) {
        ConstraintFormulaSet newConstraintsSet = ConstraintFormulaSet.empty();
        newConstraintsSet = this.forEachPairSameAs((a, b, currentConstraintSet) -> {
            if (this.areSameTypeInference(a.getS(), b.getS())) {
                currentConstraintSet = currentConstraintSet.withConstraint(new TypeSameAsType(a.getT(), b.getT()));
            }
            if (this.areSameTypeInference(a.getS(), b.getT())) {
                currentConstraintSet = currentConstraintSet.withConstraint(new TypeSameAsType(a.getS(), b.getT()));
            }
            if (this.areSameTypeInference(a.getT(), b.getS())) {
                currentConstraintSet = currentConstraintSet.withConstraint(new TypeSameAsType(a.getT(), b.getS()));
            }
            if (this.areSameTypeInference(a.getT(), b.getT())) {
                currentConstraintSet = currentConstraintSet.withConstraint(new TypeSameAsType(a.getS(), b.getS()));
            }
            return currentConstraintSet;
        }, newConstraintsSet);
        newConstraintsSet = this.forEachPairSameAndSubtype((a, b, currentConstraintSet) -> {
            if (this.areSameTypeInference(a.getS(), b.getS())) {
                currentConstraintSet = currentConstraintSet.withConstraint(new TypeSubtypeOfType(typeSolver, a.getT(), b.getT()));
            }
            if (this.areSameTypeInference(a.getT(), b.getS())) {
                currentConstraintSet = currentConstraintSet.withConstraint(new TypeSubtypeOfType(typeSolver, a.getS(), b.getT()));
            }
            return currentConstraintSet;
        }, newConstraintsSet);
        newConstraintsSet = this.forEachPairSameAndSubtype((a, b, currentConstraintSet) -> {
            if (this.areSameTypeInference(a.getS(), b.getT())) {
                currentConstraintSet = currentConstraintSet.withConstraint(new TypeSubtypeOfType(typeSolver, b.getS(), a.getT()));
            }
            if (this.areSameTypeInference(a.getT(), b.getT())) {
                currentConstraintSet = currentConstraintSet.withConstraint(new TypeSubtypeOfType(typeSolver, b.getS(), a.getS()));
            }
            return currentConstraintSet;
        }, newConstraintsSet);
        newConstraintsSet = this.forEachPairSubtypeAndSubtype((a, b, currentConstraintSet) -> {
            if (this.areSameTypeInference(a.getT(), b.getS())) {
                currentConstraintSet = currentConstraintSet.withConstraint(new TypeSubtypeOfType(typeSolver, b.getS(), a.getT()));
            }
            return currentConstraintSet;
        }, newConstraintsSet);
        newConstraintsSet = this.forEachPairSameAs((a, b, currentConstraintSet) -> {
            Substitution sub;
            ResolvedType T;
            ResolvedType S;
            ResolvedType U;
            InferenceVariable alpha;
            if (TypeHelper.isInferenceVariable(a.getS()) && TypeHelper.isProperType(a.getT())) {
                alpha = (InferenceVariable)a.getS();
                U = a.getT();
                S = b.getS();
                T = b.getT();
                sub = Substitution.empty().withPair(alpha.getTypeParameterDeclaration(), U);
                currentConstraintSet = currentConstraintSet.withConstraint(new TypeSameAsType(sub.apply(S), sub.apply(T)));
            }
            if (TypeHelper.isInferenceVariable(a.getT()) && TypeHelper.isProperType(a.getS())) {
                alpha = (InferenceVariable)a.getT();
                U = a.getS();
                S = b.getS();
                T = b.getT();
                sub = Substitution.empty().withPair(alpha.getTypeParameterDeclaration(), U);
                currentConstraintSet = currentConstraintSet.withConstraint(new TypeSameAsType(sub.apply(S), sub.apply(T)));
            }
            if (TypeHelper.isInferenceVariable(b.getS()) && TypeHelper.isProperType(b.getT())) {
                alpha = (InferenceVariable)b.getS();
                U = b.getT();
                S = a.getS();
                T = a.getT();
                sub = Substitution.empty().withPair(alpha.getTypeParameterDeclaration(), U);
                currentConstraintSet = currentConstraintSet.withConstraint(new TypeSameAsType(sub.apply(S), sub.apply(T)));
            }
            if (TypeHelper.isInferenceVariable(b.getT()) && TypeHelper.isProperType(b.getS())) {
                alpha = (InferenceVariable)b.getT();
                U = b.getS();
                S = a.getS();
                T = a.getT();
                sub = Substitution.empty().withPair(alpha.getTypeParameterDeclaration(), U);
                currentConstraintSet = currentConstraintSet.withConstraint(new TypeSameAsType(sub.apply(S), sub.apply(T)));
            }
            return currentConstraintSet;
        }, newConstraintsSet);
        newConstraintsSet = this.forEachPairSameAndSubtype((a, b, currentConstraintSet) -> {
            Substitution sub;
            ResolvedType T;
            ResolvedType S;
            ResolvedType U;
            InferenceVariable alpha;
            if (TypeHelper.isInferenceVariable(a.getS()) && TypeHelper.isProperType(a.getT())) {
                alpha = (InferenceVariable)a.getS();
                U = a.getT();
                S = b.getS();
                T = b.getT();
                sub = Substitution.empty().withPair(alpha.getTypeParameterDeclaration(), U);
                currentConstraintSet = currentConstraintSet.withConstraint(new TypeSubtypeOfType(typeSolver, sub.apply(S), sub.apply(T)));
            }
            if (TypeHelper.isInferenceVariable(a.getT()) && TypeHelper.isProperType(a.getS())) {
                alpha = (InferenceVariable)a.getT();
                U = a.getS();
                S = b.getS();
                T = b.getT();
                sub = Substitution.empty().withPair(alpha.getTypeParameterDeclaration(), U);
                currentConstraintSet = currentConstraintSet.withConstraint(new TypeSubtypeOfType(typeSolver, sub.apply(S), sub.apply(T)));
            }
            return currentConstraintSet;
        }, newConstraintsSet);
        newConstraintsSet = this.forEachPairSubtypeAndSubtype((a, b, currentConstraintSet) -> {
            if (TypeHelper.isInferenceVariable(a.getS()) && TypeHelper.isInferenceVariable(b.getS()) && a.getT().isReferenceType() && b.getT().isReferenceType()) {
                ResolvedReferenceType S = a.getT().asReferenceType();
                ResolvedReferenceType T = b.getT().asReferenceType();
                List<Pair<ResolvedReferenceType, ResolvedReferenceType>> pairs = this.findPairsOfCommonAncestors(S, T);
                for (Pair<ResolvedReferenceType, ResolvedReferenceType> pair : pairs) {
                    for (int i = 0; i < Math.min(((ResolvedReferenceType)pair.a).typeParametersValues().size(), ((ResolvedReferenceType)pair.b).typeParametersValues().size()); ++i) {
                        ResolvedType si = ((ResolvedReferenceType)pair.a).typeParametersValues().get(i);
                        ResolvedType ti = ((ResolvedReferenceType)pair.b).typeParametersValues().get(i);
                        if (si.isWildcard() || ti.isWildcard()) continue;
                        currentConstraintSet = currentConstraintSet.withConstraint(new TypeSameAsType(si, ti));
                    }
                }
            }
            return currentConstraintSet;
        }, newConstraintsSet);
        Iterator iterator = this.bounds.stream().filter(b -> b instanceof CapturesBound).collect(Collectors.toList()).iterator();
        if (iterator.hasNext()) {
            Bound b2 = (Bound)iterator.next();
            CapturesBound capturesBound = (CapturesBound)b2;
            throw new UnsupportedOperationException();
        }
        if (newConstraintsSet.isEmpty()) {
            return this;
        }
        BoundSet newBounds = newConstraintsSet.reduce(typeSolver);
        if (newBounds.isEmpty()) {
            return this;
        }
        return this.incorporate(newBounds, typeSolver);
    }

    public boolean containsFalse() {
        return this.bounds.stream().anyMatch(it -> it instanceof FalseBound);
    }

    private Set<InferenceVariable> allInferenceVariables() {
        HashSet<InferenceVariable> variables = new HashSet<InferenceVariable>();
        for (Bound b : this.bounds) {
            variables.addAll(b.usedInferenceVariables());
        }
        return variables;
    }

    private boolean hasInstantiationFor(InferenceVariable v) {
        for (Bound b : this.bounds) {
            if (!b.isAnInstantiationFor(v)) continue;
            return true;
        }
        return false;
    }

    private Instantiation getInstantiationFor(InferenceVariable v) {
        for (Bound b : this.bounds) {
            if (!b.isAnInstantiationFor(v)) continue;
            return b.isAnInstantiation().get();
        }
        throw new IllegalArgumentException();
    }

    private boolean thereIsSomeJSuchThat\u03b2equalAlphaJ(Set<InferenceVariable> alphas, InferenceVariable beta) {
        for (InferenceVariable alphaJ : alphas) {
            for (Bound b : this.bounds) {
                if (!(b instanceof SameAsBound)) continue;
                SameAsBound sameAsBound = (SameAsBound)b;
                if (sameAsBound.getS().equals(alphaJ) && sameAsBound.getT().equals(beta)) {
                    return true;
                }
                if (!sameAsBound.getT().equals(alphaJ) || !sameAsBound.getS().equals(beta)) continue;
                return true;
            }
        }
        return false;
    }

    private <T> List<Set<T>> buildAllSubsetsOfSize(Set<T> allElements, int desiredSize) {
        if (desiredSize == allElements.size()) {
            return Arrays.asList(allElements);
        }
        LinkedList<Set<T>> res = new LinkedList<Set<T>>();
        for (T element : allElements) {
            Set<T> subset = this.allButOne(allElements, element);
            res.addAll(this.buildAllSubsetsOfSize(subset, desiredSize));
        }
        return res;
    }

    private <T> Set<T> allButOne(Set<T> elements, T element) {
        HashSet<T> set = new HashSet<T>(elements);
        set.remove(element);
        return set;
    }

    private Optional<Set<InferenceVariable>> smallestSetWithProperty(Set<InferenceVariable> uninstantiatedVariables, List<VariableDependency> dependencies) {
        for (int i = 1; i <= uninstantiatedVariables.size(); ++i) {
            for (Set<InferenceVariable> aSubSet : this.buildAllSubsetsOfSize(uninstantiatedVariables, i)) {
                if (!this.hasProperty(aSubSet, dependencies)) continue;
                return Optional.of(aSubSet);
            }
        }
        return Optional.empty();
    }

    private boolean hasProperty(Set<InferenceVariable> alphas, List<VariableDependency> dependencies) {
        for (InferenceVariable alphaI : alphas) {
            for (InferenceVariable beta : dependencies.stream().filter(d -> ((VariableDependency)d).depending.equals(alphaI)).filter(d -> !d.isReflexive()).map(d -> ((VariableDependency)d).dependedOn).collect(Collectors.toList())) {
                if (this.hasInstantiationFor(beta) || this.thereIsSomeJSuchThat\u03b2equalAlphaJ(alphas, beta)) continue;
                return false;
            }
        }
        return true;
    }

    public Optional<InstantiationSet> performResolution(List<InferenceVariable> variablesToResolve, TypeSolver typeSolver) {
        boolean bl;
        if (this.containsFalse()) {
            return Optional.empty();
        }
        LinkedList<VariableDependency> dependencies = new LinkedList<VariableDependency>();
        for (Bound bound : this.bounds) {
            if (!(bound instanceof CapturesBound)) continue;
            throw new UnsupportedOperationException();
        }
        for (Bound bound : this.bounds) {
            if (!(bound instanceof CapturesBound)) continue;
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < dependencies.size(); ++i) {
            VariableDependency variableDependency = (VariableDependency)dependencies.get(i);
            for (int j = i + 1; j < dependencies.size(); ++j) {
                VariableDependency dj = (VariableDependency)dependencies.get(j);
                if (!variableDependency.dependedOn.equals(dj.depending)) continue;
                dependencies.add(new VariableDependency(variableDependency.getDepending(), dj.getDependedOn()));
            }
        }
        for (InferenceVariable inferenceVariable : this.allInferenceVariables()) {
            dependencies.add(new VariableDependency(inferenceVariable, inferenceVariable));
        }
        HashSet<InferenceVariable> V = new HashSet<InferenceVariable>();
        V.addAll(variablesToResolve);
        for (VariableDependency dependency : dependencies) {
            if (!variablesToResolve.contains(dependency.depending)) continue;
            V.add(dependency.dependedOn);
        }
        boolean bl2 = true;
        for (InferenceVariable v : V) {
            if (this.hasInstantiationFor(v)) continue;
            bl = false;
        }
        if (bl) {
            InstantiationSet instantiationSet = InstantiationSet.empty();
            for (InferenceVariable v : V) {
                instantiationSet = instantiationSet.withInstantiation(this.getInstantiationFor(v));
            }
            return Optional.of(instantiationSet);
        }
        HashSet<InferenceVariable> uninstantiatedPortionOfV = new HashSet<InferenceVariable>();
        for (InferenceVariable v : V) {
            if (this.hasInstantiationFor(v)) continue;
            uninstantiatedPortionOfV.add(v);
        }
        Iterator<Object> iterator = this.allSetsWithProperty(uninstantiatedPortionOfV, dependencies).iterator();
        if (iterator.hasNext()) {
            Set alphas = (Set)iterator.next();
            boolean hasSomeCaptureForAlphas = alphas.stream().anyMatch(alphaI -> this.appearInLeftPartOfCapture((InferenceVariable)alphaI));
            if (!hasSomeCaptureForAlphas) {
                BoundSet newBounds = BoundSet.empty();
                for (InferenceVariable alphaI2 : alphas) {
                    Set<ResolvedType> properLowerBounds = this.bounds.stream().filter(b -> b.isProperLowerBoundFor(alphaI2).isPresent()).map(b -> b.isProperLowerBoundFor(alphaI2).get().getProperType()).collect(Collectors.toSet());
                    ResolvedType Ti = null;
                    if (properLowerBounds.size() > 0) {
                        Ti = TypeHelper.leastUpperBound(properLowerBounds);
                    }
                    boolean throwsBound = this.bounds.stream().anyMatch(b -> b.isThrowsBoundOn(alphaI2));
                    if (Ti == null && throwsBound && this.properUpperBoundsAreAtMostExceptionThrowableAndObject(alphaI2)) {
                        Ti = new ReferenceTypeImpl(typeSolver.solveType(RuntimeException.class.getCanonicalName()), typeSolver);
                    }
                    if (Ti == null) {
                        Set<ResolvedType> properUpperBounds = this.bounds.stream().filter(b -> b.isProperUpperBoundFor(alphaI2).isPresent()).map(b -> b.isProperUpperBoundFor(alphaI2).get().getProperType()).collect(Collectors.toSet());
                        if (properUpperBounds.size() == 0) {
                            throw new IllegalStateException();
                        }
                        Ti = TypeHelper.glb(properUpperBounds);
                    }
                    newBounds = newBounds.withBound(new SameAsBound(alphaI2, Ti));
                }
                BoundSet incorporatedBoundSet = this.incorporate(newBounds, typeSolver);
                if (!incorporatedBoundSet.containsFalse()) {
                    return incorporatedBoundSet.performResolution(variablesToResolve, typeSolver);
                }
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }
        return Optional.empty();
    }

    private Set<Set<InferenceVariable>> allPossibleSetsWithProperty(Set<InferenceVariable> allElements, List<VariableDependency> dependencies) {
        HashSet<Set<InferenceVariable>> result = new HashSet<Set<InferenceVariable>>();
        for (int i = 1; i <= allElements.size(); ++i) {
            for (Set<InferenceVariable> aSubSet : this.buildAllSubsetsOfSize(allElements, i)) {
                if (!this.hasProperty(aSubSet, dependencies)) continue;
                result.add(aSubSet);
            }
        }
        return result;
    }

    private boolean thereAreProperSubsets(Set<InferenceVariable> aSet, Set<Set<InferenceVariable>> allPossibleSets) {
        for (Set<InferenceVariable> anotherSet : allPossibleSets) {
            if (anotherSet.equals(aSet) || !this.isTheFirstAProperSubsetOfTheSecond(anotherSet, aSet)) continue;
            return true;
        }
        return false;
    }

    private boolean isTheFirstAProperSubsetOfTheSecond(Set<InferenceVariable> subset, Set<InferenceVariable> originalSet) {
        return originalSet.containsAll(subset) && originalSet.size() > subset.size();
    }

    private Set<Set<InferenceVariable>> allSetsWithProperty(Set<InferenceVariable> allElements, List<VariableDependency> dependencies) {
        Set<Set<InferenceVariable>> allPossibleSets = this.allPossibleSetsWithProperty(allElements, dependencies);
        HashSet<Set<InferenceVariable>> selected = new HashSet<Set<InferenceVariable>>();
        for (Set<InferenceVariable> aSet : allPossibleSets) {
            if (this.thereAreProperSubsets(aSet, allPossibleSets)) continue;
            selected.add(aSet);
        }
        return selected;
    }

    private boolean properUpperBoundsAreAtMostExceptionThrowableAndObject(InferenceVariable inferenceVariable) {
        throw new UnsupportedOperationException();
    }

    private boolean appearInLeftPartOfCapture(InferenceVariable inferenceVariable) {
        for (Bound b : this.bounds) {
            CapturesBound capturesBound;
            if (!(b instanceof CapturesBound) || !(capturesBound = (CapturesBound)b).getInferenceVariables().contains(inferenceVariable)) continue;
            return true;
        }
        return false;
    }

    public List<Bound> getProperUpperBoundsFor(InferenceVariable inferenceVariable) {
        return this.bounds.stream().filter(b -> b.isProperUpperBoundFor(inferenceVariable).isPresent()).collect(Collectors.toList());
    }

    private class VariableDependency {
        private InferenceVariable depending;
        private InferenceVariable dependedOn;

        public VariableDependency(InferenceVariable depending, InferenceVariable dependedOn) {
            this.depending = depending;
            this.dependedOn = dependedOn;
        }

        public InferenceVariable getDepending() {
            return this.depending;
        }

        public InferenceVariable getDependedOn() {
            return this.dependedOn;
        }

        public boolean isReflexive() {
            return this.dependedOn.equals(this.depending);
        }
    }

    static interface Processor<B1 extends Bound, B2 extends Bound, R> {
        public R process(B1 var1, B2 var2, R var3);
    }
}

