/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.java;

import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.AnnotationMemberDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.InitializerDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.java.JavaLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.passes.scopes.RecordScope;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class DeclarationHandler
extends Handler<Declaration, BodyDeclaration, JavaLanguageFrontend> {
    public DeclarationHandler(JavaLanguageFrontend lang) {
        super(Declaration::new, lang);
        this.map.put(com.github.javaparser.ast.body.MethodDeclaration.class, decl -> this.handleMethodDeclaration((com.github.javaparser.ast.body.MethodDeclaration)decl));
        this.map.put(ConstructorDeclaration.class, decl -> this.handleConstructorDeclaration((ConstructorDeclaration)decl));
        this.map.put(ClassOrInterfaceDeclaration.class, decl -> this.handleClassOrInterfaceDeclaration((ClassOrInterfaceDeclaration)decl));
        this.map.put(FieldDeclaration.class, decl -> this.handleFieldDeclaration((FieldDeclaration)decl));
        this.map.put(EnumDeclaration.class, decl -> this.handleEnumDeclaration((EnumDeclaration)decl));
        this.map.put(EnumConstantDeclaration.class, decl -> this.handleEnumConstantDeclaration((EnumConstantDeclaration)decl));
    }

    private static void addImplicitReturn(BlockStmt body) {
        NodeList<Statement> statements = body.getStatements();
        Statement lastStatement = null;
        if (!statements.isEmpty()) {
            lastStatement = (Statement)statements.get(statements.size() - 1);
        }
        if (lastStatement == null || !lastStatement.isReturnStmt()) {
            body.addStatement(new ReturnStmt());
        }
    }

    public de.fraunhofer.aisec.cpg.graph.declarations.ConstructorDeclaration handleConstructorDeclaration(ConstructorDeclaration constructorDecl) {
        ResolvedConstructorDeclaration resolvedConstructor = constructorDecl.resolve();
        de.fraunhofer.aisec.cpg.graph.declarations.ConstructorDeclaration declaration = NodeBuilder.newConstructorDeclaration(resolvedConstructor.getName(), constructorDecl.toString(), ((JavaLanguageFrontend)this.lang).getScopeManager().getCurrentRecord());
        ((JavaLanguageFrontend)this.lang).getScopeManager().addDeclaration(declaration);
        ((JavaLanguageFrontend)this.lang).getScopeManager().enterScope(declaration);
        declaration.getThrowsTypes().addAll(constructorDecl.getThrownExceptions().stream().map(type -> TypeParser.createFrom(type.asString(), true)).collect(Collectors.toList()));
        for (Parameter parameter : constructorDecl.getParameters()) {
            ParamVariableDeclaration param = NodeBuilder.newMethodParameterIn(parameter.getNameAsString(), ((JavaLanguageFrontend)this.lang).getTypeAsGoodAsPossible(parameter, parameter.resolve()), parameter.isVarArgs(), parameter.toString());
            declaration.getParameters().add(param);
            ((JavaLanguageFrontend)this.lang).setCodeAndRegion(param, parameter);
            ((JavaLanguageFrontend)this.lang).getScopeManager().addDeclaration(param);
        }
        Type type2 = TypeParser.createFrom(((JavaLanguageFrontend)this.lang).getScopeManager().getFirstScopeThat(RecordScope.class::isInstance).getAstNode().getName(), true);
        declaration.setType(type2);
        BlockStmt body = constructorDecl.getBody();
        DeclarationHandler.addImplicitReturn(body);
        declaration.setBody((de.fraunhofer.aisec.cpg.graph.statements.Statement)((JavaLanguageFrontend)this.lang).getStatementHandler().handle(body));
        ((JavaLanguageFrontend)this.lang).getScopeManager().leaveScope(declaration);
        return declaration;
    }

    public MethodDeclaration handleMethodDeclaration(com.github.javaparser.ast.body.MethodDeclaration methodDecl) {
        ResolvedMethodDeclaration resolvedMethod = methodDecl.resolve();
        MethodDeclaration functionDeclaration = NodeBuilder.newMethodDeclaration(resolvedMethod.getName(), methodDecl.toString(), methodDecl.isStatic(), ((JavaLanguageFrontend)this.lang).getScopeManager().getCurrentRecord());
        ((JavaLanguageFrontend)this.lang).getScopeManager().enterScope(functionDeclaration);
        functionDeclaration.getThrowsTypes().addAll(methodDecl.getThrownExceptions().stream().map(type -> TypeParser.createFrom(type.asString(), true)).collect(Collectors.toList()));
        for (Parameter parameter : methodDecl.getParameters()) {
            ParamVariableDeclaration param = NodeBuilder.newMethodParameterIn(parameter.getNameAsString(), ((JavaLanguageFrontend)this.lang).getTypeAsGoodAsPossible(parameter, parameter.resolve()), parameter.isVarArgs(), parameter.toString());
            functionDeclaration.getParameters().add(param);
            ((JavaLanguageFrontend)this.lang).setCodeAndRegion(param, parameter);
            ((JavaLanguageFrontend)this.lang).getScopeManager().addDeclaration(param);
        }
        functionDeclaration.setType(((JavaLanguageFrontend)this.lang).getReturnTypeAsGoodAsPossible(methodDecl, resolvedMethod));
        Optional<BlockStmt> o = methodDecl.getBody();
        if (o.isEmpty()) {
            ((JavaLanguageFrontend)this.lang).getScopeManager().leaveScope(functionDeclaration);
            return functionDeclaration;
        }
        BlockStmt body = o.get();
        DeclarationHandler.addImplicitReturn(body);
        functionDeclaration.setBody((de.fraunhofer.aisec.cpg.graph.statements.Statement)((JavaLanguageFrontend)this.lang).getStatementHandler().handle(body));
        ((JavaLanguageFrontend)this.lang).getScopeManager().leaveScope(functionDeclaration);
        return functionDeclaration;
    }

    public RecordDeclaration handleClassOrInterfaceDeclaration(ClassOrInterfaceDeclaration classInterDecl) {
        String name = classInterDecl.getNameAsString();
        name = this.getAbsoluteName(name);
        RecordDeclaration recordDeclaration = NodeBuilder.newRecordDeclaration(name, "class", classInterDecl.toString());
        recordDeclaration.setSuperClasses(classInterDecl.getExtendedTypes().stream().map(((JavaLanguageFrontend)this.lang)::getTypeAsGoodAsPossible).collect(Collectors.toList()));
        recordDeclaration.setImplementedInterfaces(classInterDecl.getImplementedTypes().stream().map(((JavaLanguageFrontend)this.lang)::getTypeAsGoodAsPossible).collect(Collectors.toList()));
        Map partitioned = ((JavaLanguageFrontend)this.lang).getContext().getImports().stream().collect(Collectors.partitioningBy(ImportDeclaration::isStatic, Collectors.mapping(i -> {
            Object iName = i.getNameAsString();
            if (i.isAsterisk() && !((String)iName).endsWith(".*")) {
                iName = (String)iName + ".*";
            }
            return iName;
        }, Collectors.toList())));
        recordDeclaration.setStaticImportStatements(partitioned.get(true));
        recordDeclaration.setImportStatements(partitioned.get(false));
        ((JavaLanguageFrontend)this.lang).getScopeManager().addDeclaration(recordDeclaration);
        ((JavaLanguageFrontend)this.lang).getScopeManager().enterScope(recordDeclaration);
        ((JavaLanguageFrontend)this.lang).getScopeManager().addDeclaration(recordDeclaration.getThis());
        for (BodyDeclaration<?> decl : classInterDecl.getMembers()) {
            if (decl instanceof FieldDeclaration) {
                this.handle(decl);
                continue;
            }
            if (decl instanceof com.github.javaparser.ast.body.MethodDeclaration) {
                MethodDeclaration md = (MethodDeclaration)this.handle(decl);
                recordDeclaration.getMethods().add(md);
                continue;
            }
            if (decl instanceof ConstructorDeclaration) {
                de.fraunhofer.aisec.cpg.graph.declarations.ConstructorDeclaration c = (de.fraunhofer.aisec.cpg.graph.declarations.ConstructorDeclaration)this.handle(decl);
                recordDeclaration.getConstructors().add(c);
                continue;
            }
            if (decl instanceof ClassOrInterfaceDeclaration) {
                recordDeclaration.getRecords().add((RecordDeclaration)this.handle(decl));
                continue;
            }
            log.debug("Member {} of type {} is something that we do not parse yet: {}", decl, recordDeclaration.getName(), decl.getClass().getSimpleName());
        }
        if (recordDeclaration.getConstructors().isEmpty()) {
            de.fraunhofer.aisec.cpg.graph.declarations.ConstructorDeclaration constructorDeclaration = NodeBuilder.newConstructorDeclaration(recordDeclaration.getName(), recordDeclaration.getName(), recordDeclaration);
            recordDeclaration.getConstructors().add(constructorDeclaration);
            ((JavaLanguageFrontend)this.lang).getScopeManager().addDeclaration(constructorDeclaration);
        }
        ((JavaLanguageFrontend)this.lang).getScopeManager().leaveScope(recordDeclaration);
        return recordDeclaration;
    }

    public de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration handleFieldDeclaration(FieldDeclaration fieldDecl) {
        Type type;
        VariableDeclarator variable = fieldDecl.getVariable(0);
        List<String> modifiers = fieldDecl.getModifiers().stream().map(modifier -> modifier.getKeyword().asString()).collect(Collectors.toList());
        String joinedModifiers = String.join((CharSequence)" ", modifiers) + " ";
        PhysicalLocation location = ((JavaLanguageFrontend)this.lang).getLocationFromRawNode(fieldDecl);
        Expression initializer = variable.getInitializer().map(((JavaLanguageFrontend)this.lang).getExpressionHandler()::handle).orElse(null);
        try {
            type = TypeParser.createFrom(joinedModifiers + variable.resolve().getType().describe(), true);
        }
        catch (UnsolvedSymbolException | UnsupportedOperationException e) {
            String t = ((JavaLanguageFrontend)this.lang).recoverTypeFromUnsolvedException(e);
            if (t == null) {
                log.warn("Could not resolve type for {}", (Object)variable);
                type = TypeParser.createFrom(joinedModifiers + variable.getType().asString(), true);
            }
            type = TypeParser.createFrom(joinedModifiers + t, true);
            type.setTypeOrigin(Type.Origin.GUESSED);
        }
        de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration fieldDeclaration = NodeBuilder.newFieldDeclaration(variable.getName().asString(), type, modifiers, variable.toString(), location, initializer, false);
        ((JavaLanguageFrontend)this.lang).getScopeManager().addDeclaration(fieldDeclaration);
        return fieldDeclaration;
    }

    public Declaration handleInitializerDeclaration(InitializerDeclaration initializerDecl) {
        return new Declaration();
    }

    public de.fraunhofer.aisec.cpg.graph.declarations.EnumDeclaration handleEnumDeclaration(EnumDeclaration enumDecl) {
        String name = this.getAbsoluteName(enumDecl.getNameAsString());
        PhysicalLocation location = ((JavaLanguageFrontend)this.lang).getLocationFromRawNode(enumDecl);
        de.fraunhofer.aisec.cpg.graph.declarations.EnumDeclaration enumDeclaration = NodeBuilder.newEnumDeclaration(name, enumDecl.toString(), location);
        List<de.fraunhofer.aisec.cpg.graph.declarations.EnumConstantDeclaration> entries = enumDecl.getEntries().stream().map(e -> (de.fraunhofer.aisec.cpg.graph.declarations.EnumConstantDeclaration)this.handle(e)).collect(Collectors.toList());
        entries.forEach(e -> e.setType(TypeParser.createFrom(enumDeclaration.getName(), true)));
        enumDeclaration.setEntries(entries);
        List<Type> superTypes = enumDecl.getImplementedTypes().stream().map(((JavaLanguageFrontend)this.lang)::getTypeAsGoodAsPossible).collect(Collectors.toList());
        enumDeclaration.setSuperTypes(superTypes);
        return enumDeclaration;
    }

    public de.fraunhofer.aisec.cpg.graph.declarations.EnumConstantDeclaration handleEnumConstantDeclaration(EnumConstantDeclaration enumConstDecl) {
        return NodeBuilder.newEnumConstantDeclaration(enumConstDecl.getNameAsString(), enumConstDecl.toString(), ((JavaLanguageFrontend)this.lang).getLocationFromRawNode(enumConstDecl));
    }

    public Declaration handleAnnotationDeclaration(AnnotationDeclaration annotationConstDecl) {
        return new Declaration();
    }

    public Declaration handleAnnotationMemberDeclaration(AnnotationMemberDeclaration annotationMemberDecl) {
        return new Declaration();
    }

    private String getAbsoluteName(String name) {
        String prefix = ((JavaLanguageFrontend)this.lang).getScopeManager().getCurrentNamePrefix();
        name = (String)(prefix != null && prefix.length() > 0 ? prefix + ((JavaLanguageFrontend)this.lang).getNamespaceDelimiter() : "") + (String)name;
        return name;
    }
}

