/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.declarations;

import de.fraunhofer.aisec.cpg.graph.DeclarationHolder;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.IncludeDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.NamespaceDeclaration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TranslationUnitDeclaration
extends Declaration
implements DeclarationHolder {
    @SubGraph(value={"AST"})
    private @NonNull List<Declaration> declarations = new ArrayList<Declaration>();
    @SubGraph(value={"AST"})
    private @NonNull List<Declaration> includes = new ArrayList<Declaration>();
    @SubGraph(value={"AST"})
    private @NonNull List<Declaration> namespaces = new ArrayList<Declaration>();

    public <T extends Declaration> @Nullable T getDeclarationAs(int i, Class<T> clazz) {
        Declaration declaration = this.declarations.get(i);
        if (declaration == null) {
            return null;
        }
        return (T)(declaration.getClass().isAssignableFrom(clazz) ? (Declaration)clazz.cast(this.declarations.get(i)) : null);
    }

    public <T extends Declaration> @NonNull Set<T> getDeclarationsByName(@NonNull String name, @NonNull Class<T> clazz) {
        return this.declarations.stream().filter(declaration -> clazz.isAssignableFrom(declaration.getClass())).map(clazz::cast).filter(declaration -> Objects.equals(declaration.getName(), name)).collect(Collectors.toSet());
    }

    public @NonNull List<Declaration> getDeclarations() {
        return this.declarations;
    }

    public @NonNull List<Declaration> getIncludes() {
        return Collections.unmodifiableList(this.includes);
    }

    public @NonNull List<Declaration> getNamespaces() {
        return Collections.unmodifiableList(this.namespaces);
    }

    @Override
    public void addDeclaration(@NonNull Declaration declaration) {
        if (declaration instanceof IncludeDeclaration) {
            this.includes.add(declaration);
        } else if (declaration instanceof NamespaceDeclaration) {
            this.namespaces.add(declaration);
        }
        this.addIfNotContains(this.declarations, declaration);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Node.TO_STRING_STYLE).append("declarations", this.declarations).append("includes", this.includes).append("namespaces", this.namespaces).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TranslationUnitDeclaration)) {
            return false;
        }
        TranslationUnitDeclaration that = (TranslationUnitDeclaration)o;
        return super.equals(that) && Objects.equals(this.declarations, that.declarations) && Objects.equals(this.includes, that.includes) && Objects.equals(this.namespaces, that.namespaces);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

