/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.neo4j.ogm.annotation.Relationship;

public class ExpressionList
extends Expression
implements HasType.TypeListener {
    @Relationship(value="SUBEXPR")
    @SubGraph(value={"AST"})
    private List<Statement> expressions = new ArrayList<Statement>();

    public List<Statement> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<Statement> expressions) {
        Statement lastExpression;
        if (!this.expressions.isEmpty()) {
            lastExpression = this.expressions.get(this.expressions.size() - 1);
            if (lastExpression instanceof HasType) {
                ((HasType)((Object)lastExpression)).unregisterTypeListener(this);
            }
            this.removePrevDFG(lastExpression);
        }
        this.expressions = expressions;
        if (!this.expressions.isEmpty()) {
            lastExpression = this.expressions.get(this.expressions.size() - 1);
            this.addPrevDFG(lastExpression);
            if (lastExpression instanceof HasType) {
                ((HasType)((Object)lastExpression)).registerTypeListener(this);
            }
        }
    }

    public void addExpression(Statement expression) {
        if (!this.expressions.isEmpty()) {
            Statement lastExpression = this.expressions.get(this.expressions.size() - 1);
            if (lastExpression instanceof HasType) {
                ((HasType)((Object)lastExpression)).unregisterTypeListener(this);
            }
            this.removePrevDFG(lastExpression);
        }
        this.expressions.add(expression);
        this.addPrevDFG(expression);
        if (expression instanceof HasType) {
            ((HasType)((Object)expression)).registerTypeListener(this);
        }
    }

    @Override
    public void typeChanged(HasType src, HasType root, Type oldType) {
        Type previous = this.type;
        this.setType(src.getPropagationType(), root);
        this.setPossibleSubTypes(new HashSet<Type>(src.getPossibleSubTypes()), root);
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, HasType root, Set<Type> oldSubTypes) {
        this.setPossibleSubTypes(new HashSet<Type>(src.getPossibleSubTypes()), root);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExpressionList)) {
            return false;
        }
        ExpressionList that = (ExpressionList)o;
        return super.equals(that) && Objects.equals(this.expressions, that.expressions);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

