/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.types;

import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ObjectType
extends Type {
    private final Modifier modifier;
    private final boolean primitive;
    private RecordDeclaration recordDeclaration = null;
    private List<Type> generics;

    public ObjectType(String typeName, Type.Storage storage, Type.Qualifier qualifier, List<Type> generics, Modifier modifier, boolean primitive) {
        super(typeName, storage, qualifier);
        this.generics = generics;
        this.modifier = modifier;
        this.primitive = primitive;
    }

    public ObjectType(Type type, List<Type> generics, Modifier modifier, boolean primitive) {
        super(type);
        this.generics = generics;
        this.modifier = modifier;
        this.primitive = primitive;
    }

    public ObjectType() {
        this.generics = new ArrayList<Type>();
        this.modifier = Modifier.NOT_APPLICABLE;
        this.primitive = false;
    }

    public List<Type> getGenerics() {
        return this.generics;
    }

    public RecordDeclaration getRecordDeclaration() {
        return this.recordDeclaration;
    }

    public void setRecordDeclaration(RecordDeclaration recordDeclaration) {
        this.recordDeclaration = recordDeclaration;
    }

    @Override
    public PointerType reference(PointerType.PointerOrigin pointerOrigin) {
        return new PointerType(this, pointerOrigin);
    }

    @Override
    public Type dereference() {
        return UnknownType.getUnknownType();
    }

    @Override
    public Type duplicate() {
        return new ObjectType(this, this.generics, this.modifier, this.primitive);
    }

    public void setGenerics(List<Type> generics) {
        this.generics = generics;
    }

    @Override
    public boolean isSimilar(Type t) {
        return t instanceof ObjectType && this.getGenerics().equals(((ObjectType)t).getGenerics()) && super.isSimilar(t);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectType that = (ObjectType)o;
        return Objects.equals(this.generics, that.generics) && this.primitive == that.primitive && this.modifier.equals((Object)that.modifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.generics, this.modifier, this.primitive});
    }

    @Override
    public String toString() {
        return "ObjectType{generics=" + this.generics + ", typeName='" + this.name + "', storage=" + this.getStorage() + ", qualifier=" + this.getQualifier() + ", modifier=" + this.modifier + ", primitive=" + this.primitive + ", origin=" + this.getTypeOrigin() + "}";
    }

    public static enum Modifier {
        SIGNED,
        UNSIGNED,
        NOT_APPLICABLE;

    }
}

